// https://github.com/CedricGuillemet/ImGuizmo
// v 1.89 WIP
//
// The MIT License(MIT)
//
// Copyright(c) 2021 Cedric Guillemet
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files(the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and / or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions :
//
// The above copyright notice and this permission notice shall be included in all
// copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
//
#pragma once

#include <cstddef>
#include "ImCurveEdit.h"
#include "engine/Engine.h"

struct CurvePoint {
	ImVec2 point;
	ImVec4 handles;
};

struct ImDrawList;
struct ImRect;
namespace ImSequencer
{
   enum SEQUENCER_OPTIONS
   {
      SEQUENCER_EDIT_NONE = 0,
      SEQUENCER_EDIT_STARTEND = 1 << 1,
      SEQUENCER_CHANGE_FRAME = 1 << 3,
      SEQUENCER_ADD = 1 << 4,
      SEQUENCER_DEL = 1 << 5,
      SEQUENCER_COPYPASTE = 1 << 6,
      SEQUENCER_EDIT_ALL = SEQUENCER_EDIT_STARTEND | SEQUENCER_CHANGE_FRAME
   };

   struct SequenceInterface
   {
      bool focused = false;
      virtual int GetFrameMin() const = 0;
      virtual int GetFrameMax() const = 0;
      virtual int GetLanesCount() const = 0;

      virtual void BeginEdit(int /*index*/) {}
      virtual void EndEdit() {}
      virtual int GetItemTypeCount() const { return 0; }
      virtual const char* GetItemTypeName(int /*typeIndex*/) const { return ""; }
      virtual const char* GetLaneLabel(int /*index*/) const { return ""; }
      virtual const char* GetCollapseFmt() const { return "%d Frames / %d entries"; }

      virtual void GetSequence(int sequence_idx, int** start, int** end, int* type, unsigned int* color) = 0;
      virtual void AddSequence(int /*type*/) {}
      virtual void DeleteSequence(int /*index*/) {}
      virtual void DuplicateSequence(int /*index*/) {}

      virtual void Copy() {}
      virtual void Paste() {}

      virtual size_t GetCustomHeight(int /*index*/) { return 0; }
      virtual void DoubleClick(int /*index*/) {}
      virtual void CustomDraw(int /*index*/, ImDrawList* /*draw_list*/, const ImRect& /*rc*/, const ImRect& /*legendRect*/, const ImRect& /*clippingRect*/, const ImRect& /*legendClippingRect*/) {}
      virtual void CustomDrawCompact(int /*index*/, ImDrawList* /*draw_list*/, const ImRect& /*rc*/, const ImRect& /*clippingRect*/) {}

       virtual ~SequenceInterface() = default;
   };


   // return true if selection is made
   bool DoSequencer(SequenceInterface* sequence, int* currentFrame, bool* expanded, int* selectedEntry, int* firstFrame, int sequenceOptions);

}


struct Curve {
	CurvePoint* curve_points;
	// ImVec4* curve_point_handles;
	SIMDString<256>* curve_name;
	size_t* curve_point_count;
	bool* curve_is_visible;
	int curve_idx;
	uint32_t colour;
	float get_value(float t = WEngine->time);
};

struct RampEdit : public ImCurveEdit::Delegate {
   RampEdit();

   size_t GetCurveCount();

   bool IsVisible(size_t curveIndex);

   size_t GetPointCount(size_t curveIndex);

   uint32_t GetCurveColor(size_t curveIndex);

   CurvePoint* GetPoints(size_t curveIndex);
   virtual ImCurveEdit::CurveType GetCurveType(size_t curveIndex) const;

   virtual int EditPoint(size_t curveIndex, int pointIndex, ImVec2 value);

   virtual void AddPoint(size_t curveIndex, ImVec2 value);
   virtual void DeletePoint(size_t curveIndex, int pointIndex);
   virtual ImVec2& GetMax();
   virtual ImVec2& GetMin();
   virtual unsigned int GetBackgroundColor();
   CurvePoint curve_points[100][1000];
   // ImVec4 curve_point_handles[100][1000];
	 std::vector<SIMDString<256>> curve_names;
	 
	 
	 // std::vector<ImVec2[1000]> curve_points;
	 size_t total_curve_count = 0;
	
   size_t curve_point_counts[1000];
   bool curve_is_visibles[1000];
   ImVec2 mMin;
   ImVec2 mMax;
private:
   void SortValues(size_t curveIndex);
};

struct Timeline;
 struct Lane {
		int mType;
		int mFrameStart, mFrameEnd;
		bool mExpanded;
		std::vector<int> curve_indices;
		SIMDString<256> name;
		Timeline* timeline;
		std::vector<Curve> curves;
		void addCurve();
		Curve AddCurve(std::string_view name);
 };

struct Timeline : public ImSequencer::SequenceInterface {
   // interface with sequencer

   int GetFrameMin() const override;

   int GetFrameMax() const override;
   int GetLanesCount() const override;

   int GetItemTypeCount() const override;
   const char* GetItemTypeName(int lane_index) const override;

   const char* GetLaneLabel(int index) const override;

   void GetSequence(int index, int** start, int** end, int* type, unsigned int* color) override;
   void AddSequence(int type) override;
   void DeleteSequence(int index) override;
   void DuplicateSequence(int index) override;

   size_t GetCustomHeight(int index) override;
	
	 std::filesystem::path json_path;

   // my datas
   Timeline();
   void deserialize_from_json();
   void serialize_to_json();
   void set_json_path(std::string_view path_string);
   int mFrameMin, mFrameMax;

   std::vector<Lane> lanes;
   RampEdit rampEdit;

	 float bpm = 60;

	 ImVector<ImCurveEdit::EditPoint> selected_points;

	 Lane* AddSequence(std::string_view lane_name);

   void DoubleClick(int index) override;

   void CustomDraw(
			int lane_index,
			ImDrawList* draw_list,
			const ImRect& rc,
			const ImRect& legendRect,
			const ImRect& clippingRect,
			const ImRect& legendClippingRect
		) override;

   void CustomDrawCompact(int index, ImDrawList* draw_list, const ImRect& rc, const ImRect& clippingRect) override;
};
