
struct Vert{
    vec2 pos;
    vec2 uv;
    vec4 color;
    int tex_idx;
    bool is_tex_coloured;
};

uniform Vert* drawer_2d_buff;

out vec2 uv;
out vec4 color;
out float alpha;
out flat int tex_idx;
out flat int is_tex_coloured;

void main() {
    vec2 pos = drawer_2d_buff[gl_VertexID].pos;
    uv = drawer_2d_buff[gl_VertexID].uv;
    color = drawer_2d_buff[gl_VertexID].color;
    alpha = color.w;

    tex_idx = drawer_2d_buff[gl_VertexID].tex_idx;
    is_tex_coloured = int(drawer_2d_buff[gl_VertexID].is_tex_coloured);

//    gl_FrontColor = gl_Color;


    gl_Position = vec4(pos,0.5,1.0);
}
