
in vec2 uv;
in vec2 uvn;
out vec4 C;

uniform int tex_input;
uniform int pass;
uniform int tex_eigen;
uniform float blur_w_a;
uniform float blur_w_b;


void main() {
    vec2 u = uvn;
    
    vec4 eigen = texture(textures[tex_eigen], u)*100;
    
    vec2 dir;
    if(pass == 0){
        dir = eigen.xy;
    } else {
        dir = eigen.zw;
    }
    
    int iters = 8;
    
    C = vec4(0);
    float W = 0.;
    if(false){
        for(int x = -iters; x <= iters; x++){
            vec2 offs = dir * float(x)/float(iters);
            C += texture(textures[tex_input], u + offs);
            W++;
        }
    } else {
        for(int i = 0; i < 2; i++){
            u = uvn;
            
            for(int x = 0; x <= iters*1; x++){
                if(true){
                    vec4 eigen = texture(textures[tex_eigen], u)*1;
                    eigen = normalize(eigen)*0.001;
//                    eigen *= 2.;
                    if(i == 1){
                        eigen *= -1.;
                    }
                    vec2 dir;
                    if(true){
                        if(pass == 0){
                            dir = eigen.xy*blur_w_a;
                        } else {
                            dir = eigen.xy*blur_w_b;
                        }
                    } else {
                        if(pass == 0){
                            dir = eigen.xy*1;
                        } else {
                            dir = eigen.zw*1;
                        }
                    }
                    
                    float w = 1.;
                    w = 1.0-pow(smoothstep(0.,1.0,float(x)/float(iters)),2.0);
                    
                    if(false){
                        vec2 offs = dir;
                        u += offs*0.05;
                        C += texture(textures[tex_input], u) * w;
                    } else {
                        vec2 offs = dir * float(x)/float(iters);
                        C += texture(textures[tex_input], u + offs) * w;
                    }
                    W+=w;
                }
            }
            
        }
        
    }
    C /= W;
}
