#pragma once

#include "ma_reverb_node/ma_reverb_node.h"

class AudioEffect {
	protected:
		bool initialized;
		ma_engine* engine;
		ma_device* device;

	public:
		virtual int64_t initialize() = 0;
		virtual int64_t connect_to_node(ma_node* node) = 0;
		AudioEffect(ma_engine* engine, ma_device* device) : initialized(false), engine(engine), device(device) {};
		// virtual ~AudioEffect() {};
		virtual ma_node* get_node() = 0;
};


class ReverbEffect : public AudioEffect {
	ma_reverb_node reverb_node;
	public:
	int64_t initialize() override;

	ReverbEffect(ma_engine *engine, ma_device *device);

	ma_node* get_node() override;

	int64_t connect_to_node(ma_node* node) override;

	// ~ShinobuPitchShift() {
	// 	ma_pitch_shift_node_uninit(shift_node, NULL);
	// 	delete shift_node;
	// }
};

