﻿#pragma once
#include <gl/Shader.h>
#include <gl/ShaderProgram.h>

enum class DebugDrawerMode {
	POINT = 0, LINE = 1, CIRCLE = 2
};

class DebugDrawer {
public:
	ShaderProgram* prog_xray_point;

	DebugDrawer() {
		prog_xray_point = new ShaderProgram({new Shader("engine/debug_drawer.comp")});
	}

	void draw_point(glm::vec3 pos) {
			prog_xray_point->use();
			glProgramUniform1i(prog_xray_point->pid, glGetUniformLocation(prog_xray_point->pid, "mode"), static_cast<GLint>(DebugDrawerMode::POINT));
			glProgramUniform3f(prog_xray_point->pid, glGetUniformLocation(prog_xray_point->pid, "pos"), pos.x, pos.y, pos.z);
			prog_xray_point->dispatch_compute(1,1,1);
	}
	void draw_circle(glm::vec3 pos, float width = 0.1) {
			prog_xray_point->use();
			glProgramUniform1i(prog_xray_point->pid, glGetUniformLocation(prog_xray_point->pid, "mode"), static_cast<GLint>(DebugDrawerMode::CIRCLE));
			glProgramUniform3f(prog_xray_point->pid, glGetUniformLocation(prog_xray_point->pid, "pos"), pos.x, pos.y, pos.z);
			glProgramUniform1f(prog_xray_point->pid, glGetUniformLocation(prog_xray_point->pid, "width"), width);
			prog_xray_point->dispatch_compute(1,1,1);
	}

	void draw_line(glm::vec3 start, glm::vec3 end) {
			prog_xray_point->use();
			glProgramUniform1i(prog_xray_point->pid, glGetUniformLocation(prog_xray_point->pid, "mode"), static_cast<GLint>(DebugDrawerMode::LINE));
			glProgramUniform3f(prog_xray_point->pid, glGetUniformLocation(prog_xray_point->pid, "start"), start.x, start.y, start.z);
			glProgramUniform3f(prog_xray_point->pid, glGetUniformLocation(prog_xray_point->pid, "end"), end.x, end.y, end.z);
			prog_xray_point->dispatch_compute(1,1,1);
	}





};
