pico-8 cartridge // http://www.pico-8.com
version 42
__lua__
t=0
light="50,50,50"
calc_light=false
zBuffer={}
cleanZBuffer=""
tex='677765677656777677776566665677777777655ee55677777776555ee55567776665555ee55556665555555665555555665555677655556676eee6e77e6eee6776eee6eeee6eee676655556ee655556655555556655555556665555ee55556667776555ee55567777777655ee556777777776566665677776777656776567776'
bottle_texture="222222222222222222222222222222222233333333333333333333333333333322222222222222222222222222222222223333333333333333333333333333332222222222222222222222222222222222333333333333333333333333333333222222222222222222222222222222222233333333333333333333333333333322222222222222222222222222222222223333333333333333333333333333332222222222222222222222222222222222333333333333333333333333333333222222222222222222222222222222222233333333333333333333333333333322222222222222222222222222222222223333333333333333333333333333332222222222222222222222222222222222333333333333333333333333333333222222222222222222222222222222222233333333333333333333333333333322222222222222222222222222222222223333333333333333333333333333332222222222222222222222222222222222333333333333333333333333333333222222222222222222222222222222222233333333333333333333333333333322222222222222222222222222222222223333333333333333333333333333332222222222222222222222222222222222333333333333333333333333333333222222222222222222222222222222222233333333333333333333333333333322222222222222222222222222222222223333333333333333333333333333333313311311335555555555555555555555333333333333333333333333333333333333333333666666666666666666666666666666666666666333333333333333333333333377777777777777777777777777777777777777733333333333333333333333336777777777777777777777777777777777777773333333333333333333333333677777777777777777777777777777777777777333333333333333333333333377777777777777777777777777777777777777733333333333333333333333336777777777777777777777777777777777777773333333333333333333333333772222777722227777222277277777277222277333333333333333333333333367777277727777277277727727777277727772733333333333333333333333336777727727777727727772777277727772777273333333333333333333333333777772772777772777222277722227777277777333333333333333333333333367777277277777277727727772772777727777733333333333333333333333336777727727777727727772777272777772777773333333333333333333333333777772772777727772777277772777777277777333333333333333333333333367777277722227777722227777277772222277733333333333333333333333337777777777777777777777777777777777777773333333333333333333333333677777777777777777777777777777777777777333333333333333333333333367777777777777777777777777777777777777733333333333333333333333337777777777777777777777777777777777777773333333333333333333333333666666666666666666666666666666666666666333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333d6d6d6d6d6333333333333333333333333333333333333333333333333333333777777777763333333333333333333333333333333333333333333333333333377777777776333333333333333333333333333333333333333333333333333337777777777d333333333333333333333333333333333333333333333333333337777777777d3333333333333333333333333333333333333333333333333333377777777776333333333333333333333333333333333333333333333333333337777777777d333333333333333333333333333333333333333333333333333337777777777d333333333333333333333333333333333333333333333333333337777777777633333333333333333333333333333333333333333333333333333ddddddddd6333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333"
cameraMatrix="0,0,5,0,0,0,0,1,0,0,0,0,0,0,0"
-- 1-3 position
-- 4-6 target
-- 7-9 up vector
-- 10-12 right vector
-- 13-15 forward vector
viewMatrix="0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0"
perspectiveMatrix="0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0"

function init_renderer()
    cameraMatrix=split(cameraMatrix)
    viewMatrix=split(viewMatrix)
    perspectiveMatrix=split(perspectiveMatrix)
    -- forward vector
    cameraMatrix[13]=cameraMatrix[1]-cameraMatrix[4]
    cameraMatrix[14]=cameraMatrix[2]-cameraMatrix[5]
    cameraMatrix[15]=cameraMatrix[3]-cameraMatrix[6]
    cameraMatrix[13],cameraMatrix[14],cameraMatrix[15]=normalizeVec(cameraMatrix[13],cameraMatrix[14],cameraMatrix[15])
    -- right vector
    cameraMatrix[10]=cameraMatrix[8]*cameraMatrix[15]+cameraMatrix[9]*cameraMatrix[14]
    cameraMatrix[11]=cameraMatrix[9]*cameraMatrix[13]+cameraMatrix[7]*cameraMatrix[15]
    cameraMatrix[12]=cameraMatrix[7]*cameraMatrix[14]+cameraMatrix[8]*cameraMatrix[13]
    cameraMatrix[10],cameraMatrix[11],cameraMatrix[12]=normalizeVec(cameraMatrix[10],cameraMatrix[11],cameraMatrix[12])
    -- up vector
    cameraMatrix[7]=cameraMatrix[14]*cameraMatrix[12]+cameraMatrix[15]*cameraMatrix[11]
    cameraMatrix[8]=cameraMatrix[15]*cameraMatrix[10]+cameraMatrix[13]*cameraMatrix[12]
    cameraMatrix[9]=cameraMatrix[13]*cameraMatrix[11]+cameraMatrix[14]*cameraMatrix[10]
    cameraMatrix[7],cameraMatrix[8],cameraMatrix[9]=normalizeVec(cameraMatrix[7],cameraMatrix[8],cameraMatrix[9])
    --view matrix
    viewMatrix[1]=cameraMatrix[10]
    viewMatrix[2]=cameraMatrix[11]
    viewMatrix[3]=cameraMatrix[12]
    viewMatrix[4]=-(cameraMatrix[10]*cameraMatrix[1]+cameraMatrix[11]*cameraMatrix[2]+cameraMatrix[12]*cameraMatrix[3])
    viewMatrix[5]=cameraMatrix[7]
    viewMatrix[6]=cameraMatrix[8]
    viewMatrix[7]=cameraMatrix[9]
    viewMatrix[8]=-(cameraMatrix[7]*cameraMatrix[1]+cameraMatrix[8]*cameraMatrix[2]+cameraMatrix[9]*cameraMatrix[3])
    viewMatrix[9]=cameraMatrix[13]
    viewMatrix[10]=cameraMatrix[14]
    viewMatrix[11]=cameraMatrix[15]
    viewMatrix[12]=-(cameraMatrix[13]*cameraMatrix[1]+cameraMatrix[14]*cameraMatrix[2]+cameraMatrix[15]*cameraMatrix[3])
    viewMatrix[16]=1
    --perspective matrix
    perspectiveMatrix[1]=1/1.619775 --1/(tan(fov/2)*aspect ratio)
    perspectiveMatrix[6]=1/1.619775
    perspectiveMatrix[11]=-((100+1)/(100-1)) -- -((zfar+znear)/(zfar-znear))
    perspectiveMatrix[12]=-((2*100*1)/(100-1)) -- -(2*zfar*znear/(zfar-znear))
    perspectiveMatrix[15]=-1
    -- music(0)
    -- printh("pos "..cameraMatrix[1]..","..cameraMatrix[2]..","..cameraMatrix[3],"log.txt")
    -- printh("target "..cameraMatrix[4]..","..cameraMatrix[5]..","..cameraMatrix[6],"log.txt")
    -- printh("up "..cameraMatrix[7]..","..cameraMatrix[8]..","..cameraMatrix[9],"log.txt")
    -- printh("right "..cameraMatrix[10]..","..cameraMatrix[11]..","..cameraMatrix[12],"log.txt")
    -- printh("forward "..cameraMatrix[13]..","..cameraMatrix[14]..","..cameraMatrix[15],"log.txt")
    -- printh("view","log.txt")
    -- printh(viewMatrix[1]..","..viewMatrix[2]..","..viewMatrix[3]..","..viewMatrix[4],"log.txt")
    -- printh(viewMatrix[5]..","..viewMatrix[6]..","..viewMatrix[7]..","..viewMatrix[8],"log.txt")
    -- printh(viewMatrix[9]..","..viewMatrix[10]..","..viewMatrix[11]..","..viewMatrix[12],"log.txt")
    -- printh(viewMatrix[13]..","..viewMatrix[14]..","..viewMatrix[15]..","..viewMatrix[16],"log.txt")
    -- printh("perspective","log.txt")
    -- printh(perspectiveMatrix[1]..","..perspectiveMatrix[2]..","..perspectiveMatrix[3]..","..perspectiveMatrix[4],"log.txt")
    -- printh(perspectiveMatrix[5]..","..perspectiveMatrix[6]..","..perspectiveMatrix[7]..","..perspectiveMatrix[8],"log.txt")
    -- printh(perspectiveMatrix[9]..","..perspectiveMatrix[10]..","..perspectiveMatrix[11]..","..perspectiveMatrix[12],"log.txt")
    -- printh(perspectiveMatrix[13]..","..perspectiveMatrix[14]..","..perspectiveMatrix[15]..","..perspectiveMatrix[16],"log.txt")
    for i=1,128*128 do
        cleanZBuffer=cleanZBuffer.."9999,"
    end
    zBuffer=split(cleanZBuffer)
    light=split(light)
end

function _init()
    init_renderer()
end

function clearZBuffer()
    zBuffer=split(cleanZBuffer)
end

function mulMatrixVector(x,y,z,w,matrix)
    resultX,resultY,resultZ,resultW=0,0,0,0
    resultX+=x*matrix[1]+y*matrix[2]+z*matrix[3]+w*matrix[4]
    resultY+=x*matrix[5]+y*matrix[6]+z*matrix[7]+w*matrix[8]
    resultZ+=x*matrix[9]+y*matrix[10]+z*matrix[11]+w*matrix[12]
    resultW+=x*matrix[13]+y*matrix[14]+z*matrix[15]+w*matrix[16]
    return resultX,resultY,resultZ,resultW
end

function v3_len(vec)
    return sqrt(vec[1]*vec[1]+vec[2]*vec[2]+vec[3]*vec[3])        
end


function normalizeVec(x, y, z)
    local len = sqrt(x * x + y * y + z * z)
    x/=len
    y/=len
    z/=len
    return x, y, z
end

function checkIfTriVisible(a,b,c,d,e,f)
    local e1x,e1y,e2x,e2y=c-a,d-b,e-a,f-b;
    return (e1x*e2y-e1y*e2x)>=0
end    

function inf(t,x,y)
	x+=2*(cos(t))
	y+=2*cos(t)*sin(t)
    return x,y
end
    
function rotate(x,y,a)
    local c,s=cos(a),sin(a)
    return c*x-s*y, s*x+c*y
end

function translation(x,y,z,xT,yT,zT)
    return x+xT,y+yT,z+zT
end

function baricentricCoords(x,yp2y,inv,p0,p1,p2,fac)
    Ba,Bb=((p1[2]-p2[2])*(x*2+fac-p2[1])+(p2[1]-p1[1])*yp2y)*inv,((p2[2]-p0[2])*(x*2+fac-p2[1])+(p0[1]-p2[1])*yp2y)*inv
    Bc=1-Ba-Bb 
    return Ba, Bb, Bc
end

function texturing(Ba,Bb,Bc,uv0,uv1,uv2,tex_size,texture,tsts)
    local uv_x,uv_y=Ba*uv0[1]+Bb*uv1[1]+Bc*uv2[1],Ba*uv0[2]+Bb*uv1[2]+Bc*uv2[2]
    uv_x = max(0, min(1, uv_x))
    uv_x=flr(uv_x*tex_size)+1
    uv_y = max(0, min(1, uv_y))
    uv_y=flr(uv_y*tex_size)+1
    return texture[max(0, min(tsts, flr(uv_y *tex_size + uv_x)))]
end

function checkDepth(Ba, Bb, Bc, z0, z1, z2, x, y)
    local z = 1/((Ba/z0+Bb/z1+Bc/z2))
    addr=x*128+y
    -- if(z1==0 and z2==0 and z0==0)then
    --     printh("dupa","logs.txt")
    -- end
    if(z<zBuffer[addr] and z0!=0 and z1!=0 and z2!=0) then
        -- printh(z.." "..Ba.." "..Bb.." "..Bc.." "..z0.." "..z1.." "..z2,"log.txt")
        zBuffer[addr]=z
        return 1
    else
        return 0
    end
end

function rasterize(y, x0, x1, uv0, uv1, uv2, inv,p0,p1,p2,l_int,tex_size,texture,fast,tsts)
    if (y<0 or y>127) return
    local q,n
    local yp2y=y-p2[2]
    n=(flr(y)%2+0.5)*0.5
    x0+=n;
    x1+=n;
    if (x1<x0) q=x0 x0=x1 x1=q
    if (x1<0 or x0>127) return
    y=flr(y+0.5);
    if (x0<0) x0=0
    if (x1>123) x1=123
    x0,x1=flr(x0/2+0.5),flr(x1/2+0.5)
    for x = x0, x1, 1 do
        local color="0x11"
        local Ba,Bb,Bc=baricentricCoords(x,yp2y,inv,p0,p1,p2,0)
        if(checkDepth(Ba, Bb, Bc, p0[3], p1[3], p2[3], x, y)==1) then
            if(l_int>0.3)then
                local texture_color1 = texturing(Ba,Bb,Bc,uv0,uv1,uv2,tex_size,texture,tsts)
                if(l_int>0.97)then color="0xa"..texture_color1
                elseif(l_int<=0.97 and l_int>0.5)then
                    color="0x"..texture_color1..texture_color1
                elseif(l_int<=0.5)then color="0x1"..texture_color1
                end
            end
            poke(0x6000 + y * 0x40 + x, color)
        end
    end
end

function tri(x0,y0,z0,x1,y1,z1,x2,y2,z2,uv0,uv1,uv2,l_int,tex_size,texture,fast,tsts)
    local x,xx,y,q,q2,uv;
    if (y0>y1) y=y0;y0=y1;y1=y;x=x0;x0=x1;x1=x;uv=uv0;uv0=uv1;uv1=uv;z=z0;z0=z1;z1=z;
    if (y0>y2) y=y0;y0=y2;y2=y;x=x0;x0=x2;x2=x;uv=uv0;uv0=uv2;uv2=uv;z=z0;z0=z2;z2=z;
    if (y1>y2) y=y1;y1=y2;y2=y;x=x1;x1=x2;x2=x;uv=uv1;uv1=uv2;uv2=uv;z=z2;z2=z1;z1=z;
    local dx01,dy01,dx02,dy02;
    local xd,xxd;
    if (y2<0 or y0>127) return
    y,x,xx=y0,x0,x0;
    dx01,dy01,dy02,dx02,dx12,dy12,q2,xxd=x1-x0,y1-y0,y2-y0,x2-x0,x2-x1,y2-y1,0,1;
    if(x2<x0) xxd=-1
    inv=1/((y1-y2)*(x0-x2)+(x2-x1)*(y0-y2))
    if flr(y0)<flr(y1) then
        q,xd=0,1;
        if(x1<x0) xd=-1
        while y<=y1 do
            rasterize(y,x,xx,uv0,uv1,uv2,inv,{x0,y0,z0},{x1,y1,z1},{x2,y2,z2},l_int,tex_size,texture,fast,tsts);
            y+=1;
            q+=dx01;
            q2+=dx02;
            while xd*q>=dy01 do
                q-=xd*dy01
                x+=xd
            end
            while xxd*q2>=dy02 do
                q2-=xxd*dy02
                xx+=xxd
            end
        end
    end
    
    if flr(y1)<flr(y2) then
        q,x,xd=0,x1,1;
        if (x2<x1) xd=-1
        while y<=y2 and y<128 do
            rasterize(y,x,xx,uv0,uv1,uv2,inv,{x0,y0,z0},{x1,y1,z1},{x2,y2,z2},l_int,tex_size,texture,fast,tsts);
            y+=1;
            q+=dx12;
            q2+=dx02;
            while xd*q>dy12 do
                q-=xd*dy12
                x+=xd
            end
            while xxd*q2>dy02 do
                q2-=xxd*dy02
                xx+=xxd
            end
        end
    end
end

function draw_model(p,qt,vertices,vt,vm,faces,f,tc,uv,textures,calc_light,tex_size,fast,tsts)
    for i=1,3*faces,3 do
        local a,b,c,xab,yab,zab,xac,yac,zac,nv,l_dir,l_cos,l_int;
        a,b,c,l_int=f[i],f[i+1],f[i+2],0.9;
        if(checkIfTriVisible(vt[a*3+1],vt[a*3+2],vt[b*3+1],vt[b*3+2],vt[c*3+1],vt[c*3+2])==true) then
            if(calc_light==true) then
                -- flat shading
                -- normal vector
                xab,yab,zab,xac,yac,zac=vm[b*3+1]-vm[a*3+1],vm[b*3+2]-vm[a*3+2],vm[b*3+3]-vm[a*3+3],vm[c*3+1]-vm[a*3+1],vm[c*3+2]-vm[a*3+2],vm[c*3+3]-vm[a*3+3]
                nv={yab*zac-zab*yac,zab*xac-xab*zac,xab*yac-yab*xac}
                vec_len=v3_len({nv[1],nv[2],nv[3]})
                nv[1],nv[2],nv[3]=nv[1]/vec_len,nv[2]/vec_len,nv[3]/vec_len
                nv_len=v3_len(nv)
                -- light direction
                local tx,ty,tz=(vm[a*3+1]+vm[b*3+1]+vm[c*3+1])/3,(vm[a*3+2]+vm[b*3+2]+vm[c*3+2])/3,(vm[a*3+3]+vm[b*3+3]+vm[c*3+3])/3
                l_dir={light[1]-tx,light[1]-ty,light[3]-tz}
                l_len=v3_len(l_dir)
                -- cos
                l_dir_nv=v3_len({l_dir[1]-nv[1],l_dir[2]-nv[2],l_dir[3]-nv[3]})
                x=nv_len*nv_len+l_len*l_len-l_dir_nv*l_dir_nv
                y=l_len*nv_len*2
                l_cos=x/y
                l_int=max(0.1,l_cos)
            end
            local tex_i=1
            if #textures==6 then tex_i=flr(i/3)%6+1 end
            tri(
                vt[a*3+1],
                vt[a*3+2],
                vt[a*3+3],
                vt[b*3+1],
                vt[b*3+2],
                vt[b*3+3],
                vt[c*3+1],
                vt[c*3+2],
                vt[c*3+3],
                {tc[uv[i]*2+1],tc[uv[i]*2+2]},{tc[uv[i+1]*2+1],tc[uv[i+1]*2+2]},{tc[uv[i+2]*2+1],tc[uv[i+2]*2+2]},l_int,tex_size,textures[tex_i],fast,tsts
            )
        end
    end
end

function draw_cube(p)
    p=split(p)
	local qt,vertices,faces,vt,vm=t*0.01,8,12,{},{}
	local v=split("1.3,1.3,-1.3,1.3,-1.3,-1.3,1.3,1.3,1.3,1.3,-1.3,1.3,-1.3,1.3,-1.3,-1.3,-1.3,-1.3,-1.3,1.3,1.3,-1.3,-1.3,1.3")
	local f=split("4, 2, 0, 2, 7, 3, 6, 5, 7, 1, 7, 5, 0, 3, 1, 4, 1, 5, 4, 6, 2, 2, 6, 7, 6, 4, 5, 1, 3, 7, 0, 2, 3, 4, 0, 1")
    local tc=split("1.0,0.0,0.0,1.0,0.0,0.0,1.0,1.0")
    local uv=split("0, 1, 2, 0, 1, 2, 2, 3, 1, 3, 2, 0, 0, 1, 2, 2, 3, 1, 0, 3, 1, 0, 3, 1, 2, 0, 3, 3, 1, 2, 0, 3, 1, 2, 0, 3")
    for j=1,vertices*3,3 do
        local x,y,z=v[j],v[j+1],v[j+2];
        y,z=rotate(y,z,qt);
        x,z=rotate(x,z,qt*1.5);
        -- x,z=inf(qt,x,z)
        x,y,z=translation(x,y,z,p[1],p[2],p[3])
        y,z=rotate(y+1,z+1,qt+p[3])
        -- y-=1
        z+=5
        add(vm,x);
        add(vm,y);
        add(vm,z);
        z-=5
        w=1
        x,y,z,w=mulMatrixVector(x,y,z,w,viewMatrix)
        x,y,z,w=mulMatrixVector(x,y,z,w,perspectiveMatrix)
        x=x/w*64 + 64
        y=y/w*64 + 64
        -- x=x*96/z+64;
        -- y=y*96/z+64;
        vt[j],vt[j+1],vt[j+2]=flr(x),flr(y),z;
    end
    draw_model(p,qt,vertices,vt,vm,faces,f,tc,uv,{tex},true,16,false,256)
end

function draw_jabol(p)
    p=split(p)
	local qt,vertices,faces,vt,vm=t*0.01,56,108,{},{}
	local v=split("-0.0,-2.98,0.88,-0.76,-2.98,0.44,-0.76,-2.98,-0.44,-0.0,-2.98,-0.88,0.76,-2.98,-0.44,0.76,-2.98,0.44,0.87,0.62,-0.5,0.87,0.62,0.5,-0.87,0.62,-0.5,-0.0,0.62,-1.0,-0.0,0.62,1.0,-0.87,0.62,0.5,0.87,-2.8,0.5,-0.0,-2.8,-1.0,-0.87,-2.8,0.5,0.87,-2.8,-0.5,-0.87,-2.8,-0.5,-0.0,-2.8,1.0,0.68,1.1,-0.39,0.38,1.58,-0.22,0.38,3.02,-0.22,0.0,3.02,0.0,-0.68,1.1,-0.39,-0.38,1.58,-0.22,-0.38,3.02,-0.22,-0.0,1.1,0.78,-0.0,1.58,0.43,0.0,3.02,0.43,0.38,3.02,0.22,0.38,1.58,0.22,0.68,1.1,0.39,0.0,3.02,-0.43,-0.0,1.58,-0.43,-0.0,1.1,-0.78,-0.38,3.02,0.22,-0.38,1.58,0.22,-0.68,1.1,0.39,-0.0,-2.98,-0.0,0.87,-0.06,-0.5,-0.87,-0.06,-0.5,-0.0,-0.06,1.0,0.87,-0.06,0.5,-0.0,-0.06,-1.0,-0.87,-0.06,0.5,0.87,-1.57,0.5,-0.0,-1.57,-1.0,-0.87,-1.57,0.5,0.87,-1.57,-0.5,-0.87,-1.57,-0.5,-0.0,-1.57,1.0,0.38,2.16,-0.22,-0.38,2.16,-0.22,-0.0,2.16,0.43,0.38,2.16,0.22,-0.0,2.16,-0.43,-0.38,2.16,0.22")
	local f=split("43,8,39,42,6,38,41,10,40,40,11,43,39,9,42,38,7,41,5,15,12,2,13,3,0,14,1,5,17,0,3,15,4,2,14,16,11,22,8,36,23,22,55,24,51,31,24,21,9,18,6,33,19,18,54,20,50,5,0,37,7,25,10,30,26,25,53,27,52,28,20,21,10,36,11,25,35,36,52,34,55,8,33,9,22,32,33,51,31,54,6,30,7,18,29,30,50,28,53,24,34,21,3,4,37,2,3,37,47,41,44,48,42,45,49,43,46,44,40,49,45,38,47,46,39,48,14,48,16,13,47,15,12,49,17,17,46,14,16,45,13,15,44,12,27,21,34,19,53,29,21,27,28,21,20,31,37,0,1,37,1,2,37,4,5,23,54,32,26,55,35,29,52,26,32,50,19,35,51,23,43,11,8,42,9,6,41,7,10,40,10,11,39,8,9,38,6,7,5,4,15,2,16,13,0,17,14,5,12,17,3,13,15,2,1,14,11,36,22,36,35,23,55,34,24,9,33,18,33,32,19,54,31,20,7,30,25,30,29,26,53,28,27,10,25,36,25,26,35,52,27,34,8,22,33,22,23,32,51,24,31,6,18,30,18,19,29,50,20,28,47,38,41,48,39,42,49,40,43,44,41,40,45,42,38,46,43,39,14,46,48,13,45,47,12,44,49,17,49,46,16,48,45,15,47,44,19,50,53,23,51,54,26,52,55,29,53,52,32,54,50,35,55,51")
    local tc=split("0.07,0.69,0.17,0.84,0.07,0.84,0.74,0.66,0.88,0.69,0.73,0.69,0.87,0.66,0.17,0.69,0.25,0.82,0.25,0.71,0.33,0.8,0.41,0.74,0.54,0.8,0.41,0.8,0.27,0.24,0.08,0.13,0.27,0.03,0.54,0.26,0.54,0.03,0.74,0.15,0.19,0.32,0.35,0.56,0.35,0.32,0.83,0.32,0.99,0.56,0.99,0.32,0.51,0.32,0.67,0.56,0.67,0.32,0.51,0.56,0.03,0.32,0.19,0.56,0.83,0.56,0.73,0.87,0.33,0.74,0.54,0.74,0.03,0.56,0.88,0.87")
    local uv=split("0,1,2,0,1,2,0,1,2,0,1,2,0,1,2,0,1,2,3,4,5,6,5,3,6,5,3,6,5,3,6,5,3,3,4,5,7,8,1,9,10,8,11,12,13,14,15,16,7,8,1,9,10,8,11,12,13,17,18,19,7,8,1,9,10,8,11,12,13,14,15,16,7,8,1,9,10,8,11,12,13,7,8,1,9,10,8,11,12,13,7,8,1,9,10,8,11,12,13,14,15,16,17,18,19,17,18,19,20,21,22,23,24,25,26,27,28,22,29,26,30,31,20,28,32,23,4,33,5,4,33,5,4,33,5,4,33,5,4,33,5,4,33,5,15,16,14,34,13,10,16,14,15,16,14,15,19,17,18,19,17,18,19,17,18,34,13,10,34,13,10,34,13,10,34,13,10,34,13,10,0,7,1,0,7,1,0,7,1,0,7,1,0,7,1,0,7,1,3,6,4,6,4,5,6,4,5,6,4,5,6,4,5,3,6,4,7,9,8,9,34,10,11,35,12,7,9,8,9,34,10,11,35,12,7,9,8,9,34,10,11,35,12,7,9,8,9,34,10,11,35,12,7,9,8,9,34,10,11,35,12,7,9,8,9,34,10,11,35,12,20,31,21,23,32,24,26,29,27,22,21,29,30,36,31,28,27,32,4,37,33,4,37,33,4,37,33,4,37,33,4,37,33,4,37,33,34,11,13,34,11,13,34,11,13,34,11,13,34,11,13,34,11,13")
    for j=1,vertices*3,3 do
        local x,y,z=v[j],v[j+1],v[j+2];
        y,z=rotate(y,z,qt);
        x,z=rotate(x,z,qt*1.5);
        x,z=inf(qt,x,z)
        -- x,y,z=translation(x,y,z,p[1],p[2],p[3])
        -- y-=1
        z+=5
        add(vm,x);
        add(vm,y);
        add(vm,z);
        z-=5
        w=1
        x,y,z,w=mulMatrixVector(x,y,z,w,viewMatrix)
        x,y,z,w=mulMatrixVector(x,y,z,w,perspectiveMatrix)
        x=x/w*64 + 64
        y=y/w*64 + 64
        -- x=x*96/z+64;
        -- y=y*96/z+64;
        vt[j],vt[j+1],vt[j+2]=flr(x),flr(y),z;
    end
    draw_model(p,qt,vertices,vt,vm,faces,f,tc,uv,{bottle_texture},true,64,false,4096) 
end

function _update()
   t+=1 
end

function _draw()
    cls();
    -- draw_cube("0,1,1,0.1");
    -- draw_cube("-2,2,0,0.3");
    -- draw_cube("0,-1,-1,0");
    -- draw_cube("2,-2,0,0.1");
    draw_jabol("0,0,1,0");
    clearZBuffer();
end
__gfx__
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000051500000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000d776d665000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000660001105650000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000000000000000000000d6000000015d5000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000006100105111555000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000006555551505d51000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000055555d5555155000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000015155555151051000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000000000000000000005514411151dd51000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000550d6115105d10000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000055156005555555000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000015557555115551000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000015157511155151000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000055157055511550000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000015557011551155000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000055557115505515000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000055556505155155100000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000000000000000000015515d555515151500000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000005551dd155515515d10000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000005515ed511151551550000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000055555f1051545155151000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000155515d5555151555515000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000d55555d1515151455515000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000055555d45555151515555100000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000005551555d5555555555551500000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000005555515d5515555555515500000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000001555555555555555555551510000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000005151555d5555555555555500000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000001555555555555555555555100000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000004555555d55555d5d5ddd5500000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000002d555555d5d555d55555d500000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000000000000000005555dd5d5d5d5ddddd55550000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000000000000000001555d5d555d55d55d555511000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000015ddd55dd55d55555555551000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000025555d555d5dd55d5d55555100000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000001115555d5555555d55555551500000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000015555555555d55dd555551515510000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000001555555d5d55dd55555555155150000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000011551555555d555d5d55515515551000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000000000000001551551555555d555555551515151000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000001551151555555555d5555511151151100000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000011115215515555d555551d551515151000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000551151515515555d55211211512115100000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000001515511255152555555525111251515110000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000051211515511115251d1515d51215105100000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000011111221112525155d125226d5112151010000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000015155515d55112151255115665551115100000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000000000001525155676d1125455521256f1215511110000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000512112567fd5121512152256f1112110000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000000000005555515df7d55d1d255122566d121500010000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000011515145ddd521d151d152266d151111100000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000114555551dd2d2d25d1d1661111010000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000000000000010111d2ddd2ddd21522d5d21000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000000000001010011111224d251d21511100100000175000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000000000000000011011111111111001101110dd501d1000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000105550d1111111111111111510107771000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000011677675111711111d111067700060d7100000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000000000001000006110d711117101156056007007000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000000000001000107101d7d117d0110d6007007007101000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000000000000111107011ddd11700511d6006d07107007000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000000000001100017115dd616d01771d610750656d01d000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000111171177f70711117d17007006770010000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000110111d0061171651017d07556005710000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000005dd7200d11705715f760d771001011100000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000105661115d10650d7657d01101110010000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000001000001111111111116601011111010110000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000001111111111111111111111111011010010000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000010001121111111111111111101101101111000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000011109f2111111111111111111111010010000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000010108669211111111111111111011010110000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000010047017811111111221111101111001110000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000276006e21111111ee2111111101011111000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000000000000087d455741111118f78111110111111010000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000114fd7047e511114f1df211111110101010000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000000000001118d0178411114ed0d7821111011110011000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000011275b8811118e75077742111110011010000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000011112ff2111118f750777e8111111111010000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000001111421111112872577e21111111100011000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000111111111111112efc7e111111101100151000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000000000000000111111111114e6921111111111002d1000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000000000001111111111111111498111111111001d5d1000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000d51111111111111112211111110011d25d1000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000dd210010111111011111111101125255252000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000025dd54d5111100000000011154d5d12d1d1000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000dd52ddddd2d5244515154d2ddd2d25d5221000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000d2d55d52d2d5dddddddd2d5225551d254d1000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000d5dd12d5222121d2222552d552d451255d5000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000000000002dd25e21d5d1d251d5ddd121511525525d1000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000000000004d2d521d5212d125221d125d422d12151d1000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000dd1555d25d3e12d12d541511213125521d1000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000d2d2d215121212151215522351121215221000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000d5553e2425d512545522552111345425451000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000e2d252555121251115212122122112122d2000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000d535d5d21243552515511521515155521d1000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000e2d12115512125252251215121212315220000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000dd2d5421415551215111115211121221dd0000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000025521255515212512125211111255212d00000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000dd2dd51212515112151255225215121d200000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000000000002d15d2d155512515121121211112122d000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000000000000dd2d525215552215121411212152dd0000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000002d52555525121121512121152dd000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000012dd21d1222521525555ddd200000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000000000000000001d2ed222552552d21200000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000111111111100000000000000000000000000000000000000000000000000000000000
__sfx__
010400000055000550005400054000530005300052000525015500155001550015500154001540015400154001530015300153001530015200152001520015250355003550035400354003530035300352003525
010800000355003540035300352503550035500354003540035300353003520035251155011540115301152511550115401153011525035500354003530035250155001540015300152500550005400053000525
010800000a5500a5400a5300a5250a5500a5500a5400a5400a5300a5300a5200a5250055000540005300052500550005400053000525085500854008530085250755007540075300752505550055400553005525
010800000155001540015300152500550005400053000525015500154001530015250355003540035300352503550035500354003540035300353003520035250055000550005400054000530005300052000525
01080000085500854008530085250a5500a5500a5400a5400a5300a5300a5200a5250855008540085300852507550075500754007540075300753007520075251f5501f545225502254518550185452955029545
01080000115501155011550115501154011540115401154011530115301153011530115201152011520115251155011550115501154011540115401153011530115301152011520115250a5500a5400a5300a525
010800000055000550005400054000520005250a5500a545085500854008530085250755007540075300752505550055500554005540055300553005520055250055000540005300052501550015400055000545
__music__
00 00424344
00 01424344
00 02424344
00 03424344
00 04424344
00 05424344
02 06424344

