pico-8 cartridge // http://www.pico-8.com
version 42
__lua__
#include renderer.p8
#include beziera.p8
#include text_mask.p8
t=0
stars1=""
stars2=""
stars_num=70
stars_high=200
planet_high=240
alienX=-300
alienY=45
smoke=""
bottleX=130
bottleY=130
bottleStars=""

function draw_creds()

end

function draw_bottleStars()
    for i=0,50 do
        local x=64+bottleStars[i*3+1]/bottleStars[i*3+3] * 60
        local y=64+bottleStars[i*3+2]/bottleStars[i*3+3] * 60
        pset(x,y,7)
    end
end

function move_bottleStars()
    for i=0,50 do
        bottleStars[i*3+3]-=0.02
        if(bottleStars[i*3+3]<0.1)then
            bottleStars[i*3+1]=rnd(2)-1
            bottleStars[i*3+2]=rnd(2)-1
            bottleStars[i*3+3]=1.5
        end
    end
end

function draw_bottle()
    spr(8,bottleX,bottleY,3,3)
end

function move_bottle()
    qt=(t-450)*0.01
    h=80
    w=128
    bottleY=h+(104-h)*(1-(1-qt)*(1-qt))
    bottleX=w+(-30-w)*(1-(1-qt)*(1-qt)*(1-qt))
end

function draw_smoke()
    for i=0,10 do
        circfill(smoke[i*2+1]*5+alienX-45,smoke[i*2+2]+alienY+50,smoke[i*2+1],7)
    end
end

function move_smoke()
    for i=0,10 do
        smoke[i*2+1]-=1
        if(smoke[i*2+1]<=0)then 
            smoke[i*2+1]=10
            smoke[i*2+2]=rnd(20) 
        end
    end
end

function draw_stars(stars,color)
    for i=0,stars_num do
        pset(stars[i*2+1],stars[i*2+2],color)
    end
end

function move_stars(stars)
    if(planet_high>64) then
        for i=0,stars_num do
            stars[i*2+2]=stars[i*2+2]-1
        end
    end
end

function draw_alien()
    spr(88,40+alienX,0+alienY,8,10)
    spr(162,0+alienX,40+alienY,5,5)
end

function move_alien(x)
    alienX+=x
    alienY+=sin(t/10)
end

function draw_planet()
    spr(0,0,planet_high,8,8)
    spr(0,64,planet_high,8,8,-1)
end

function move_planet()
    if(planet_high>64)then
        planet_high-=1
    end
end

function _init()
    init_renderer()
    init_beziera()
    init_text()
    reload(0x8000,0x0000,0x2000,"renderer.p8")
    for i=0,50 do
        bottleStars=bottleStars..(rnd(2)-1)..","..(rnd(2)-1)..","..rnd(1.5)..","
    end
    bottleStars=split(bottleStars)
    music(0)
    pal(2,129,1)
    pal(9,131,1)
    pal(4,140,1)
    for i=0,10 do
        smoke=smoke..i..","..rnd(20)..","
    end
    smoke=split(smoke)
    for i=0,stars_num do
        stars1=stars1..rnd(128)..","..rnd(stars_high)..","
    end
    for i=0,stars_num do
        stars2=stars2..rnd(128)..","..rnd(stars_high)..","
    end
    stars1=split(stars1)
    stars2=split(stars2)
end

function _update()
	t+=1
    if(t%3==0)then
        move_stars(stars1)
    end
    if(t%6==0)then
        move_stars(stars2)
    end
    if(t%2==0)then
        move_planet()
    end
    if(t>350)then
        move_alien(5)
    end
    move_smoke()
    if(t>450) then
        move_bottle()
    end
    if(t==515)then
        pal()
        memcpy(0x0000,0x8000,0x2000)

    end
    if(t>515)then
        move_bottleStars()
    end
    if(t>850 and t<=1150)then
        if(max_beziera_len<#calculatedCurve)then
            max_beziera_len+=3
            if(max_beziera_len>#calculatedCurve)then
                max_beziera_len=#calculatedCurve-1
            end
        end
    end
end

function _draw()
    cls()
    if(t<500)then
        draw_stars(stars2,5)
        draw_stars(stars1,7)
        draw_planet()
        draw_smoke()
        draw_alien()
        draw_bottle()
    elseif(t<=515)then
        rectfill(0,0,128,128,7)
    elseif(t<=800)then
        draw_bottleStars();
        draw_jabol("0,0,0,0")
        clearZBuffer();
    elseif(t<=815)then
        rectfill(0,0,128,128,7)
    elseif(t<=850)then
        spr(0,0,0,16,16)
    elseif(t<=1150)then
        draw_beziera()
    elseif(t<=1200)then
        draw_text()
    else
        stop()
    end
    -- print(t)
end
__gfx__
000000000000000000000000000000000000000000000000002195ddcdc6c6c60100000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000299ddc6ccc6c6c434431110000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000219ddc6cc34d343434344340111300000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000213dc6cc43433434443443434400133b3300000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000019dc6c3433343443433443434343000333bbb0000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000019dc6c6434344434344344343443434000333333c000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000996c644343444343443434434343343440003333311c00000000000000000000000000000000000000000000000000000
000000000000000000000000000029dc6443434344334434344343434344349300033331111c0000000000000000000000000000000000000000000000000000
0000000000000000000000000029dcc3434343443344334343349434949349490000331111cc1000000000000000000000000000000000000000000000000000
00000000000000000000000009dc66343434343444344949949939493949993400000111111cc100000000000000000000000000000000000000000000000000
000000000000000000000009dc64344344344343334934343949499949949499000000111111cc10000000000000000000000000000000000000000000000000
00000000000000000000029dc34343434344334944934999949999949999999900000001111111c1000000000000000000000000000000000000000000000000
000000000000000000029d6c34343434343944939994994949994999994999990000000011111113b00000000000000000000000000000000000000000000000
00000000000000000025cc3434434343494399494999999999999999999999990000000001111133bb0000000000000000000000000000000000000000000000
000000000000000009dc6343433434943499499999494999999999999999999900000000001113333b3000000000000000000000000000000000000000000000
00000000000000025c634434344943499934994949999999999999999999999900000000000133333bb300000000000000000000000000000000000000000000
000000000000001dc344343494343994949999999999999999999999999999990000000000003333333000000000000000000000000000000000000000000000
00000000000009dcd434349439994993999999999999999999999999199191910000000000000333330000000000000000000000000000000000000000000000
00000000000096c63343434943499494994999999999999999191191991991910000000000000033300000000000000000000000000000000000000000000000
0000000000296c434434949394999999999999999999991911991991911911910000000000000003000000000000000000000000000000000000000000000000
00000000025c43343499439499949999999999999191919919119119199299290000000000000000000000000000000000000000000000000000000000000000
000000002dc344349343949949999999999999919919191919929929219929910000000000000000000000000000000000000000000000000000000000000000
00000002363433434494999999999999999919199191929291299292991292290000000000000000000000000000000000000000000000000000000000000000
0000002d6c4494949399994999999999999191991192919192991291922929920000000000000000000000000000000000000000000000000000000000000000
000002dc343343999494999999999991911999129299292929229929299292190000000000000000000000000000000000000000000000000000000000000000
00002364344994949999999999999999199211992929292929922921922929220000000000000000000000000000000000000000000000000000000000000000
0000dc43439349394999499999999191911929129292929292299292229129290000000000000000000000000000000000000000000000000000000000000000
0005c634994499499999999999919191929299292929292912922292992292920000000000000000000000000000000000000000000000000000000000000000
009c6434349994999999999919191929292922929292129229292922229222220000000000000000000000000000000000000000000000000000000000000000
016c3499493499999999999991919292929292929229292922229292922929290000000000000000000000000000000000000000000000000000000000000000
9d434343949999999999991919192929292929292292922292922222292292220000000000000000000000000000000000000000000000000000000000000000
dc349994999499999991919192929292929212922922222929229292922222920000000000000000000000000000000000000000000000000000000000000000
c6434949949999999999191929292929212929229229292222292222229292220000000000000000000000000000000000000000000000000000000000000000
63493999999999999191919292929212929222922922229292222922922222220000000000000000000000000000000000000000000000000000000000000000
34949494999999999919192929292929222292292222922222922222222222920000000000000000000000000000000000000000000000000000000000000000
49399999999999919192929292922292292922222929222222222292222922220000000000000000000000000000000000000000000000000000000000000000
39494999999999191919292922292922922229222222229229222222222222220000000000000000000000000000000000000000000000000000000000000000
49999949999919919292921292922292229222292222222222222222222222220000000000000000000000000000000000000000000000000000000000000000
94949999999999191929229229229222922292222292222222222222222222220000000000000000000000000000000000000000000000000000000000000000
99999999991911929292292292292292222222222222222222222222222222220000000000000000000000000000000000000000000000000000000000000000
49999999999199292129229222922222292222292222222222222222222222220000000000000000000000000000000000000000000000000000000000000000
99499999191929129222922922229229222222222222222222222222222222220000000000000000000000000000000000000000000000000000000000000000
99999999919192929292292229222222222222222222222222222222222222220000000000000000000000000000000000000000000000000000000000000000
99999999191929292229222922222222222222222222222222222222222222220000000000000000000000000000000000000000000000000000000000000000
99999919192921229292292222292222222222222222222222222222222222220000000000000000000000000000000000000000000000000000000000000000
99999191929292922222222229222222222222222222222222222220220220220000000000000003333300000000000000000000000000000000000000000000
999199991929222929292292222222222222222222222222220220222222222200000000000033bbbbbbbbbb0000000000000000000000000000000000000000
999991129292929222222222222222222222222222222022022222222022022000000000000bbbbbbbbbbb3b0000000000000000000000000000000000000000
999199992922222292222222222222222222222222022222222020202220220200000000003bbbbbbbbb3bb3bb00000000000000000000000000000000000000
99991212929292922292222222222222222222220222202020222222022202220000000003333bbbb33bbbbbbbb0000000000000000000000000000000000000
919199992222222222222222222222222222220222202222222202022202202000000000333bbbbbbb3bbb0000b0000000000000000000000000000000000000
9991912229292922922222222222222222220222022220202020222220220222000000003bbb333bbbbbbb00000b000000000000000000000000000000000000
111922992222222222222222222222222022222222022222220220020202202000000003bbb33bbb33b33300000b000000000000000000000000000000000000
991992229292222222222222222222202220202022202020202022202220220200000003b3333333b33b33000000b00000000000000000000000000000000000
91922992222229222222222222220222222222220202220202220202200200200000003bb3333333bb3bbb077000b00000000000000000000000000000000000
929292222922222222222222222222022020202022202020220202020220220200000033333333333b333b077000b00000000000000000000000000000000000
9192929222222222222222222220222202222222020202220020202020020020000000333333333333333b070000b00000000000000000000000000000000000
929222229222222222222222202222022202020220222002202020202202202000000033333333333bbb33300000300000000000000000000000000000000000
29292922222222222222222222220222022022020220022002020202002002020000003333333333333bb33333b3300000000000000000000000000000000000
929222222222222222222202022022202202202202002200202020200200202000000033333333333333333333bb301000000000000000000000000000000000
2922922922222222222222222202202202202020202200220202002020200200000000033333333333333333333b011110000000000000000000000000000000
92922222222222222222022022220202202022020202200020002002000200200000000333333333333333333333011111b30000000000000000000000000000
9222922222222222222222220202222202020020202002020202020020202000000000003333333333333333b33000011bbbb003bb0000000000000000000000
22922222222222222220220222220200202202020200202000200020020002020000000033333333333333333330000033b333bbbbbb00000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000003333333333333333300000033333bb3333bb0000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000333333333333333000000000333b333333b1cc1000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000033333333333330000000000003333333311cccc00000000000000
000000000000000000000000000000000000000000000000000000000000000000000000000033333333333000000000000033333333111ccc13300300000000
00000000000000000000000000000000000000000000000000000000000000000000000000000033333333000000000000003333333111111111bbb300000000
000000000000000000000000000000000000000000000000000000000000000000000000000000033333bb300000000000bb33333311111111113bbb00000000
0000000000000000000000000000000000000000000000000000000000000000000000000000000333333bb0000000003bb3333333111111111333bb30000000
000000000000000000000000000000000000000000000000000000000000000000000000000000033333bbb30000000bbb333333331111111113333330000000
0000000000000000000000000000000000000000000000000000000000000000000000000000000333bbbbb33bbb003b33333333011111111113333330000000
000000000000000000000000000000000000000000000000000000000000000000000000000000033bbbb333333bb33333333300000001111113333330000000
000000000000000000000000000000000000000000000000000000000000000000000000000000033bb333333333333333330000000000001133333330000000
000000000000000000000000000000000000000000000000000000000000000000000000000000033b3333333333333333300000000000000033333300000000
00000000000000000000000000000000000000000000000000000000000000000000000000000003333333333333333330000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000003333333333033333300000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000003333333333300330000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000033333333333000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000033333333333000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000033333333333300000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000033333333333300000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000033333333333000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000333333333bbb300000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000000003333333333bbb30000000000000000000000000000000000000
0000000000000000000000066666666666666666666666777777777666666666666666666666633333333333bb36666666666666666666668880000000000000
0000000000000000000000066666666666666667777777777777776777667777776666666666663333333333bbb3366767777777776666668888880000000000
00000000000000000000000666666777777777776666667667777777777777777777777777665566333333333bbb366777777777777776668888888000000000
00000000000000000000000666666777777777777777777777777777777777677666666666665555633333333bbb366666666667766776668888888880000000
00000000000000000000000666666666667777766666666666666666666666777666666666666555553333333bb3666666666666666666668888ee8888000000
00000000000000000000000666666666666666666666666666666666666666666666666666666655555333333bb3666666666666666666668888eee888800000
0000000000000000000000066666666666666666666666666666666666666666666666666666666655563333333666666666666666666666888888ee88880000
00000000000000000000000666666666666666666666666666666666666666666666666666666666555333333336666666666666666666668888888ee8880000
000000000000000000000006666666666666666666666666666666666666666666666666666666655533333333666666666666666666666688888888eee88000
000000000000000000000006666666666666666666666666666666666666666666666666666666655533333336666666666666666666666688888888eeeee800
000000000000000000000006666666666666666666666666666666666666666666666666666666655633333366666666666666666666666688888888eeeeee00
0000000000000000000000066666666666666666666666666666666666666666666666666666666553333366666666666666666666666666888888888eeeee00
0000000000000000000000066666666666666666666666666666666666666666666666666666666556333666666666666666666666666666888888888eeee880
00000000000000000000000666666666666666666666666666666666666666666666666666666665533336666666666666666666666666668888888888ee8880
00000000000000000000000666666666666666666666666666666666666666666666666666666665533333666666666666666666666666668888888888888880
00000000000000000000000666666666666666666666666666666666666666666666666666666665553333366666666666666666666666668888888888888880
00000000000000000000000666666666666666666666666666666666666666666666666666666665553333336666666666666666666666668888888888888880
00000000000000000000000666666666666666666666666666666666666666666666666666666665566333333666666666666666666666668888888888888880
00000000000000000000000666666666666666666666666666666666666666666666666666666666666333333666666666666666666666668888888888888880
00000000000000000000000666666666666666666666666666666666666666666666666666666666666633336666666666666666666666668888888888888880
00000000000000000000000666666666666666666666666666666666666666666666666666666666666666666666666666666666666666668888888888888800
00000000000000000000000666666666666666666666666666666666666666666666666666666666666666666666666666666666666666668888888888888800
00000000000000000000000666666666666666666666666666666666666666666666666666666666666666666666666666666666666666668888888888888800
00000000000000000000000666666666666666666666666666666666666666666666666666666666666666666666666666666666666666668888888888888000
00000000000000000000000666666666666666666666666666666666666666666666666666666666666666666666666666666666666666668888888888880000
00000000000000000000000666666666666666666666666666666666666666666666666666666666666666666666666666666666666666668888888888880000
00000000000000000000000665555555555555555556666666666666666666665555555555555555555666666666666555555556666666668888888888800000
00000000000000000000000666666666666666555555555556666655555555555555555556666666666555555555555555555555555556668888888888000000
00000000000000000000000655555555555555665666655555555555555555556666666666666666666666566665555556666665556666668888888880000000
00000000000000000000000556665555555555555555555566655666655555555555555555555555555555555555555555555555655556668888888000000000
00000000000000000000000566666555555555556666666666666665556655555555555555666666666666666655555555555555556655568888880000000000
00000000000000000000000555555555555560655555555555555555555566666666666666666666655555555566666666666666655555568880000000000000
__sfx__
010c00002155000500245500050028550005002d55000500215500c500235500050028550005002b550005001f55000500235500050026550005002b550005001d55000500215500050024550005002955000500
010c000015516185161c516185160e51611516155161151613516175161a516175161151615516185161551615516185161c516185160e51611516155161151613516175161a5161751611516155161851615516
010c000021335003050c305003051a335003050c305003051f335003050c305003051d335003050c3050030521335003050c305003051a335003050c305003051f335003050c305003051d335003050c30500305
010c00001503300000156250000015033000001562500000150330000015625000001503300000156250000015033000001562500000150330000015625000001503300000156250000015033000001562500000
010c000015516185161c516185161f516175161a516175161a5161d516155161d516185161c5161f5161c51615516185161c516185161f516175161a516175161a5161d516155161d516185161c5161f5161c516
010c000015516185161c5161851613516175161a516175160e5161151615516115160c51610516135161051615516185161c5161851613516175161a516175160e5161151615516115160c516105161351610516
010c000015537185371c5371853713507175071a5071750713537175371a537175370c5071050713507105070e53711537155371153713507175071a507175070c5371053713537105370c507105071350710507
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
010c00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
__music__
00 14414243
00 41424203
00 40410203
00 00410203
00 00020341
01 00010203
00 00040203
00 00010203
02 00050203

