/**
 * This script is a draw function you need to fill.
 * It should draw a design based on the seed.
 * Canvas is 100x100 units.
 *
 * Available variables:
 * ctx: the CanvasRenderingContext2D to draw on
 * seed: array of numbers 0-255
 */
ctx.translate(5, 5)
ctx.textAlign = "center"
ctx.textBaseline = "middle"

const length = seed.length
const grid = Math.ceil(Math.sqrt(length))
const cellSize = Math.floor(90 / grid)
const fontSize = Math.max(8, Math.floor(cellSize * 0.4))
ctx.font = `${fontSize}px sans-serif`

function seededRandomInt(seed, min, max) {
  const rand = seededRandom(seed);
  return Math.floor(rand() * (max - min + 1)) + min;
}

function seededRandom(seed) {
  return function() {
    seed = (seed * 1664525 + 1013904223) >>> 0; // keep 32-bit unsigned
    return seed / 4294967296;
  };
}

function seedRandom(seed) {
  // Simple deterministic pseudo-random generator (LCG)
  return function() {
    seed = (seed * 1664525 + 1013904223) % 4294967296;
    return seed / 4294967296;
  };
}

function shuffleBits(n, seed) {
  const rng = seedRandom(seed);
  const bits = [];

  // Extract 32 bits
  for (let i = 0; i < 32; i++) {
    bits[i] = (n >> i) & 1;
  }

  // Shuffle bits using Fisher-Yates
  for (let i = 31; i > 0; i--) {
    const j = Math.floor(rng() * (i + 1));
    [bits[i], bits[j]] = [bits[j], bits[i]];
  }

  // Recombine bits into an integer
  let result = 0;
  for (let i = 0; i < 32; i++) {
    result |= (bits[i] << i);
  }

  return result >>> 0; // force unsigned
}



function cartoonEye(x, y, pupilX, pupilY, size = 10) {
  // White eyeball
  ctx.beginPath();
  ctx.fillStyle = 'white';
  ctx.strokeStyle = 'black';
  ctx.lineWidth = 5;
  ctx.arc(x, y, size, 0, Math.PI * 2);
  ctx.fill();
  ctx.stroke();

  // Black pupil
  ctx.beginPath();
  ctx.fillStyle = 'black';
  ctx.arc(x+pupilX, y+pupilY, size / 3, 0, Math.PI * 2);
  ctx.fill();



}

function eye(side, seed)
{
 seed = seed+1;
  var curX = 0;
  var curY = 0;
  if(side == 1)
  {
    curX = 70;
    curY = 35;    
  }
  else
  {
    curX = 30;
    curY = 30;     
  }
      
  
  //seed = 1;

  ctx.lineWidth = 5; // Thicker line
  ctx.beginPath();
 
  switch(seed)
  {
    case 0:
      ctx.arc(curX-5, curY, 10, 0, Math.PI * 2);
      ctx.stroke();
      break;
    case 1:
      ctx.moveTo(curX-10, curY-7);
      ctx.lineTo(curX+5, curY+8);
      ctx.moveTo(curX+5, curY-7);
      ctx.lineTo(curX-10, curY+8);      
      ctx.stroke();
      
    break;
     case 2:
      ctx.moveTo(curX-15, curY-5);
      ctx.lineTo(curX, curY);   
      ctx.stroke();
      ctx.beginPath;   
      ctx.arc(curX-5, curY, 10, 0, Math.PI * 2);
      ctx.stroke();
            ctx.beginPath();
        ctx.fillStyle = 'black';
        ctx.arc(curX-4, curY+5, 10 / 3, 0, Math.PI * 2);
        ctx.fill();
      break;   
      case 3:
        cartoonEye(curX, curY, 0, 0)
      break;
      case 4:
        cartoonEye(curX, curY, 0, 5)
      break;
      case 5:
        cartoonEye(curX, curY, 5, 5)
      break;
      case 6:
        cartoonEye(curX, curY, -5, 0)
      break;     
       case 7:
        cartoonEye(curX, curY, -5, 5)
      break;  
       case 8:
        cartoonEye(curX, curY, -5, -5)
      break;    
      case 9:
      ctx.moveTo(curX-15, curY);
        ctx.lineTo(curX, curY-5);   
        ctx.stroke();
        ctx.beginPath;   
        ctx.arc(curX-5, curY, 10, 0, Math.PI * 2);
        ctx.stroke();
        ctx.beginPath();
        ctx.fillStyle = 'black';
        ctx.arc(curX-5, curY+5, 10 / 3, 0, Math.PI * 2);
        ctx.fill();
      break;   

  }
   
      
    

     // ctx.lineTo(200, 100);
  
   

}

function mouth(seed)
{
  ctx.lineWidth = 5; // Thicker line
  ctx.beginPath();

  var curX = 50;
  var curY  = 80;
  switch(seed)
  {
    case 0:
    curY +=10
       ctx.moveTo(curX-20, curY-5);
      ctx.lineTo(curX+20, curY-5);
      ctx.stroke();
      ctx.beginPath();
      ctx.strokeRect(curX+1, curY-15, 10, 10);
      ctx.stroke();
      break;
    case 1:
      ctx.arc(curX-5, curY, 10, 0, Math.PI * 2);
      ctx.stroke();
      break; 
      case 2: 
      ctx.moveTo(curX-15, curY-5);
      ctx.lineTo(curX+15, curY-5);
      ctx.stroke();
      break;
      case 3: 
      ctx.moveTo(curX-15, curY+3);
      ctx.lineTo(curX+15, curY-5);
      ctx.stroke();
      break; 
      case 4:
      ctx.moveTo(curX-15, curY-5);
      ctx.lineTo(curX+15, curY+4);
      ctx.stroke();
      break;     
    case 5:
      ctx.beginPath();
      ctx.arc(curX-5, curY+5, 10, 0, Math.PI, true); // Bottom half
      ctx.stroke();
      break;
      case 6:
      ctx.beginPath();
      ctx.arc(curX-5, curY, 10, 0, Math.PI, false); // Bottom half
      ctx.stroke();
      break;    
    case 7:
       ctx.moveTo(curX-20, curY-5);
      ctx.lineTo(curX+20, curY-5);
      ctx.stroke();
      ctx.beginPath();
      ctx.arc(curX+6, curY-3, 7, 0, Math.PI, false); // tongue
      ctx.stroke();
      break;      

    break;
  }
}

function nose(s)
{
  ctx.lineWidth = 5; // Thicker line
  ctx.beginPath();

  var curX = 47;
  var curY  = 48;
  switch(s)
  {
    case 0:

        ctx.beginPath();
        ctx.strokeStyle = 'black';

        ctx.moveTo(curX, curY);
        ctx.lineTo(curX -4, curY + 10);  // down
        ctx.lineTo(curX + 8, curY + 10); // outward
        ctx.stroke();
      break;
          case 1:

        ctx.beginPath();
        ctx.fillStyle = 'black';
        ctx.arc(curX, curY+6, 3, 0, Math.PI * 2); // small circle
        ctx.fill();
      break;
    case 2:

        ctx.beginPath();
        ctx.strokeStyle = 'black';
        ctx.arc(curX-5, curY, 5, Math.PI * 0.1, Math.PI * 0.9, false); // gentle arch
        ctx.arc(curX-5, curY, 5, Math.PI * 0.1, Math.PI * 0.9, false); // gentle arch
        ctx.stroke();      
    break;
     case 3:

        ctx.beginPath();
        ctx.strokeStyle = 'black';
        ctx.arc(curX-5, curY, 5, Math.PI * 0.1, Math.PI * 0.9, false); // gentle arch
        ctx.arc(curX+5, curY, 5, Math.PI * 0.1, Math.PI * 0.9, false); // gentle arch
        ctx.stroke();
      break; 
  }
}

function eyeBrown(s, side)
{
    ctx.lineWidth = 5; // Thicker line
  ctx.beginPath();

  var curX = 20;
  var curY  = 17;

  if(side == 1)
  {
      var curX = 60;
      var curY  = 22; 
  }

  switch(s)
  {
    case 0:
        ctx.beginPath();
        ctx.moveTo(curX-4, curY);
        ctx.lineTo(curX+6, curY-10);
        ctx.lineTo(curX+16, curY);
        ctx.stroke();
      break;
    case 1:
        ctx.beginPath();
        ctx.moveTo(curX-5, curY);
        ctx.lineTo(curX+15, curY);
        ctx.stroke();
      break;      
    case 2:
        ctx.beginPath();
        ctx.moveTo(curX-5, curY);
        ctx.lineTo(curX+15, curY-8);
        ctx.stroke();
      break;  
    case 3:
        ctx.beginPath();
        ctx.moveTo(curX-5, curY-8);
        ctx.lineTo(curX+15, curY);
        ctx.stroke();
      break;          
  }
}

function cheek(s, side)
{
      ctx.lineWidth = 5; // Thicker line
  ctx.beginPath();

  var curX = 20;
  var curY  = 60;

  var mul = 1;
  if(side == 1)
  {
      var curX =70;
      var curY  = 60; 
      mul = -1;
  }
  switch(s)
  {
    case 0:
        ctx.beginPath();
        ctx.moveTo(curX, curY);            // Start point
        ctx.quadraticCurveTo(curX +10*mul, curY+30, curX -10*mul, curY+30); // Control point + end
        ctx.stroke();
      break;
  
  case 1:
        ctx.beginPath();
        ctx.moveTo(curX-10*mul, curY);
        ctx.lineTo(curX , curY+30);

        ctx.stroke();
      break;
    case 2:
        ctx.beginPath();
        ctx.moveTo(curX, curY);
        ctx.lineTo(curX , curY+30);
        ctx.stroke();
      break;
    case 3:
        ctx.beginPath();
        ctx.moveTo(curX, curY);            // Start point
        ctx.quadraticCurveTo(curX -10*mul, curY+30, curX +10*mul, curY+30); // Control point + end
        ctx.stroke();
      break;      

  }
}

function ear(s, side)
{
        ctx.lineWidth = 5; // Thicker line
  ctx.beginPath();

  var curX = 10;
  var curY  = 20;

  var mul = 1;
  if(side == 1)
  {
      var curX = 80;
      var curY  = 20; 
      mul = -1;
  }
  switch(s)
  {
    case 0:
        ctx.beginPath();
        ctx.moveTo(curX -1*mul, curY+35);            // Start point
        ctx.quadraticCurveTo(curX -1*mul, curY+10, curX -10*mul, curY+10); // Control point + end
        ctx.stroke();
      break;
     case 1:
        ctx.beginPath();
        ctx.moveTo(curX -1*mul, curY+10);            // Start point
        ctx.quadraticCurveTo(curX -10*mul, curY+20, curX -1*mul, curY+20); // Control point + end
        ctx.stroke();
      break;     
     case 2:
        ctx.beginPath();
        ctx.moveTo(curX -1*mul, curY+40);            // Start point
        ctx.quadraticCurveTo(curX -10*mul, curY+0, curX -1*mul, curY+20); // Control point + end
        ctx.stroke();
      break; 
      case 3:
        ctx.beginPath();
        ctx.moveTo(curX -1*mul, curY+35);            // Start point
        ctx.quadraticCurveTo(curX -20*mul, curY+10, curX -1*mul, curY+20); // Control point + end
        ctx.stroke();
      break;        
  }
}

function headUp(s, side)
{
  ctx.lineWidth = 5; // Thicker line
  ctx.beginPath();

  var curX = 10;
  var curY  = 0;

  var mul = 1;
  if(side == 1)
  {
      var curX = 80;
      var curY  = 0; 
      mul = -1;
  }
  switch(s)
  {
    case 0:
        ctx.beginPath();
        ctx.moveTo(curX -1*mul, curY+35);            // Start point
        ctx.quadraticCurveTo(curX -10*mul, curY+30, curX +4*mul, curY+10); // Control point + end
        ctx.stroke();
      break;
    case 1:
        ctx.beginPath();
        ctx.moveTo(curX -1*mul, curY+35);            // Start point
        ctx.quadraticCurveTo(curX -1*mul, curY+10, curX -10*mul, curY+10); // Control point + end
        ctx.stroke();
      break;
    case 2:
        ctx.beginPath();
        ctx.moveTo(curX -1*mul, curY+35);            // Start point
        ctx.quadraticCurveTo(curX -2*mul, curY+10, curX +4*mul, curY+10); // Control point + end
        ctx.stroke();
      break;
    case 3:
        ctx.beginPath();
        ctx.moveTo(curX -1*mul, curY+35);            // Start point
        ctx.quadraticCurveTo(curX -20*mul, curY+10, curX +4*mul, curY+10); // Control point + end
        ctx.stroke();
      break;      
  }
}

function hair(s)
{
    ctx.lineWidth = 5; // Thicker line
  ctx.beginPath();

  var curX = 10;
  var curY  = 5;

  switch(s)
  {
    case 0:
        ctx.beginPath();
        ctx.moveTo(curX+0 , curY-7);            // Start point
        ctx.quadraticCurveTo(curX+40, curY+8, curX+65, curY-6); // Control point + end
        ctx.stroke();
       ctx.beginPath();
        ctx.moveTo(curX , curY-7);            // Start point
        ctx.quadraticCurveTo(curX+40, curY, curX+65, curY); // Control point + end
        ctx.stroke(); 
        ctx.beginPath();
        ctx.moveTo(curX , curY);            // Start point
        ctx.quadraticCurveTo(curX+40, curY-12, curX+65, curY); // Control point + end
        ctx.stroke();            
      break;
    case 1:
        ctx.beginPath();
        ctx.moveTo(curX , curY);            // Start point
        ctx.quadraticCurveTo(curX+40, curY-12, curX+65, curY); // Control point + end
        ctx.stroke();
      break; 
     case 1:
  
      break;  
    case 2:
        ctx.beginPath();
        ctx.moveTo(curX , curY-7);            // Start point
        ctx.quadraticCurveTo(curX+40, curY, curX+65, curY); // Control point + end
        ctx.stroke();
      break;  
    case 3:
        ctx.beginPath();
        ctx.moveTo(curX+0 , curY-7);            // Start point
        ctx.quadraticCurveTo(curX+40, curY+8, curX+65, curY-6); // Control point + end
        ctx.stroke();
      break;                  
  }
}
var usedBits = 0;
function getBitSequence(n, start, length) {
  // Shift right to align the desired bits at the bottom,
  // then mask with the appropriate number of 1s.
  return (n >>> start) & ((1 << length) - 1);
}

function getBits(num, count)
{
  let value =  getBitSequence(num, usedBits, count); 
  usedBits += count;
  console.log(usedBits);
  return value;
}

function noseBridge(s)
{
      ctx.lineWidth = 5; // Thicker line
  ctx.beginPath();

  var curX = 10;
  var curY  = 20;

  switch(s)
  {
    case 0:

      break;
    case 1:
        ctx.beginPath();
        ctx.moveTo(curX+40 , curY+5);            // Start point
        ctx.quadraticCurveTo(curX+40, curY+30, curX+50, curY+30); // Control point + end
        ctx.stroke();
      break;      
    case 2:
        ctx.beginPath();
        ctx.moveTo(curX+35 , curY+5);            // Start point
        ctx.quadraticCurveTo(curX+35, curY+30, curX+25, curY+30); // Control point + end
        ctx.stroke();
      break;
     case 3:
        ctx.beginPath();
        ctx.moveTo(curX+38 , curY+5);            // Start point
        ctx.quadraticCurveTo(curX+35, curY+30, curX+20, curY+30); // Control point + end
        ctx.stroke();
        ctx.beginPath();
        ctx.moveTo(curX+45 , curY+5);            // Start point
        ctx.quadraticCurveTo(curX+40, curY+30, curX+50, curY+30); // Control point + end
        ctx.stroke();
      break;      
  }
}

function underEye(s){

  if(s == 1)
  {
    var curX = 17;
    var curY = 43;
  ctx.lineWidth = 5; // Thicker line
      ctx.beginPath();
      ctx.moveTo(curX , curY);            // Start point
      ctx.quadraticCurveTo(curX+10, curY+5, curX+20, curY); // Control point + end
      ctx.stroke();
      
  }
}


  // Draw cell border
  ctx.strokeStyle = "#000"
  //ctx.strokeRect(x, y, cellSize, cellSize)

  // Draw number
  ctx.fillStyle = "#000"
  //ctx.fillText(n.toString(), x + cellSize / 2, y + cellSize / 2)
  ctx.lineWidth = 5; // Set line thickness to 5 pixels
//  ctx.beginPath();
 //   ctx.moveTo(50, 50);
 //   ctx.lineTo(200, 100);
 //   ctx.lineWidth = 5; // Thicker line
 // ctx.stroke();

 let originalSeed = Number(numeric(seed));
  let randNumb = seededRandomInt(originalSeed, 0, 4294967295);
  let shuffled = shuffleBits(originalSeed, randNumb);

 //console.log(randNumb);  
  //console.log(originalSeed); 



    eye(0, getBits(shuffled, 3));
    eye(1, getBits(shuffled, 3));
    mouth(getBits(shuffled, 3));
    nose(getBits(shuffled, 2));
    eyeBrown(getBits(shuffled, 2), 0);
    eyeBrown(getBits(shuffled, 2), 1);
    cheek(getBits(shuffled, 2), 0);
    cheek(getBits(shuffled, 2),1);
    ear(getBits(shuffled, 2),0);
    ear(getBits(shuffled, 2),1);
    headUp(getBits(shuffled, 2), 0);
    headUp(getBits(shuffled, 2), 1);
    hair(getBits(shuffled, 2));
    noseBridge(getBits(shuffled, 2));
    underEye(getBits(shuffled, 1));
    
  
