Program
	MineSweeper;

Uses
	Crt,
	Dos,
	Maus,
	Usr,
	M13;

Const
	Mines : Byte = 100;
	XSize : Byte =  38;
	YSize : Byte =  21;

Type                                    { msccnnnn - m : Mine?     }
	TField = Array[0..37, 0..20] Of Byte; {            c : Checked?  }
																				{            n : Neighbors }
Var                                     {            s : Solve?    }
	Field     :  TField;                  { cc - 00 : Plain                   }
	Solved    : Boolean;                  {      01 : Mine                    }
	MinesLeft :    Byte;                  {      10 : Q-Mark                  }
	Opened		:    Word;                  {      11 : Opened                  }
	Game      ,
	Changed   : Boolean;
	Status    :    Byte;
	StartTime ,
	CurTime   : LongInt;
	XO        ,
	YO        :    Byte;















Type
	TSprite = Array[0..5, 0..5] Of Byte;
	PHigh = ^THigh;
	THigh = Record
		Name  : String[31];
		Time  : Word;
		XSize ,
		YSize ,
		Mines : Byte;
		Day   ,
		Month ,
		Year  : Word
	End;

Var
	Highs     : Array[1..10] Of PHigh;

Const
	Mine    = 0;
	Found   = 1;
	QMark   = 2;
	XMine   = 3;
	RedMine = 4;
	Closed  = 5;
	Open    = 6;

	HandCursor  : SCMaskType = (
    SMask: ($87FF,$003F,$0007,$6003,$E001,$F001,$C000,$8000,
            $8000,$F000,$FC00,$FF00,$FFC0,$FFF0,$FFFF,$FFFF);
    CMask: ($2000,$5200,$9140,$0928,$08A4,$0494,$0414,$3202,
            $0E01,$0301,$00C0,$0030,$000C,$0000,$0000,$0000));

	InpColor  =  9;
	ForeColor =  3;
	KeyColor  = 14;










	Sprite : Array[Mine..Open] Of TSprite =
		((( 7,  0,  7,  7,  0,  7),
			( 0,  7,  0,  0,  7,  0),
			( 7,  0,  0,  0,  0,  7),
			( 7,  0,  0,  0,  0,  7),
			( 0,  7,  0,  0,  7,  0),
			( 7,  0,  7,  7,  0,  7)),
		 (( 7,  7,  4,  0,  7,  7),
			( 7,  4,  4,  0,  7,  7),
			( 7,  7,  7,  0,  7,  7),
			( 7,  7,  7,  0,  7,  7),
			( 7,  7,  0,  0,  7,  7),
			( 7,  0,  0,  0,  0,  7)),
		 (( 7,  7,  0,  0,  7,  7),
			( 7,  0,  7,  7,  0,  7),
			( 7,  7,  7,  7,  0,  7),
			( 7,  7,  0,  0,  7,  7),
			( 7,  7,  7,  7,  7,  7),
			( 7,  7,  0,  0,  7,  7)),
		 (( 4,  0,  7,  7,  0,  4),
			( 0,  4,  0,  0,  4,  0),
			( 7,  0,  4,  4,  0,  7),
			( 7,  0,  4,  4,  0,  7),
			( 0,  4,  0,  0,  4,  0),
			( 4,  0,  7,  7,  0,  4)),
		 (( 4,  0,  4,  4,  0,  4),
			( 0,  4,  0,  0,  4,  0),
			( 4,  0,  0,  0,  0,  4),
			( 4,  0,  0,  0,  0,  4),
			( 0,  4,  0,  0,  4,  0),
			( 4,  0,  4,  4,  0,  4)),
		 (( 8,  8,  8,  8,  8,  7),
			( 8,  7,  7,  7,  7, 15),
			( 8,  7,  7,  7,  7, 15),
			( 8,  7,  7,  7,  7, 15),
			( 8,  7,  7,  7,  7, 15),
			( 7, 15, 15, 15, 15, 15)),
		 (( 7,  7,  7,  7,  7,  7),
			( 7,  7,  7,  7,  7,  7),
			( 7,  7,  7,  7,  7,  7),
			( 7,  7,  7,  7,  7,  7),
			( 7,  7,  7,  7,  7,  7),
			( 7,  7,  7,  7,  7,  7)));


	Num : Array[0..9] Of TSprite =
		((( 7, 12, 12, 12, 12,  7),
			(12, 12,  7,  7, 12, 12),
			(12, 12,  7,  7, 12, 12),
			(12, 12,  7,  7, 12, 12),
			(12, 12,  7,  7, 12, 12),
			( 7, 12, 12, 12, 12,  7)),

		 (( 7,  7,  9,  9,  7,  7),
			( 7,  9,  9,  9,  7,  7),
			( 7,  7,  9,  9,  7,  7),
			( 7,  7,  9,  9,  7,  7),
			( 7,  7,  9,  9,  7,  7),
			( 7,  9,  9,  9,  9,  7)),

		 (( 7,  2,  2,  2,  2,  7),
			( 2,  2,  7,  7,  2,  2),
			( 7,  7,  7,  7,  2,  2),
			( 7,  7,  2,  2,  2,  7),
			( 7,  2,  2,  7,  7,  7),
			( 2,  2,  2,  2,  2,  2)),

		 (( 7,  4,  4,  4,  4,  7),
			( 4,  4,  7,  7,  4,  4),
			( 7,  7,  7,  4,  4,  7),
			( 7,  7,  7,  7,  4,  4),
			( 4,  4,  7,  7,  4,  4),
			( 7,  4,  4,  4,  4,  7)),

		 (( 7,  7,  1,  1,  1,  7),
			( 7,  1,  1,  1,  1,  7),
			( 1,  1,  7,  1,  1,  7),
			( 1,  1,  1,  1,  1,  1),
			( 7,  7,  7,  1,  1,  7),
			( 7,  7,  7,  1,  1,  7)),

		 (( 6,  6,  6,  6,  6,  6),
			( 6,  6,  7,  7,  7,  7),
			( 6,  6,  6,  6,  6,  7),
			( 7,  7,  7,  7,  6,  6),
			( 7,  7,  7,  7,  6,  6),
			( 6,  6,  6,  6,  6,  7)),



		 (( 7,  3,  3,  3,  3,  7),
			( 3,  3,  7,  7,  7,  7),
			( 3,  3,  3,  3,  3,  7),
			( 3,  3,  7,  7,  3,  3),
			( 3,  3,  7,  7,  3,  3),
			( 7,  3,  3,  3,  3,  7)),

		 (( 5,  5,  5,  5,  5,  5),
			( 7,  7,  7,  7,  5,  5),
			( 7,  7,  7,  5,  5,  7),
			( 7,  7,  5,  5,  7,  7),
			( 7,  7,  5,  5,  7,  7),
			( 7,  7,  5,  5,  7,  7)),

		 (( 7,  0,  0,  0,  0,  7),
			( 0,  0,  7,  7,  0,  0),
			( 7,  0,  0,  0,  0,  7),
			( 0,  0,  7,  7,  0,  0),
			( 0,  0,  7,  7,  0,  0),
			( 7,  0,  0,  0,  0,  7)),

		 (( 7,  8,  8,  8,  8,  7),
			( 8,  8,  7,  7,  8,  8),
			( 8,  8,  7,  7,  8,  8),
			( 7,  8,  8,  8,  8,  8),
			( 7,  7,  7,  7,  8,  8),
			( 7,  8,  8,  8,  8,  7)));


















Procedure
	Update;

	Function
		Neigh(X, Y : Byte) : Byte;

		Var
			A ,
			B : ShortInt;
			C :     Byte;

		Begin
			C := 0;
			For A := X - 1 To X + 1 Do
				For B := Y - 1 To Y + 1 Do
					If
						(A >=     0) And
						(B >=     0) And
						(A <  XSize) And
						(B <  YSize) Then
						Inc(C, (Field[A, B] And 128) ShR 7);
			Neigh := C - ((Field[X, Y] And 128) ShR 7)
		End;

	Var
		X ,
		Y : Byte;

	Begin
		For X := 0 To XSize - 1 Do
			For Y := 0 To YSize - 1 Do
				Field[X, Y] := (Field[X, Y] And 240) Or Neigh(X, Y)
	End;












Procedure
	Draw(X, Y : Integer; D : Byte; Number : Boolean);

	Var
		A ,
		B : Integer;

	Begin
		For A := X * 8 To X * 8 + 7 Do
			For B := Y * 8 To Y * 8 + 7 Do
				Screen[YO + B, XO + A] := 7;
		If (Not Number) And ((D = Closed) Or (D = Found) Or (D = QMark)) Then
		Begin
			For A := X * 8 To X * 8 + 6 Do
			Begin
				Screen[YO + Y * 8    , XO + A    ] := 15;
				Screen[YO + Y * 8 + 7, XO + A + 1] :=  8
			End;
			For B := Y * 8 + 1 To Y * 8 + 6 Do
			Begin
				Screen[YO + B, XO + X * 8    ] := 15;
				Screen[YO + B, XO + X * 8 + 7] :=  8
			End
		End;
		For A := 0 To 5 Do
			For B := 0 To 5 Do
				If Not Number Then
					Screen[YO + Y * 8 + B + 1, XO + X * 8 + A + 1] := Sprite[D, B, A]
				Else
					Screen[YO + Y * 8 + B + 1, XO + X * 8 + A + 1] := Num[D, B, A]
	End;














Procedure
	DrawField;

	Procedure
		DrawQuad(X, Y : Byte);

		Begin
			If Field[X, Y] And 64 = 0 Then
				Case (Field[X, Y] And 48) ShR 4 Of
					0 : Draw(X, Y, Closed, False);
					1 : Draw(X, Y, Found, False);
					2 : Draw(X, Y, QMark, False);
					3 : If Field[X, Y] And 15 = 0 Then
						Draw(X, Y, Open, False)
					Else
						Draw(X, Y, Field[X, Y] And 15, True);
				End
			Else
				If Field[X, Y] And 128 = 0 Then
					Case (Field[X, Y] And 48) ShR 4 Of
						0 : If Field[X, Y] And 15 = 0 Then
							Draw(X, Y, Open, False)
						Else
							Draw(X, Y, Field[X, Y] And 15, True);
						1 : Draw(X, Y, XMine, False);
						2 : Draw(X, Y, Closed, False);
						3 : If Field[X, Y] And 15 = 0 Then
							Draw(X, Y, Open, False)
						Else
							Draw(X, Y, Field[X, Y] And 15, True)
					End
				Else
					Case (Field[X, Y] And 48) ShR 4 Of
						0 : Draw(X, Y, Mine, False);
						1 : Draw(X, Y, Found, False);
						2 : Draw(X, Y, Mine, False);
						3 : Draw(X, Y, RedMine, False)
					End
		End;






	Var
		H ,
		Z ,
		E :    Byte;
		X ,
		Y : Integer;

	Begin
		HideMaus;
		H := MinesLeft Div 100;
		Z := (MinesLeft - 100 * H) Div 10;
		E := MinesLeft - 100 * H - 10 * Z;
		Draw(1, -2, H, True);
		Draw(2, -2, Z, True);
		Draw(3, -2, E, True);
		Draw(XSize Div 2, -2, Status, False);
		For X := XO - 2 To 320 - XO Do
		Begin
			Screen[      YO - 2, X    ] := 15;
			Screen[200 - YO    , X + 1] := 15;
			Screen[      YO - 1, X    ] :=  8;
			Screen[201 - YO    , X + 1] :=  8
		End;
		For Y := YO - 1 To 200 - YO Do
		Begin
			Screen[Y,       XO - 2] := 15;
			Screen[Y, 320 - XO    ] := 15;
			Screen[Y,       XO - 1] :=  8;
			Screen[Y, 321 - XO    ] :=  8
		End;
		Screen[YO - 1, 320 - XO] := 7;
		Screen[YO - 2, 321 - XO] := 7;
		Screen[200 - YO, XO - 1] := 7;
		Screen[201 - YO, XO - 2] := 7;
		For X := 0 To XSize - 1 Do
			For Y := 0 To YSize - 1 Do
				DrawQuad(X, Y);
		ShowMaus
	End;






Procedure
	Solve;

	Var
		X ,
		Y : Byte;

	Begin
		Solved :=  True;
		Game   := False;
		For X := 0 To XSize - 1 Do
			For Y := 0 To YSize - 1 Do
				Field[X, Y] := Field[X, Y] Or 64;
		DrawField
	End;

Procedure
	Lose;

	Begin
		Status := RedMine;
		Solve
	End;

Procedure
	Win;

	Begin
		Status := Found;
		Solve
	End;














Function
	GetTime : LongInt;

	Var
		H ,
		M ,
		S ,
		B : Word;

	Begin
		Dos.GetTime(H, M, S, B);
		GetTime := S + M * 60 + H * 3600
	End;

Procedure
	DrawTime;

	Var
		Time : LongInt;
		H    ,
		Z    ,
		E    : Byte;

	Begin
		Time := CurTime - StartTime;
		If Time < 0 Then
		Begin
			Inc(     Time, 86400);
			Dec(StartTime, 86400)
		End;
		If Time >= 1000 Then
			Lose
		Else
		Begin
			HideMaus;
			H := Time Div 100;
			Z := (Time - 100 * H) Div 10;
			E := Time - 100 * H - 10 * Z;
			Draw(XSize - 4, -2, H, True);
			Draw(XSize - 3, -2, Z, True);
			Draw(XSize - 2, -2, E, True);
			ShowMaus
		End
	End;

Procedure
	NewGame;

	Var
		C ,
		X ,
		Y : Byte;

	Begin
		Game      :=      True;
		Solved    :=     False;
		MinesLeft :=     Mines;
		Opened    :=         0;
		Status    :=     QMark;
		StartTime :=   GetTime;
		CurTime   := StartTime;
		XO := 160 - XSize * 4;
		YO := 100 - YSize * 4;
		For X := 0 To XSize - 1 Do
			For Y := 0 To YSize - 1 Do
				Field[X, Y] := 0;
		For C := 1 To Mines Do
		Begin
			Repeat
				Y := Random(YSize);
				X := Random(XSize)
			Until Field[X, Y] And 128 = 0;
			Field[X, Y] := Field[X, Y] Or 128
		End;
		Update
	End;














Procedure
	Init;

	Var
		C ,
		X ,
		Y : Byte;

	Begin
		SetMode($13);
		StartTime := StartTime + (GetTime - CurTime);
		MausInit;
		Repeat
		Until MausButton = 0;
		SetMausPos(160, 100);
		MausWindow(0, 0, 319, 199);
		MausGrafikCursor(0, 2, HandCursor);
		ShowMaus;
		DrawField
	End;

























Procedure
	LeftClick(X, Y : Byte);

	Var
		A ,
		B : ShortInt;

	Begin
		If Field[X, Y] And 16 = 0 Then
		Begin
			Inc(Opened);
			Field[X, Y] := Field[X, Y] Or 48;
			If Field[X, Y] And 128 = 0 Then
			Begin
				For A := X - 1 To X + 1 Do
					For B := Y - 1 To Y + 1 Do
						If
							(Field[X, Y] And 15 = 0) And
							(Field[A, B] And 16 = 0) And
							(A >=     0) And
							(B >=     0) And
							(A <  XSize) And
							(B <  YSize) Then
							LeftClick(A, B)
			End
			Else
				Lose;
			Changed := True
		End
	End;















Procedure
	RightClick(X, Y : Byte);

	Begin
		Case (Field[X, Y] And 48) ShR 4 Of
			0 : If MinesLeft > 0 Then
			Begin
				Field[X, Y] := ((Field[X, Y]) And 207) Or 16;
				Dec(MinesLeft)
			End;
			1 : Begin
				Field[X, Y] := ((Field[X, Y]) And 207) Or 32;
				Inc(MinesLeft)
			End;
			2 : Field[X, Y] :=  (Field[X, Y]) And 207
		End;
		Changed := True
	End;



























Procedure
	BothClick(X, Y : Byte);

	Var
		A ,
		B : ShortInt;
		C :     Byte;

	Begin
		If Field[X, Y] And 48 = 48 Then
		Begin
			C := 0;
			For A := X - 1 To X + 1 Do   {Zaehlt die als Mine markierten Nachbarn}
				For B := Y - 1 To Y + 1 Do
					If
						(A >=     0) And
						(B >=     0) And
						(A <  XSize) And
						(B <  YSize) And
						(Field[A, B] And 48 = 16) Then
						Inc(C);
			If C = Field[X, Y] And 15 Then {Wenn gleich der Minennachbarn, dann}
			For A := X - 1 To X + 1 Do     {Alle Nachbarn anklicken}
				For B := Y - 1 To Y + 1 Do
					If
						(A >=     0) And
						(B >=     0) And
						(A <  XSize) And
						(B <  YSize) And
						(Not Solved) Then
						LeftClick(A, B)
		End
	End;












Procedure
	NewHighs;

	Var
		C : Byte;

	Begin
		For C := 1 To 10 Do
		Begin
			New(Highs[C]);
			With Highs[C]^ Do
			Begin
				Name  := ' (niemand)                            ';
				Time  :=  999;
				XSize :=   20;
				YSize :=   20;
				Day   :=    1; 
				Month :=    1;
				Year  := 2002;
				Mines := C * (XSize * YSize) Div 40
			End
		End
	End;

Procedure
	LoadHighs;

	Var
		F : File Of THigh;
		C : Byte;

	Begin
		NewHighs;
		Assign(F, 'HISCORES.MIN');
		ReSet(F);
		If IOResult = 0 Then
			For C := 1 To 10 Do
				Read(F, Highs[C]^)
	End;






Procedure
	DropHighs;

	Var
		C : Byte;

	Begin
		For C := 1 To 10 Do
			Dispose(Highs[C])
	End;

Procedure
	SaveHighs;

	Var
		F : File Of THigh;
		C : Byte;

	Begin
		Assign(F, 'HISCORES.MIN');
		ReWrite(F);
		For C := 1 To 10 Do
			Write(F, Highs[C]^);
		DropHighs;
	End;




















Procedure
	ShowHighscores;

	Var
		C : Byte;

	Begin
		Game := False;
		SetMode(3);
		TextColor(ForeColor);
		WriteLn('Highscores');
		WriteLn('==========');
		WriteLn;
		Write('Ŀ');
		Write(' Grad  Name des Spielers                Zeit  Groesse  Minen       Datum ');
		Write('͵');
		For C := 10 DownTo 1 Do
		Begin
			Write('   ');              TextColor(KeyColor);
			Write(C:2);                 TextColor(ForeColor);
			Write('  ');               TextColor(KeyColor);
			Write(Highs[C]^.Name);      TextColor(ForeColor);
			Write('   ');              TextColor(KeyColor);
			Write(Highs[C]^.Time:3);    TextColor(ForeColor);
			Write('    ');             TextColor(KeyColor);
			Write(Highs[C]^.XSize:2);   TextColor(ForeColor);
			Write('x');                 TextColor(KeyColor);
			Write(Highs[C]^.YSize:2);   TextColor(ForeColor);
			Write('    ');             TextColor(KeyColor);
			Write(Highs[C]^.Mines:3);   TextColor(ForeColor);
			Write('  ');               TextColor(KeyColor);
			Write(Highs[C]^.Day:2);     TextColor(ForeColor);
			Write('.');                 TextColor(KeyColor);
			Write(Highs[C]^.Month:2);   TextColor(ForeColor);
			Write('.');                 TextColor(KeyColor);
			Write(Highs[C]^.Year:2);    TextColor(ForeColor);
			Write(' ');
		End;
		Write('');
		WriteLn
	End;




Procedure
	Highscores;

	Begin
		ShowHighScores;
		WriteLn;
		Write('Bitte druecken Sie ');
		TextColor(KeyColor);
		Write('L');
		TextColor(ForeColor);
		WriteLn(', um die Highscoreliste zu loeschen');
		Write('oder eine beliebige andere ');
		TextColor(KeyColor);
		Write('Taste');
		TextColor(ForeColor);
		WriteLn(', um fortzufahren!');
		Repeat
		Until MausButton = 0;
		Repeat
		Until Key Or (Mausbutton <> 0);
		If Key And (GetKey = 'l') Then
		Begin
			DropHighs;
			NewHighs
		End
	End;



















Procedure
	CheckForHigh;

	Var
		C    ,
		Grad :       Byte;
		Name : String[31];
		Day  ,
		Month,
		Year ,
		DOW  :       Word;


































	Begin
		ShowHighScores;
		Grad := Trunc((Mines - 1) * 40 / (XSize * YSize)) + 1;
		If
			(Highs[Grad]^.Time / Grad )>
			((CurTime - StartTime) / Grad) Then
		Begin
			Write('Sie haben einen ');
			TextColor(KeyColor);
			Write('Highscore');
			TextColor(ForeColor);
			WriteLn(' erreicht!');
			WriteLn('Bitte geben Sie Ihren Namen ein:');
			WriteLn;
			Write('==> ');
			TextColor(InpColor);
			ReadLn(Name);
			TextColor(ForeColor);
			GetDate(Year, Month, Day, DOW);
			For C := 1 To 31 Do
				If Length(Name) >= C Then
					Highs[Grad]^.Name[C] := Name[C]
				Else
					Highs[Grad]^.Name[C]:= ' ';
			Highs[Grad]^.Time  := CurTime - StartTime;
			Highs[Grad]^.XSize :=               XSize;
			Highs[Grad]^.YSize :=               YSize;
			Highs[Grad]^.Mines :=               Mines;
			Highs[Grad]^.Day   :=                 Day;
			Highs[Grad]^.Month :=               Month;
			Highs[Grad]^.Year  :=                Year;
			ShowHighScores;
			WriteLn('Herzlichen Glueckwunsch, ', Name, '!')
		End
		Else
			WriteLn('Sie haben leider keinen Highscore erreicht.');
		WriteLn;








		Write('Mit ');
		TextColor(KeyColor);
		Write(Mines);
		TextColor(ForeColor);
		Write(' Minen bei einer Feldgroesse von ');
		TextColor(KeyColor);
		Write(XSize);
		TextColor(ForeColor);
		Write('x');
		TextColor(KeyColor);
		Write(YSize);
		TextColor(ForeColor);
		WriteLn(' Feldern lag Ihr');
		Write('Schwierigkeitsgrad bei ');
		TextColor(KeyColor);
		Write(Grad);
		TextColor(ForeColor);
		Write('. Sie benoetigten ');
		TextColor(KeyColor);
		Write(CurTime - StartTime);
		TextColor(ForeColor);
		WriteLn(' Sekunden.');
		WriteLn;
		Write('Bitte druecken Sie ');
		TextColor(KeyColor);
		Write('L');
		TextColor(ForeColor);
		WriteLn(', um die Highscoreliste zu loeschen');
		Write('oder eine beliebige andere ');
		TextColor(KeyColor);
		Write('Taste');
		TextColor(ForeColor);
		Write(', um fortzufahren!');
		Repeat
		Until MausButton = 0;
		Repeat
		Until Key Or (MausButton <> 0);
		If Key And (GetKey = 'l') Then
		Begin
			DropHighs;
			NewHighs
		End
	End;


Procedure
	Run;

	Var
		Abort : Boolean;
		M     ,
		N     :    Word;
		X     ,
		Y     :    Byte;

	Begin
		Init;
		Abort := False;
		Repeat
			Changed := False;
			If Not Solved Then
			Begin
				If GetTime <> CurTime Then
				Begin
					CurTime := GetTime;
					DrawTime
				End;
				If Opened = XSize * YSize - Mines Then
					Win;
				If MausButton > 0 Then
					If MausInWindow(XO, YO, XO + XSize * 8, YO + YSize * 8) Then
					Begin
						M := MausButton;
						X := (MausXPos - XO) Div 8;
						Y := (MausYPos - YO) Div 8;
						Repeat
							N := MausButton;
							If (N <> 0) And (M <> LeftButton + RightButton) Then
								M := N
						Until N = 0;
						If
							(X = (MausXPos - XO) Div 8) And
							(Y = (MausYPos - YO) Div 8) Then
							Case M Of
								LeftButton :
									LeftClick((MausXPos - XO) Div 8, (MausYPos - YO) Div 8);
								RightButton :
									RightClick((MausXPos - XO) Div 8, (MausYPos - YO) Div 8);
								RightButton + LeftButton :
									BothClick((MausXPos - XO) Div 8, (MausYPos - YO) Div 8)
							End
					End
			End
			Else
			Begin
				Abort := True;
				Repeat
				Until Key Or (MausButton > 0);
				If Key Then
					GetKey
			End;
			If Changed Then
				DrawField
		Until Key Or Abort;
		If Status = Found Then
			CheckForHigh;
		If Status = RedMine Then
			HighScores
	End;


























Procedure
	MausError;

	Begin
		SetMode(3);
		WriteLn('Dieses Programm benoetigt einen Maustreiber.');
		Halt(1)
	End;

Const
	Play = 0;
	High = 1;
	Para = 2;
	Ende = 3;
	Cont = 4;






























Function
	Menu : Byte;

	Var
		Ch : Char;

	Begin
		SetMode(3);
		TextColor(ForeColor);
		WriteLn('Minesweeper');
		WriteLn('===========');
		WriteLn;
		Write  (' (');
		TextColor(KeyColor);
		Write('1');
		TextColor(ForeColor);
		Write  (') Neues Spiel');
		If Not Game Then
		Begin
			Write(' (oder eine beliebige ');
			TextColor(KeyColor);
			Write('Maustaste');
			TextColor(ForeColor);
			Write(')')
		End;
		WriteLn;
		WriteLn;
		Write  (' (');
		TextColor(KeyColor);
		Write('2');
		TextColor(ForeColor);
		WriteLn(') Highscores');
		WriteLn;
		Write  (' (');
		TextColor(KeyColor);
		Write('3');
		TextColor(ForeColor);
		WriteLn(') Parameter');
		WriteLn;
		Write  (' (');
		TextColor(KeyColor);
		Write('4');
		TextColor(ForeColor);
		WriteLn(') Ende');
		WriteLn;
		If Game Then
		Begin
			Write  (' (');
			TextColor(KeyColor);
			Write('5');
			TextColor(ForeColor);
			Write(') Spiel fortsetzen (oder eine beliebige ');
			TextColor(KeyColor);
			Write('Maustaste');
			TextColor(ForeColor);
			WriteLn(')')
		End;

		Repeat
			If Game Then
				Ch := '5'
			Else
				Ch := '1';
			Repeat
			Until Key Or (MausButton <> 0);
			If Key Then
				Ch := ReadKey
		Until
			((Ch >= '1') And
			(Ch <= '4')) Or
			((Ch = '5') And
			(Game));
		Repeat
		Until MausButton = 0;
		Menu := Byte(Ch) - 49
	End;














Procedure
	Parameters;

	Var
		Where : Byte;

	Procedure
		Print;

		Begin
			TextColor(InpColor);
			GotoXY(18, 7);
			Write(Mines:3);
			GotoXY(18, 8);
			Write(XSize:3);
			GotoXY(18, 9);
			Write(YSize:3);
			TextColor(ForeColor);
			GotoXY(30, 7);
			Write(Trunc(0.25 * XSize * YSize):3);
			TextColor(ForeColor)
		End;























	Procedure
		Input;

		Var
			Ch : Char;

		Function
			Inp : Byte;

			Var
				Buf : Integer;

			Begin
				TextColor(InpColor);
				GotoXY(WhereX + 1, WhereY);
				Buf := 0;
				Repeat
					If (Ch >= '0') And (Ch <= '9') Then
					Begin
						Buf := 10 * Buf + Byte(Ch) - 48;
						If Buf > 255 Then
							Buf := Buf Div 10;
						GotoXY(WhereX - 3, WhereY);
						Write(Buf:3)
					End;
					Ch := GetKey
				Until (Ch = #13) Or (Ch = #27);
				If Ch = #27 Then
					Inp := 0
				Else
					Inp := Buf;
				TextColor(ForeColor)
			End;












		Var
			Buf : Byte;

		Begin
			Repeat
				GotoXY(20, Where + 7);
				Ch := GetKey;
				Case Ch Of
					#72 : If Where > 0 Then
						Dec(Where);
					#80 : If Where < 2 Then
						Inc(Where);
					Else
						If (Ch >= '0') And (Ch <= '9') Then
						Begin
							Buf := Inp;
							Case Where Of
								0 : If (Buf >= 10) And (Buf / (XSize * YSize) <= 0.25) Then
									Mines := Buf;
								1 : If (Buf >= 10) And (Buf <= 38) Then
									Begin
										XSize := Buf;
										If Mines / (XSize * YSize) > 0.25 Then
											Mines := Trunc(0.25 * XSize * YSize)
									End;
								2 : If (Buf >= 10) And (Buf <= 21) Then
									Begin
										YSize := Buf;
										If Mines / (XSize * YSize) > 0.25 Then
											Mines := Trunc(0.25 * XSize * YSize)
									End
							End;
							Ch := #0;
							Print
						End
				End
			Until Ch = #27
		End;







	Begin
		Game := False;
		SetMode(3);
		TextColor(ForeColor);
		WriteLn('Parameter');
		WriteLn('=========');
		WriteLn;
		WriteLn('Ŀ');
		WriteLn('     Wert  Aktuell  Min  Max ');
		WriteLn('͵');
		WriteLn(' Minen               10      ');
		WriteLn(' Felder X            10   38 ');
		WriteLn(' Felder Y            10   21 ');
		WriteLn('');
		Write  ('Benutzen Sie die ');
		TextColor(KeyColor);
		Write('Pfeiltasten');
		TextColor(ForeColor);
		WriteLn(', um zwischen den Feldern zu wechseln!');
		Write  ('Geben Sie eine Zahl mittels der ');
		TextColor(KeyColor);
		Write('Ziffern');
		TextColor(ForeColor);
		WriteLn(' ein!');
		Write  ('Schliessen Sie die Eingabe mit <');
		TextColor(KeyColor);
		Write('ENTER');
		TextColor(ForeColor);
		WriteLn('> ab!');
		Write  ('Zurueck zum Menue mit <');
		TextColor(KeyColor);
		Write('ESC');
		TextColor(ForeColor);
		WriteLn('>.');
		Print;
		Where := 0;
		Input
	End;







Var
	Choice : Byte;

Begin
	SetMode(3);
	TextBackground(0);
	LoadHighs;
	Game := False;
	If MausOk Then
		Repeat
			Choice := Menu;
			Case Choice Of
				Play : Begin
					NewGame;
					Run
				End;
				High : HighScores;
				Para : Parameters;
				Cont :        Run
			End
		Until Choice = Ende
	Else
		MausError;
	Shut;
	SaveHighs
End.



















