
		; mangalica (256-byte executable graphics for the Sinclair ZX Spectrum)
		; (c) 2025, Milos Bazelides a.k.a. baze/3SC

		; This program showcases a very short Z80 implementation of asymmetric
		; numeral system, specifically the rANS variant, simplified to 8 symbols
		; and an 8-bit symbol frequency table.

		; Special thanks to Petr "Poke" Petyovsky for introducing me to this family
		; of entropy coders and demonstrating their feasibility on the ZX Spectrum.
		; Extra kudos to Jarek Duda, the inventor of this ingenious method.

SymbolTabs	equ	0FBh
		org	0FA00h

		; generate lookup tables for the decoder

		di
		ld	l,a
		ld	sp,Symbols

GenSymbolTabs1	pop	bc			; B = symbol frequency, C = color
		ld	a,b
		ld	e,l
GenSymbolTabs2	ld	h,SymbolTabs
		ld	(hl),c			; store the symbol's value (color)
		inc	h
		ld	(hl),a			; store the symbol's frequency
		inc	h
		ld	(hl),e			; store the symbol's cumulative offset
		inc	l
		djnz	GenSymbolTabs2
		jr	nz,GenSymbolTabs1

		out	(254),a			; set border color

		; enter the decoding loop (SP already points to the rANS stream) and let the program hang :)

		ld	hl,22598		; initial rANS state
		ld	de,5800h		; destination pointer (attribute video RAM)

DecodeLoop	push	hl
		ld	h,SymbolTabs
		ld	a,(hl)
		ld	(de),a			; emit symbol (avoiding LDI to preserve H and B)
		inc	de
		inc	h
		ld	c,(hl)			; C = freq[symbol]
		inc	h
		ld	a,l
		sub	(hl)
		ld	h,b			; H = 0
		ld	l,a			; L = state % 256 - offset[symbol]
		pop	af			; A = state / 256
NaiveMul	add	hl,bc			; HL = (state / 256) * freq[symbol] + state % 256 - offset[symbol]
		dec	a
		jr	nz,NaiveMul
		or	h
		jr	nz,DecodeLoop
		dec	sp			; load a byte from the stream
		pop	af
		ld	h,l			; normalize the rANS state
		ld	l,a
		jr	DecodeLoop

		; 8 symbols, each represented as a pair of value (color) and normalized frequency

Symbols		db	000o, 15
		db	022o, 3
		db	133o, 8
		db	055o, 140
		db	177o, 62
		db	066o, 3
		db	077o, 20
		db	033o, 5

		INCBIN	"mangalica.rans"
