;------------------------------
;Leaf ain't a game
;
;code by Gordian
;csdb.dk/scener/?id=37254
;
;512b intro
;Lovebyte 2025
;
;441 bytes of code
;56 bytes of data
;2 bytes of header
;499 bytes total
;------------------------------


.TARGET_SIZE=512

Screen=$0400

PathScreenOffsetL=$61
PathScreenOffsetH=$62
PathPosX=$63
PathPosY=$64
PathAngle=$65
PathPrevAngle=$66

;Belows on stack
ScreenOffsetL=$69
ScreenOffsetH=$6a
PosX=$6b
PosY=$6c
Angle=$6d
PrevAngle=$6e

PrevChar=$6f
PrevColorFlag=$70
Length=$71
;-----

ColorFlag=$30
ColorLeftFlag=$31
ColorRightFlag=$32

Add=$39
CummulatedDeltaX=$3a
CummulatedDeltaY=$3b
CummulatedOffsetL=$3c
CummulatedOffsetH=$3d
TmpScreenOffsetL=$3e
TmpScreenOffsetH=$3f
TmpPathPrevAngle=$40

*=$080d ; SYS 2061

.CODE_START

   sei
   

   ldx #0
   stx $d020
   stx $d021  
   stx Angle
   dex

   stx $5a
 ;  stx $5b
   stx $58
  ; stx $59
   
   jsr $a3e8
   
   lda #$60
   sta $e777
   sta $e81f
   
   lda #$35
   sta $01




START_X=19
START_Y=24

   lda #<(Screen+START_Y*40+START_X)
   sta ScreenOffsetL
   lda #>(Screen+START_Y*40+START_X)
   sta ScreenOffsetH
   sta PrevAngle ;sta 7   
   
   lda #START_X
   sta PosX
   lda #START_Y
   sta PosY
   
   
MainLoop   
   ldx #0
   stx ColorLeftFlag
   stx ColorRightFlag
   stx Add
   inx
   stx ColorFlag   
  
   lda $d012
   and #3
   adc #1
   sta Length
  
   jsr Tree
   
;PathScreenOffsetL->ScreenOffsetL
;PathScreenOffsetH->ScreenOffsetH
;PathPosX->PosX
;PathPosY->PosY
;PathAngle->Angle
;PathPrevAngle->PrevAngle

   jsr $bc0f

   bvc MainLoop
   

Tree   
   lda Length
   bne +
   rts
+   

;Push on stack
;
;ScreenOffsetL
;ScreenOffsetH
;PosX
;PosY
;Angle
;PrevAngle
;PrevChar
;PrevColorFlag
;Length

   ldx #0
-
   lda $69,x
   pha
   inx
   cpx #10
   bne -
   
;Line routine
   lda Angle
   ;and #2
   sax $02

   lda PrevAngle
   sta TmpPathPrevAngle
   asl
   asl
   adc $02
   tax
   
   ldy Add
   beq +  
   ldy NextChars+1,x
+
   lda PrevChar
   cmp #$64
   bne +
   lda PrevAngle
   cmp #6
   bne +
   ldy #40
   lda Angle
   cmp #7
   bne +
   ldy #0
+

   lda NextChars,x
   sta PrevChar

   ldx Angle
   stx PrevAngle
   lda Offsets,x
   sta $02

   ldx Length
   inx

   tya

   jmp +++
   
LengthLoop  

   txa
   pha
   
   lda ScreenOffsetL
   clc
   adc CummulatedOffsetL
   sta TmpScreenOffsetL
   lda ScreenOffsetH
   adc CummulatedOffsetH
   sta TmpScreenOffsetH
   
   ldy #0
   lda PrevChar
   sta (TmpScreenOffsetL),y

   lax TmpScreenOffsetH
   sbx #256-($d8 - >Screen)
   stx TmpScreenOffsetH
   
   lda ColorFlag
   bne +
   lda #5
   sta (TmpScreenOffsetL),y
   jmp NotOnPath
+
   ;lda #5
   sta (TmpScreenOffsetL),y

   lda TmpPathPrevAngle
   sta PathPrevAngle


;ScreenOffsetL->PathScreenOffsetL
;ScreenOffsetH->PathScreenOffsetH
;PosX->PathPosY
;PosY->PathPosY
;Angle->PathAngle

   jsr $bc00
   
   lda PosX
  ; clc
   adc CummulatedDeltaX
   cmp #19
   beq InTheMiddle
   bcc LeftScreenPart
   

   dec CummulatedDeltaX
   lda CummulatedOffsetL
   bne +
   dec CummulatedOffsetH   
+
   dec CummulatedOffsetL
   
   ldx #24
-   
   ldy #0
   jsr $e9f0
   jsr $ea24
   jsr $e762
   dex 
   bpl -
   
   jmp ++

LeftScreenPart

   inc CummulatedDeltaX
   inc CummulatedOffsetL
   bne +
   inc CummulatedOffsetH
+   
   ldx #24
--   
   jsr $e9f0
   jsr $ea24   
   ldy $d5 ; 39
   dey
   
   jsr $e80a

   dex
   bpl --
++
   
InTheMiddle

   lda PosY
  ; clc
   adc CummulatedDeltaY
   cmp #5
   bcs BelowTheYMin

   inc CummulatedDeltaY
   
   lax CummulatedOffsetL
   sbx #256-40
   stx CummulatedOffsetL
   bcc +
   inc CummulatedOffsetH
+   

   ldx #24
-   
   dex
   jsr $e9f0
   lda $d1
   sta $ac
   lda $d2
   sta $ad 
   inx
   jsr $e9f0

   jsr $e9cf
   dex
   bpl -
   
   ldy #39
   jsr $ea0a
   
BelowTheYMin  
NotOnPath
   ldx Angle
   lda PosX
   clc
   adc DeltasX,x
   sta PosX
   
   lda PosY
   clc
   adc DeltasY,x
   sta PosY      

   pla
   tax  
  
   lda $02
+++   
   pha
   clc
   adc ScreenOffsetL
   sta ScreenOffsetL
   pla
   and #$80
   beq +
   lda #$ff
+   
   adc ScreenOffsetH
   sta ScreenOffsetH
   
   dex
   beq +
   jmp LengthLoop
+
;end Line routine

   stx ColorLeftFlag
   
   inc Add
   dec Length
   
   lda ColorFlag
   sta PrevColorFlag 

   beq +++
   ldx PrevAngle
   cpx #5
   bcc + ;<5
   cpx #7
   beq ++ 
;5,6
   inc ColorLeftFlag
   lda #0
   bvc +++   
+
   cpx #2
   bcs +++ ;>=2
++   
;0,1,7
   lda $d012
   and #1
   sta ColorLeftFlag
   eor #1
+++
;2,3,4
   sta ColorRightFlag
   pha

   lda ColorLeftFlag
   sta ColorFlag

;tree(x2, y2, angle+1, length-1)
   lda #7
   ldx Angle
   inx
   sax Angle
      
   jsr Tree

   pla
   sta ColorFlag

;tree(x2, y2, angle-1, length-1)
   lax Angle
   sbx #2
   lda #7
   sax Angle
   
   jsr Tree


;Pull from stack
;
;Length
;PrevColorFlag
;PrevChar
;PrevAngle
;Angle
;PosY
;PosX
;ScreenOffsetH
;ScreenOffsetL

   ldx #9
-
   pla
   sta $69,x
   dex
   bpl -
   
   rts

.CODE_END   

.DATA_START   

DeltasX
!byte 0
!byte 1
!byte 1
!byte 1
!byte 0
!byte -1
!byte -1
!byte -1

DeltasY
!byte -1
!byte -1
!byte 0
!byte 1
!byte 1
!byte 1
!byte 0
!byte -1

Offsets
!byte -40
!byte -39
!byte 1
!byte 41
!byte 40
!byte 39
!byte -1
!byte -41

NextChars
!byte $4e,1,$4d,0
!byte $67,-1,$64,0
!byte $4e,0,$4d,40
!byte $67,-1,$64,-40
!byte $4e,0,$4d,1 
!byte $67,0,$64,-40 ;$63,0
!byte $4e,0,$4d,-40
!byte $67,0,$63,40

.DATA_END


!if(.TARGET_SIZE<=64){
.HEADER_SIZE=0
}else{
.HEADER_SIZE=2
}

!message "  ----- code section is ", (.CODE_END - .CODE_START), " bytes long"
!message "  ----- data section is ", (.DATA_END - .DATA_START), " bytes long"
!message "  ----- prg has ", (.DATA_END - .CODE_START + .HEADER_SIZE) , " bytes, with basic has ", (.DATA_END - .CODE_START + 12 + .HEADER_SIZE) , " bytes"
!message "  ----- w/o basic ", .TARGET_SIZE-(.DATA_END - .CODE_START + .HEADER_SIZE) , " bytes free, with basic ", .TARGET_SIZE-(.DATA_END - .CODE_START + 12 + .HEADER_SIZE) , " bytes free"   