org 100h

%define STEPS 22

REGS equ -18

base equ $

main:
    mov     dx, 0x3C8       ; set palette
    time equ $-3
    c_xydiv equ $-3
    db      0x49            ; time float and xydiv float overlapping with code
    mov     al, 0x13
    int     0x10
    out     dx, al
    inc     dx
.paletteloop:
    out     dx, al          ; simple grayscale palette
    out     dx, al
    out     dx, al
    inc     ax
    c_colormul equ $-4      ; color multiplier float overlapping with code
    jnz     .paletteloop
    c_zdiv equ $-3
    db      0x41            ; zdiv float overlapping with code
    les     bp, [bx]        ; set es to 0x9FFF
.mainloop:
    sub     dx, 0x688C      ; shift dx to center of screen
    pusha
    mov     cl, STEPS
    fldl2t
    fld     dword [time+si-base]
    fldz
.marchloop:
    fld    st2                             ; r px pz py
    mov     bl, 8
    .ldloop:
    fld     st3
    inc     bx
    jpe    .ldloop
.maploop:                               ; qx qz qy r px pz py
    fldlg2
    fmul    st1
    faddp   st2, st0                    ; q.z+=q.x*o
    fldlg2
    fmul    st2
    fsubp   st1, st0                    ; q.x-=q.z*o
    fld     st0                         ; qx qx qz qy r ...
    frndint
    fsubp   st1, st0                    ; qx-=round(qx) qz qy r ...
    fadd    st0                         ; qx+=qx qz qy r ...
    fld     st0
    fabs                                ; abs(qx) qx qz qy r ...
    fsubp   st4, st0                    ; qx qz qy r+=abs(qx) ...
    fxch    st2, st0
    fxch    st1, st0                    ; q.xyz = q.zxy
    dec     bx
    jnz     .maploop
    fcompp   ; pop twice
    fiadd   word [bx+REGS+9]
    fmul    st1
    fdiv    dword [c_xydiv+si-base]
    fsubp   st2
    fild    word [bx+REGS+10]
    fmul    st1
    fdiv    dword [c_xydiv+si-base]
    fsubp   st4
    fdiv    dword [c_zdiv+si-base]
    fsubp   st2
    loop    .marchloop
    fcompp   ; pop twice
    fabs
    fmul    dword [c_colormul+si-base]
    fistp   word [bx+REGS+14]
    popa
    stosb                               ; di = current pixel, write al to screen
    imul    di, 85                      ; traverse the pixels in slightly random order (tip from HellMood)
    mov     ax, 0xCCCD                  ; Rrrola trick!
    mul     di                          ; dh = y, dl = x
    sbb     word [time+si-base], -1
    jmp     .mainloop