#!/bin/bash

readonly OUTDIR="gfx"
readonly INDIR="images"
readonly BUILDTMP="obj"

cd "$(dirname "${0}")/.."
rm -f "${OUTDIR}"/greeting_*

export LANG=C

{
echo "; automatically generated"
echo "greetings_start:"
i=0
for gfx in "${INDIR}"/greeting_*; do
   base="${gfx##*/}"
   base="${base%.???}"
   file "${gfx}" > .tmp.info
   { while read format; do
   bin="${OUTDIR}/${base}"
   case "${format}" in
   *"32 x 32"*)
      echo "; single"
      tools/splitimg.c "${gfx}" "${bin}.bin"
      echo "${base}:"
      echo "offset_${base#greeting_} := ${i}"
      echo ".incbin \"${bin}.bin\""
      ;;
   *"32 x 64"*)
      echo "; down"
      tools/splitimg.c "${gfx}" "${bin}1.bin" "${bin}2.bin"
      echo "${base}1:"
      echo "offset_${base#greeting_}1 := ${i}"
      echo ".incbin \"${bin}1.bin\""
      echo "${base}2:"
      echo "offset_${base#greeting_}2 := $((i+=4))"
      echo ".incbin \"${bin}2.bin\""
      ;;
   *"64 x 32"*)
      echo "; across"
      tools/splitimg.c "${gfx}" "${bin}1.bin" "${bin}2.bin"
      echo "${base}1:"
      echo "offset_${base#greeting_}1 := ${i}"
      echo ".incbin \"${bin}1.bin\""
      echo "${base}2:"
      echo "offset_${base#greeting_}2 := $((i+=4))"
      echo ".incbin \"${bin}2.bin\""
      ;;
   esac
   : $((i+=4))
   echo
   done
   } <.tmp.info
   rm -f .tmp.info
done
} > "src/greetings_gfx.inc"
ls -l "${OUTDIR}/greeting"*
rm -f "${BUILDTMP}/greetings.o"
