
.include "fb32x32.inc"

.include "globals.inc"

.segment "GFXDATA"

.define     GRN   $2d
.define     SKN   $87
.define     BLU   $2e

lemming0:
   .byte $00,$00,$00,$00,$00,$00
   .byte $00,GRN,GRN,GRN,GRN,$00
   .byte $00,GRN,GRN,SKN,$00,$00
   .byte $00,$00,SKN,SKN,SKN,$00
   .byte $00,$00,SKN,BLU,$00,$00
   .byte $00,$00,SKN,BLU,$00,$00
   .byte $00,$00,SKN,BLU,$00,$00
   .byte $00,$00,BLU,BLU,$00,$00
   .byte $00,SKN,BLU,BLU,$00,$00
   .byte $00,$00,SKN,SKN,$00,$00

lemming1:
   .byte $00,$00,GRN,$00,GRN,$00
   .byte $00,GRN,GRN,GRN,$00,$00
   .byte $00,GRN,GRN,SKN,$00,$00
   .byte $00,$00,SKN,SKN,SKN,$00
   .byte $00,$00,SKN,BLU,$00,$00
   .byte $00,SKN,BLU,BLU,$00,$00
   .byte $00,SKN,BLU,BLU,$00,SKN
   .byte $00,$00,BLU,BLU,$00,SKN
   .byte $00,BLU,BLU,$00,SKN,$00
   .byte $00,SKN,SKN,$00,$00,$00

lemming2:
   .byte $00,$00,$00,$00,$00,$00
   .byte $00,GRN,$00,GRN,$00,$00
   .byte $00,GRN,GRN,GRN,$00,$00
   .byte $00,$00,GRN,SKN,$00,$00
   .byte $00,$00,SKN,SKN,SKN,$00
   .byte $00,SKN,SKN,BLU,$00,$00
   .byte $00,SKN,BLU,BLU,$00,$00
   .byte SKN,SKN,BLU,BLU,BLU,$00
   .byte $00,BLU,BLU,BLU,BLU,$00
   .byte SKN,SKN,$00,$00,SKN,SKN

lemming3:
   .byte $00,$00,$00,$00,$00,$00
   .byte $00,$00,GRN,GRN,$00,$00
   .byte $00,GRN,GRN,SKN,GRN,$00
   .byte $00,GRN,SKN,SKN,SKN,$00
   .byte $00,$00,SKN,BLU,$00,$00
   .byte $00,$00,SKN,BLU,$00,$00
   .byte $00,SKN,BLU,BLU,$00,$00
   .byte $00,$00,BLU,BLU,$00,$00
   .byte SKN,BLU,BLU,BLU,BLU,$00
   .byte SKN,$00,$00,SKN,SKN,$00

lemming4:
   .byte $00,$00,$00,$00,$00,$00
   .byte $00,GRN,GRN,GRN,GRN,$00
   .byte $00,GRN,GRN,SKN,$00,$00
   .byte $00,GRN,SKN,SKN,SKN,$00
   .byte $00,$00,SKN,BLU,$00,$00
   .byte $00,$00,BLU,SKN,$00,$00
   .byte $00,$00,SKN,BLU,$00,$00
   .byte $00,$00,BLU,BLU,$00,$00
   .byte $00,SKN,BLU,BLU,$00,$00
   .byte $00,$00,SKN,SKN,$00,$00

lemming5:
   .byte $00,$00,GRN,$00,GRN,$00
   .byte $00,GRN,GRN,GRN,$00,$00
   .byte $00,GRN,GRN,SKN,$00,$00
   .byte $00,$00,SKN,SKN,SKN,$00
   .byte $00,$00,SKN,BLU,$00,$00
   .byte $00,$00,BLU,SKN,$00,$00
   .byte $00,$00,BLU,SKN,$00,SKN
   .byte $00,$00,BLU,BLU,$00,SKN
   .byte $00,BLU,BLU,$00,SKN,$00
   .byte $00,SKN,SKN,$00,$00,$00

lemming6:
   .byte $00,$00,$00,$00,$00,$00
   .byte $00,GRN,$00,GRN,$00,$00
   .byte $00,GRN,GRN,GRN,$00,$00
   .byte $00,$00,GRN,SKN,$00,$00
   .byte $00,$00,SKN,SKN,SKN,$00
   .byte $00,$00,BLU,SKN,$00,$00
   .byte $00,$00,BLU,SKN,$00,$00
   .byte $00,$00,BLU,BLU,SKN,$00
   .byte $00,BLU,BLU,BLU,BLU,$00
   .byte SKN,SKN,$00,$00,SKN,SKN

lemming7:
   .byte $00,$00,$00,$00,$00,$00
   .byte $00,$00,GRN,GRN,$00,$00
   .byte $00,GRN,GRN,SKN,GRN,$00
   .byte $00,GRN,SKN,SKN,SKN,$00
   .byte $00,$00,SKN,BLU,$00,$00
   .byte $00,$00,SKN,BLU,$00,$00
   .byte $00,$00,BLU,SKN,$00,$00
   .byte $00,$00,BLU,BLU,$00,$00
   .byte SKN,BLU,BLU,BLU,BLU,$00
   .byte SKN,$00,$00,SKN,SKN,$00

lemmings_lo:
   .lobytes lemming0,lemming1,lemming2,lemming3,lemming4,lemming5,lemming6,lemming7
lemmings_hi:
   .hibytes lemming0,lemming1,lemming2,lemming3,lemming4,lemming5,lemming6,lemming7

.segment "CODE"
lemming:
   ; DMA a lemming walker (6x10 pixels, Veto palette)
   ; IN:
   ; A = frame (0-7, other bits ignored)
   ; X = x-pos
   ; Y = y-pos (untouched)

   pha                     ; let's save all registers
   phx                     ; let's save all registers
   stx   FB32X32_DEST_X
   sty   FB32X32_DEST_Y

   and   #$07
   tax
   lda   lemmings_lo,x
   sta   FB32X32_SRC+0
   lda   lemmings_hi,x
   sta   FB32X32_SRC+1

   lda   #$09
   sta   FB32X32_HEIGHT
   lda   #$05
   sta   FB32X32_WIDTH
   sta   FB32X32_STEP

   stz   FB32X32_TCOL
   lda   #$01
   stz   FB32X32_COPYN
   plx                     ; no registers were harmed or changed
   pla                     ; during the execution of this subroutine
   rts
