#version 450

layout(location = 0) in vec2 FragCoord;
layout(location = 0) out vec4 FragColor;

layout(set = 2, binding = 0) uniform sampler2D u_WelcomeTexture;
layout(set = 2, binding = 1) uniform sampler2D u_DesktopTexture0;
layout(set = 2, binding = 2) uniform sampler2D u_DesktopTexture1;
layout(set = 2, binding = 3) uniform sampler2D u_CursorTexture;

layout(set = 3, binding = 0) uniform PushConstants {
    float u_Time;
    vec2 u_Resolution;
};

#define WINDOWS_START 64
#define CURSOR_WAIT 40
#define CURSOR_LAND 130
#define WINDOWS_CLICK 156
#define DEMO_START 164
#define DEMO_END 1056

#include <noise.glsl>

void main() {
    vec2 uv = (FragCoord + 1.) / 2.;
    vec3 color = vec3(0.);

    if (u_Time < WINDOWS_START) {
        color = texture(u_WelcomeTexture, uv).rgb;
    } else {
        color = texture(u_DesktopTexture0, uv).rgb;

        if (u_Time > WINDOWS_CLICK) {
            color = texture(u_DesktopTexture1, uv).rgb;
        }

        float cursorTime = clamp((u_Time - WINDOWS_START - CURSOR_WAIT) / (CURSOR_LAND - WINDOWS_START - CURSOR_WAIT) + 0.1, 0., 1.);
        vec2 cursorStart = vec2(0.498, 0.496);
        vec2 cursorTarget = vec2(0.04, 0.44);

        cursorTime = smoothstep(0., 1., cursorTime * cursorTime);
        vec2 cursorPos = mix(cursorStart, cursorTarget, cursorTime);
        cursorPos += vec2(noise(cursorTime), noise(cursorTime + 123)) * 0.1 * cursorTime;
        vec4 cursor = texture(u_CursorTexture, (uv - cursorPos) * (u_Resolution / vec2(32.)));

        color = mix(color, cursor.rgb, cursor.a);
    }

    FragColor = vec4(color, 1.);
}
