#version 450 core

out vec4 FragColor;
in vec2 texcoord;
layout(std430, binding = 0) buffer AudioBuffer {
    float audioSamples[];
    
};
vec4 getColor(float val){
    return mix(vec4(0,1,0,1),vec4(1,0,0,1),val);

}
int h2(int x) {
    x = ((x >> 16) ^ x) * 459332132;
    x = ((x >> 16) ^ x) * 4593821;
    x = (x >> 16) ^ x;
    return x;
}
float hash( int x, int y){
    return h2(x^y)%2;
} 

uniform float aspect;
uniform float itime;
vec3 rotateByQuaternion(vec3 v, vec4 q) {
    vec3 u = q.xyz;
    float s = q.w;
    return 2.0 * dot(u, v) * u
         + (s*s - dot(u, u)) * v
         + 2.0 * s * cross(u, v);
}
float sdf(vec3 p,out vec3 color,out vec3 normal,bool apple){
    float x=(acos(dot(vec3(1,0,0),p))+1)/2;
    float y=(acos(dot(vec3(0,1,0),p))+1)/2;
    float angle=atan(y , x);
    float stage=sin( -itime*20. + 10.*(length(vec2(x,y))*10.+.2*angle) );

    color= (apple?vec3(0,1,0):vec4( mix( .1, .9, smoothstep ( -1.,1., stage/fwidth(stage) ) ) ).xyz);

    return length(p)-0.4;

}
float opSmoothUnion( float d1, float d2, float k )
{
    float h = clamp( 0.5 + 0.5*(d2-d1)/k, 0.0, 1.0 );
    return mix( d2, d1, h ) - k*h*(1.0-h);
}

float sampleSDF(vec3 p,out vec3 color,out vec3 normal){
    float d=20000.;
    vec3 col;
    vec3 offset = sin((floor(itime+1.))*10.+21.*20.)*0.1+vec3(cos(floor(itime+1.)*step(6,floor(itime+1.))+21.*0.2),sin(floor(itime+1.)*step(6,floor(itime+1.))+21.*0.2),0);
    offset=rotateByQuaternion(offset,vec4(0,sin(floor(itime+1.)),cos(floor(itime+1.)),1));
    d=sdf(p+offset,col,normal,true)+0.4*(clamp((1.-6.*fract(itime+1.)),0,1));
    color=col;
    for(int i=0; i<20; i++){

        vec3 offset = sin(itime*10.+i*20.)*0.1+vec3(cos(itime*step(6,itime)+i*0.2),sin(itime*step(6,itime)+i*0.2),0);
        offset=rotateByQuaternion(offset,vec4(0,sin(itime),cos(itime),1));
        float dist2=sdf(p+offset,col,normal,false);

        color=mix(color*vec3(1,1,0.08*i),col,step(dist2,d));
        d=opSmoothUnion(d,dist2,0.6);


    }

    return d;
}

float raymarch(vec3 start, vec3 dir,out vec3 color){
    float totaldist=0.;
    vec3 normal;
    for(int i=0; i<50; i++){
        float dist=sampleSDF(start+dir*totaldist,color,normal);
        if(dist<=0.05){
                float delta=0.001;
                float dx=(sampleSDF(start+dir*totaldist,color,normal)-sampleSDF(vec3(start.x+delta,start.yz)+dir*totaldist,color,normal))/delta;
                float dy=(sampleSDF(start+dir*totaldist,color,normal)-sampleSDF(vec3(start.x,start.y+delta,start.z)+dir*totaldist,color,normal))/delta;
                float dz=(sampleSDF(start+dir*totaldist,color,normal)-sampleSDF(vec3(start.x,start.y,start.z+delta)+dir*totaldist,color,normal))/delta;
                normal=normalize(-vec3(dx,dy,dz));
                vec3 viewDir=vec3(0,0,-1);
                vec3 lightDir=vec3(1,1,-1);
                vec3 halfway=normalize(lightDir + viewDir);
                float NdotH = dot(normal, halfway);
                
                float specular=pow(NdotH, 256.);
                color=0.02+specular+(dot(normal,normalize(lightDir)))*color;
            
            
        return dist;}
        totaldist+=dist;
        
    }

    return 2000.;
    
}

vec3 cameraPos=vec3(0,0,-6);
vec4 cameraRot=vec4(0,0,0,1);
float fov=1;
void main(){

    vec2 uv=(texcoord-vec2(0.5,0.5))/aspect;
    uv.y;

    
    vec3 dir=normalize(vec3(uv,fov));
    dir=rotateByQuaternion(dir,cameraRot);
    vec3 col;
    if(0.5>raymarch(cameraPos,dir,col)){
        FragColor = vec4(col,1);
        return;
    }
   
    FragColor =vec4(0,0,0,1);


}
