# Notes
- Declaring byte arrays for assets as  `static public final byte[] ... = {...}` instead of `static public final byte[] ... = new byte[] {...}`, can save or add bytes to final CAP. Not sure what causes either scenario.
- Moving asset declarations into a handful of big asset classes saves around 60K bytes in GFX CAP file (cumulative, i.e., not per declared asset). This is in comparison to having one class and file per asset.
- Saved ~9K from GFX CAP file by removing redundant width and height variables from asset frames >0.
- Using `javacard.framework.Util` makes memory copies a lot faster than would be done with an equivalent implementation in the applet. This requires more testing to come up with concrete numbers though.
- To the best of our knowledge, it's not possible to compile the audio files into the MSX applet. Java compiler either complains about `error: code too large`, when a single class becomes too large. When you split the class into multiple, the problem becomes `error:  Static Field Component exceeds maximum size (65535 bytes).`. What we opted to do here is just to form a large empty buffer in flash that we load the music into, after the applet is flashed (using a custom APDU). While not fully self-contained in a CAP file, we hope this is still not considered 'cheating' in any way as the playback is done legitimately in real-time from the card.
- It's not entirely clear, but the card does not like when 'standard' status words are repurposed, e.g., by OR'ing `SW2=0x00` with some custom data. It's better to use range: `0x9000-0x9FFF` (even then, the card will be picky about what is and isn't allowed).
