#!/bin/bash
set -eu;

readonly ROOT="$(realpath "$(dirname "$0")/..")";

pushd .;
cd "${ROOT}";
cd "./cardreal";

sudo rm -rf ./build || true;
sudo rm -rf ./dist || true;

for i in $(seq 0 4); do
    rm "./src/org/_1935711/gosia/A"${i}".java" || true;
    printf "package org._1935711.gosia;\\npublic final class A${i} {\\n" >> "./src/org/_1935711/gosia/A"${i}".java";
    cat ./asset/"${i}"/*.java >> "./src/org/_1935711/gosia/A"${i}".java";
    printf "}\\n" >> "./src/org/_1935711/gosia/A"${i}".java";
done;

sudo docker run -v .:/opt/main --tty --interactive --rm icc/jcc:1.3.0 gosia__gfx__cardreal;

stat ./dist/GosiaGfx.cap;

popd;
