#!/bin/bash
set -eu;
readonly ROOT="$(realpath "$(dirname "$0")")";

pushd .;
cd "${ROOT}";

# ================================================================
# 1. Export Aseprite files to Gifs.
# ================================================================
rm -r "./export" || true;
""${ROOT}"/src/hourglass.sh";
""${ROOT}"/src/hourglass__rod.sh";
""${ROOT}"/src/greenwave.sh";
""${ROOT}"/src/bluetunnel.sh";
""${ROOT}"/src/swirlydirly.sh";
""${ROOT}"/src/blindingsquares.sh";
# ""${ROOT}"/src/spiralfractal.sh";
""${ROOT}"/src/blueplanet.sh";
""${ROOT}"/src/cuteplanet.sh";
""${ROOT}"/src/lesscuteplanet.sh";
""${ROOT}"/src/xenium.sh";
""${ROOT}"/src/flags.sh";
""${ROOT}"/src/title.sh";
""${ROOT}"/src/dungeon.sh";
""${ROOT}"/src/farewell.sh";
""${ROOT}"/src/credits.sh";

# ================================================================
# 2. Export WAV files to PCM.
# ================================================================
""${ROOT}"/src/msx.sh";

# ================================================================
# 3. Convert Gifs to Java.
# ================================================================
rm -r "./out" || true;
for i in $(seq 0 6); do
    asconv__arg=()
    (( i != 0 )) && asconv__arg=(--java-static-skip-width "true" --java-static-skip-height "true");
    asconv --input ""${ROOT}"/export/greenwave__frame_"${i}".gif" --java-static-path ""${ROOT}"/out/GreenwaveFrame"${i}".java" --java-static-prefix "GREEN_WAVE__FRAME_"${i}"" gfx --offset-x 0 --offset-y 0 --width 9 --height 7 "${asconv__arg[@]}";
done;
for i in $(seq 0 4); do
    asconv__arg=()
    (( i != 0 )) && asconv__arg=(--java-static-skip-width "true" --java-static-skip-height "true");
    asconv --input ""${ROOT}"/export/bluetunnel__frame_"${i}".gif" --java-static-path ""${ROOT}"/out/BluetunnelFrame"${i}".java" --java-static-prefix "BLUE_TUNNEL__FRAME_"${i}"" gfx --offset-x 0 --offset-y 0 --width 36 --height 8 "${asconv__arg[@]}";
done;
for i in $(seq 0 3); do
    asconv --input ""${ROOT}"/export/swirlydirly__frame_"${i}".gif" --java-static-path ""${ROOT}"/out/SwirlydirlyFrame"${i}".java" --java-static-prefix "SWIRLY_DIRLY__FRAME_"${i}"" gfx --offset-x 0 --offset-y 0 --width 36 --height 14 --java-static-skip-width "true" --java-static-skip-height "true";
done;
for i in $(seq 0 3); do
    asconv__arg=()
    (( i != 0 )) && asconv__arg=(--java-static-skip-width "true" --java-static-skip-height "true");
    asconv --input ""${ROOT}"/export/blindingsquares__frame_"${i}".gif" --java-static-path ""${ROOT}"/out/BlindingsquaresFrame"${i}".java" --java-static-prefix "BLINDING_SQUARES__FRAME_"${i}"" gfx --offset-x 0 --offset-y 0 --width 7 --height 7 "${asconv__arg[@]}";
done;
# for i in $(seq 0 6); do
#     asconv__arg=()
#     (( i != 0 )) && asconv__arg=(--java-static-skip-width "true" --java-static-skip-height "true");
#     asconv --input ""${ROOT}"/export/spiralfractal__frame_"${i}".gif" --java-static-path ""${ROOT}"/out/SpiralfractalFrame"${i}".java" --java-static-prefix "SPIRAL_FRACTAL__FRAME_"${i}"" gfx --offset-x 0 --offset-y 0 --width 36 --height 14 "${asconv__arg[@]}";
# done;
asconv --input ""${ROOT}"/export/blueplanet.gif" --java-static-path ""${ROOT}"/out/Blueplanet.java" --java-static-prefix "BLUE_PLANET" gfx --offset-x 0 --offset-y 0 --width 20 --height 14;
asconv --input ""${ROOT}"/export/cuteplanet.gif" --java-static-path ""${ROOT}"/out/Cuteplanet.java" --java-static-prefix "CUTE_PLANET" gfx --offset-x 0 --offset-y 0 --width 20 --height 14;
asconv --input ""${ROOT}"/export/lesscuteplanet.gif" --java-static-path ""${ROOT}"/out/Lesscuteplanet.java" --java-static-prefix "LESS_CUTE_PLANET" gfx --offset-x 0 --offset-y 0 --width 20 --height 14;
asconv --input ""${ROOT}"/export/xenium.gif" --java-static-path ""${ROOT}"/out/Xenium.java" --java-static-prefix "XENIUM" gfx --offset-x 0 --offset-y 0 --width 60 --height 5;
asconv --input ""${ROOT}"/export/flags.gif" --java-static-path ""${ROOT}"/out/Flags.java" --java-static-prefix "FLAGS" gfx --offset-x 0 --offset-y 0 --width 10 --height 4;
asconv --input ""${ROOT}"/export/hourglass.gif" --java-static-path ""${ROOT}"/out/Hourglass.java" --java-static-prefix "HOURGLASS" gfx --offset-x 0 --offset-y 0 --width 36 --height 4;
asconv --input ""${ROOT}"/export/hourglass__rod.gif" --java-static-path ""${ROOT}"/out/HourglassRod.java" --java-static-prefix "HOURGLASS_ROD" gfx --offset-x 0 --offset-y 0 --width 4 --height 18;
for i in $(seq 0 3); do
    asconv__arg=()
    (( i != 0 )) && asconv__arg=(--java-static-skip-width "true" --java-static-skip-height "true");
    asconv --input ""${ROOT}"/export/hourglass__sand__frame_"${i}".gif" --java-static-path ""${ROOT}"/out/HourglassSandFrame"${i}".java" --java-static-prefix "HOURGLASS_SAND__FRAME_"${i}"" gfx --offset-x 0 --offset-y 0 --width 14 --height 36 "${asconv__arg[@]}";
done;
for i in $(seq 0 2); do
    asconv__arg=()
    (( i != 0 )) && asconv__arg=(--java-static-skip-width "true" --java-static-skip-height "true");
    asconv --input ""${ROOT}"/export/title__frame_"${i}".gif" --java-static-path ""${ROOT}"/out/TitleFrame"${i}".java" --java-static-prefix "TITLE__FRAME_"${i}"" gfx --offset-x 0 --offset-y 0 --width 36 --height 13 "${asconv__arg[@]}";
done;
for i in $(seq 0 23); do
    asconv__arg=()
    (( i != 0 )) && asconv__arg=(--java-static-skip-width "true" --java-static-skip-height "true");
    asconv --input ""${ROOT}"/export/dungeon__frame_"${i}".gif" --java-static-path ""${ROOT}"/out/DungeonFrame"${i}".java" --java-static-prefix "DUNGEON__FRAME_"${i}"" gfx --offset-x 0 --offset-y 0 --width 36 --height 11 "${asconv__arg[@]}";
done;
for i in $(seq 1 3); do
    asconv__arg=()
    (( i != 0 )) && asconv__arg=(--java-static-skip-width "true" --java-static-skip-height "true");
    asconv --input ""${ROOT}"/export/farewell__frame_"${i}".gif" --java-static-path ""${ROOT}"/out/FarewellFrame"${i}".java" --java-static-prefix "FAREWELL__FRAME_"${i}"" gfx --offset-x 0 --offset-y 0 --width 36 --height 14 "${asconv__arg[@]}";
done;
for i in $(seq 0 20); do
    asconv__arg=()
    (( i != 0 )) && asconv__arg=(--java-static-skip-width "true" --java-static-skip-height "true");
    asconv --input ""${ROOT}"/export/credits__frame_"${i}".gif" --java-static-path ""${ROOT}"/out/CreditsFrame"${i}".java" --java-static-prefix "CREDITS__FRAME_"${i}"" gfx --offset-x 0 --offset-y 0 --width 36 --height 14 "${asconv__arg[@]}";
done;

# ================================================================
# 4. Copy Gfx Java files to source code.
# ================================================================
readonly GFX__ASSET__OUTPUT="../gfx/cardreal/asset";
rm -r ""${GFX__ASSET__OUTPUT}"" || true;
mkdir -p ""${GFX__ASSET__OUTPUT}"";
mkdir -p ""${GFX__ASSET__OUTPUT}"/0";
mkdir -p ""${GFX__ASSET__OUTPUT}"/1";
mkdir -p ""${GFX__ASSET__OUTPUT}"/2";
mkdir -p ""${GFX__ASSET__OUTPUT}"/3";
mkdir -p ""${GFX__ASSET__OUTPUT}"/4";
for i in $(seq 0 6); do
    cp "./out/GreenwaveFrame"${i}".java" ""${GFX__ASSET__OUTPUT}"/0";
done;
for i in $(seq 0 4); do
    cp "./out/BluetunnelFrame"${i}".java" ""${GFX__ASSET__OUTPUT}"/0";
done;
for i in $(seq 0 3); do
    cp "./out/SwirlydirlyFrame"${i}".java" ""${GFX__ASSET__OUTPUT}"/0";
done;
for i in $(seq 0 3); do
    cp "./out/BlindingsquaresFrame"${i}".java" ""${GFX__ASSET__OUTPUT}"/0";
done;
# for i in $(seq 0 6); do
#     cp "./out/SpiralfractalFrame"${i}".java" ""${GFX__ASSET__OUTPUT}"/0";
# done;
cp "./out/Blueplanet.java" ""${GFX__ASSET__OUTPUT}"/0";
cp "./out/Cuteplanet.java" ""${GFX__ASSET__OUTPUT}"/0";
cp "./out/Lesscuteplanet.java" ""${GFX__ASSET__OUTPUT}"/0";
cp "./out/Xenium.java" ""${GFX__ASSET__OUTPUT}"/0";
cp "./out/Flags.java" ""${GFX__ASSET__OUTPUT}"/0";
cp "./out/Hourglass.java" ""${GFX__ASSET__OUTPUT}"/0";
cp "./out/HourglassRod.java" ""${GFX__ASSET__OUTPUT}"/0";
for i in $(seq 0 3); do
    cp "./out/HourglassSandFrame"${i}".java" ""${GFX__ASSET__OUTPUT}"/1";
done;
for i in $(seq 0 2); do
    cp "./out/TitleFrame"${i}".java" ""${GFX__ASSET__OUTPUT}"/1";
done;
for i in $(seq 0 8); do
    cp "./out/DungeonFrame"${i}".java" ""${GFX__ASSET__OUTPUT}"/1";
done;
for i in $(seq 9 12); do
    cp "./out/DungeonFrame"${i}".java" ""${GFX__ASSET__OUTPUT}"/1";
done;
for i in $(seq 13 23); do
    cp "./out/DungeonFrame"${i}".java" ""${GFX__ASSET__OUTPUT}"/2";
done;
for i in $(seq 1 3); do
    cp "./out/FarewellFrame"${i}".java" ""${GFX__ASSET__OUTPUT}"/3";
done;
for i in $(seq 0 20); do
    cp "./out/CreditsFrame"${i}".java" ""${GFX__ASSET__OUTPUT}"/4";
done;

popd;
