#version 440

layout(rgba8, binding = 4) uniform image2D img;
layout(rgba8, binding = 5) uniform image2D imgdst;
layout(local_size_x = 20, local_size_y = 20, local_size_z = 1) in;

// https://github.com/hughsk/glsl-hsv2rgb
// Used for changing the light colour, from: https://www.shadertoy.com/view/3tG3DD
vec3 hsv2rgb(vec3 c) {
  vec4 K = vec4(1.0, 2.0 / 3.0, 1.0 / 3.0, 3.0);
  vec3 p = abs(fract(c.xxx + K.xyz) * 6.0 - K.www);
  return c.z * mix(K.xxx, clamp(p - K.xxx, 0.0, 1.0), c.y);
}
float luminance(vec3 col) {
    return dot(col, vec3(0.299, 0.587, 0.114));
}
// Use pixel luminance for height
float texelHeight(vec4 rgba) {
    return luminance(rgba.rgb);
}
uniform int NX;
uniform int NY;
#define W NX
#define H NY

void main()
{
	int i, j;
	i = int(gl_GlobalInvocationID.x);
	j = int(gl_GlobalInvocationID.y);
	vec2 pos = vec2(i,j);
	//const int W = 800;			// ugly
	//const int H = 800;
	vec4 col = imageLoad(img, ivec2(gl_GlobalInvocationID.xy));
	vec2 c = vec2(W/2,H/2);
	float d = length(c-pos)/W;
	col = (1.0 - d) * col;// (1.0-0.4*d)*col;
	//col = (float(i)/W)*col;
	//vec4 col = color(1.51*a+1.062*b);//b*0.8+a*1.3);
	imageStore(imgdst,ivec2(gl_GlobalInvocationID.xy),col);
}

