#define EXEC
#if EXEC
    // PRG size - Stub size : 65 - 15 = 50 bytes
    BasicUpstart2(start)
#else
    *=  4096
#endif  

.label SCREEN = $400
.label SCREEN_ROW_A = SCREEN + 19 * 40
.label SCREEN_ROW_B = SCREEN + 20 * 40
.label SCREEN_COL = 16

start:
outputBow:      
    dex
    lda dataBow - $ff + 2 , x            // read the data backwards in order to be able to rol to exit loop
counter:                                 // later will use LSB of screen address as line counter
    sta SCREEN_ROW_A - $ff + 2 + SCREEN_COL + 8, x    
    rol
    bpl outputBow

lineA:
    lda #'-'
    ldx #18
charOut:
    sta SCREEN_ROW_B + SCREEN_COL, x
    dex
    bpl charOut

    txa             // $ff

    ldx #'+'
lineFinish:
    stx SCREEN_ROW_B + SCREEN_COL
    stx SCREEN_ROW_B + SCREEN_COL + 9
    stx SCREEN_ROW_B + SCREEN_COL + 18 
    jsr $e8ec       // scroll screen + saveA

    dec counter + 1 // finish on 0
    beq *           // done 
    
lineB:
    ldx #'!'
    asl             // shift $ff till carry cleared: 9 times 
    bcs lineFinish
    bcc lineA

dataBow:
    .byte 77, 15, 47 //  \O/