;;=======================================================================
;; Vintage Computing Christmas Challenge 2024 (VC3 2024) 
;; Amstrad CPC 6128 / Longshot (Logon System)
;; December 2024 
;; 41 bytes. 
;; Christmas strings in the box
;; run from basic : memory &2d00:mode 0:load "vcc2024.bin":call #2d2b
;; or type : run "STUB" with the same content
;; For 464 or 664 model, update _firm_disprom equ. 
;;=======================================================================
_firm_disprom_464  equ #6eb
_firm_disprom_664  equ #6ec
_firm_disprom_6128 equ #6fc

_firm_disprom	equ _firm_disprom_6128

size_code 	equ end_code-start_code
org_code	equ #7f00-5

		org org_code
start_code
					; on run (de=#2d2b, hl=#004x, a=0 bc=#20ff)
					; #2d2b >> 1st charset "-+"
exec_code 
		ld hl,#8000+200		; End of christmas_buffer+1 >> #8000+(20 bytes x 10 lines)
fill_10lines				; ========================
		ld bc,#14dc		; b=19+1 loop / c=200-1+21 (for lddr)
		ld a,h			; a=%10000000 (selector for 2nd char of charset) 8 bits+Carry
fill_oneline				; ------------------------
		dec l			; ptrbuf-- ZF=1 if l==0 
		rla			; rotate selector 9 bits 
		ld (hl),d		; "-" or " "
		jr nc,select_2ndchar	; CF=0 first char
		ld (hl),e		; "+" or "!" 
select_2ndchar
		djnz fill_oneline	; complete line
					; ------------------------
		ld de,#2021		; New current charset " !"
		ld (hl),d		; + 1 space
		jr nz,fill_10lines	; new line until hl=ptrbuf=#8000 (l=0 ZF=1)
					; ========================
		ld d,h			; d=msb ptrbuf
		dec hl			; 
		ld e,200-1		; Duplicate (9+1) lines to (1+9+1) lines
		ex de,hl
		lddr
		ld l,christmas_string	; h is ok. l on lsb string buffer
		rst #28			; Display string & go back to Basic
		dw _firm_disprom 	; 

christmas_string
		db #1f,10,#7f		; locate x=10 y=scroll down
		db #cd,"O",#cc,13,10	; gift bow "\","O","/" 
christmas_buffer			; Buffer to build	
end_code
