comment $
Vintage Computing Christmas Challenge 2024

see https://logiker.com/Vintage-Computing-Christmas-Challenge-2024

Target: print following image with minimal executable code as possible


        \O/
+--------+--------+
!        !        !
!        !        !
!        !        !
!        !        !
!        !        !
!        !        !
!        !        !
!        !        !
+--------+--------+
!        !        !
!        !        !
!        !        !
!        !        !
!        !        !
!        !        !
!        !        !
!        !        !
+--------+--------+

    $


.model tiny                     ; generate .com program
.code                           ; code segment
org 100h                        ; code starts at offset 100h	
main proc near                  ; main procedure
      mov   dx,0108h            ; new cursor position: row 1, column 8
      mov   ah,02h              ; function 'set cursor position'
      mov   bh,00h              ; page no. 0 
      int   10h                 ; go!
      mov   ax,0e5ch            ; function 'teletype output', character "\"
      int   10h                 ; go!
      mov   al,"O"              ; character 'O'
      int   10h                 ; go!
      mov   al,"/"              ; character /'
      int   10h                 ; go!
      call  frameline           ; print first full frame line
      call  ubox                ; print box ('U' shape) 2 times
ubox:
      mov   bx,"! "             ; set frame and fill chars
      mov   cx,8                ; 8 fill lines
uboxloop:
      call  full                ; print fill line
      loop  uboxloop            ; repeat
frameline:        
      mov   bx,"+-"             ; set frame and fill chars
full:
      mov   al,0dh              ; carriage return
      int   10h                 ; go!
      mov   al,0ah              ; line feed
      int   10h                 ; go!
      call  framechar           ; first frame character
      call  half                ; print half line 2 times
half:                          
      push  cx                  ; save cx register
      mov   cx,8                ; 8 fill characters
halfloop:
      mov   al,bl               ; fill character
      int   10h                 ; go!
      loop  halfloop            ; repeat
      pop   cx                  ; restore cx register
framechar:
      mov   al,bh               ; frame character 
      int   10h                 ; go!
      ret                       ; return to caller / OS
main endp 
end main

