; Logier's Annual 2024 Christmas Present coding compeition.
; Submission for the Sam Coupe 8 bit computer.
; -Dave / Bushy555.
;
; Execution assumptions:
; (First program to run immediately after emulator is ran)
;
;
;
; Binary Snapshot
; ================
; 000 bytes :  snapshot header. 
; 111 bytes :  binary code.
; 111 bytes :  total file size.
; 367 bytes :  Minimal asm source size.
;
;
; Assemble with PASMO.EXE Z80 assembler.
; PASMO --alocal file.asm file.bin
; Use Sam Coupe utill DSKMAN to place binary into a disk image to then load into an emulator or
;    then use other tools to create a physical disk to then load into a real Sam Coupe computer via floppy disk.
;    This is beyond the scope of this assembly listing.
;
;
;
; Execution/use/Instructions
; ===========================
;
;	Use Emulator: SIMCOUPE
;
;	At the windows command line:     simcoupe christmas_present.dsk
;    	Within the simcoupe emulator: 	 load "file.bin" CODE 32768
;


	org	$8000		; Program runs at $6000 in RAM.
		
	xor	a		; Sam Coupe - "JCLSBL" Clear screen
	call	$014E
	xor	a
	call	$015A		; Sam Coupe - JMODE
	ld	a, $fe
	call	$112		; Sam Coupe - JSETSTRM. Channel S for full screen.

		
	ld	hl, line1	; Display ribbon on screen
	call	printstring

	ld	e, 2		; do twice
loopa0:	ld	hl, line2	; Display first top line.
	call	printstring
	ld	b, 8		; display middle lines 8x - two loops.
loopa1:	ld	hl, line3
	call	printstring
	djnz	loopa1
	dec	e
	jr	nz, loopa0

	ld	hl, line2	; Display last bottom line
	call	printstring

hereb:	jr	hereb

printstring:
	ld	a, (hl)
	cp	0
	ret	z
	inc	hl
	rst	16		; print character in reg a
	jr	printstring


line1 db $d,'        \O/',0
line2 db $d,'+--------+--------+',0
line3 db $d,'!        !        !',0





;
;        \0/
;+--------+--------+
;!        !        !
;!        !        !
;!        !        !
;!        !        !
;!        !        !
;!        !        !
;!        !        !
;!        !        !
;+--------+--------+
;!        !        !
;!        !        !
;!        !        !
;!        !        !
;!        !        !
;!        !        !
;!        !        !
;!        !        !
;+--------+--------+
;



