; Logier's Annual 2024 Christmas Present coding compeition.
; Submission for the LAMDA 8300 / PC83 computer.
; -Dave / Bushy555.
;
;
; NOTE: The Lambda 8300 does not have the characters '!' or '\'  
; As such, characters were replaced. The top line "ribbon" is :   >O<
; The sides that should be '!' have been replaced with semi-colon ';' characters.
;
;
;
; Binary Snapshot
; ================
; 000 bytes :  snapshot header. Not included in the source.
; 127 bytes :  code
; 127 bytes :  total file size.
; 609 bytes :  source size.
;
; Assemble with PASMO.EXE Z80 assembler.
; PASMO --alocal file.asm file.bin
; trs80-tool.exe convert --start 0x6000 file.bin file.cmd
;
;
; Execution/use/Instructions
; ===========================
; Use the ZX emulator "EIGHTYONE"
; 0.Find/download/install/run EightyOne emulator
; 1.Configure for 'Lamda 8300' by:  
;     OPTIONS --> HARDWARE --> OTHERS --> LAMBDA 8300.
;     Select '32k RAM PACK.'
;
; 2.FILE --> LOAD MEMORY BLOCK --> (filename, ie 'CHRISTMAS_PRESENT.BIN')
;     Address : 17307.  Click <Load File>
;
; 3.At the prompt, type :     RAND USR 17307
;   Program will autorun / autoexecute.
;
;
;
; NOTES for Lambda 8300
; ======================
; Program execution at $439B /17307d.
; VIDEO RAM at 16509/407Dh 
; Assemble with PASMO z80 assembler.
; Normal Ascii is a bit different on the ZX80/81/Lamda8300/PC83
; space: 00
; \    : not exist
; !    : not exist
; >    : 18
; <    : 19
; +    : 21
; -    : 22
; /    : 24
; ;    : 25
; O    : 52
;

	ORG $439B

	ld	a, 0			; Generic CLS for Lambda 8300.
	ld	hl, $407D
	ld	de, $407E
	ld	(hl), a
	ld	bc, 32*16
	ldir

	ld	de, $4086		; truly truly bizarre!
	ld	a, 19			; This is needed here for the next line to display correctly.
	ld	(de), a			; Doesnt make any sense! 
					; Harware data line buffer issue?  Doesnt work without this one here!
	ld	hl, line1		; display modified ribbon.
	ld	de, $4086
	call	display

	ld	hl, line2		; display top line of box.
	ld	de, $409F
	call	display

	ld	b, 2
loopd:	push	bc
	ld	b, 14			; do video line wrap-around by
cr:	inc	de			; increasing DE by 14.
	djnz	cr
	ld	b, 8
loopa:	push	bc
	ld	hl, line3
	call	display
	ld	b, 14			; do video line wrap-around by
cr2:	inc	de			; increasing DE by 14.
	djnz	cr2
	pop	bc
	djnz	loopa
	ld	hl, line2
	call	display
	pop	bc
	djnz	loopd
here:	jr	here


display:ld	a, (hl)			; Display message, character-by-character until reads a zero byte.
	cp	255
	ret	z
	ld	(de), a
	inc	hl
	inc	de
	jr	display

	
line1: db 18,52,19,255 
line2: db 21,22,22,22,22,22,22,22,22,21,22,22,22,22,22,22,22,22,21,255
line3: db 25,00,00,00,00,00,00,00,00,25,00,00,00,00,00,00,00,00,25,255
