; Logier's Annual 2024 Christmas Present coding compeition.
; Submission for the Camputers Lynx computer.
; -Dave / Bushy555.
;
; Execution assumptions:
; Memory is initially blank from $8000 to $8078.
; (First program to run immediately after emulator is ran)
;
; Binary Tape file
; ================
;   18 bytes :  13 bytes for Lynx .TAP file snapshot header, 5 bytes in footer.
;   94 bytes :  code
;  112 bytes :  total file size.
;  huge      :  source size.
;
;
; Assembling
; ==============
; Use SJASMplus to assemble:
;	sjasmplus christmas_present.asm
;
; Instructions for use
; ======================
; Use the Lynx emulator called "JYNX"  .   
; Located here: http://github.com/jonathan-markland/Jynx/releases/
; Run JYNX
; File --> OPEN TAP FILE --> Select TAP file.
; Program will automatically execute.


;@@ LYNX TAP HEADER @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@

 device zxspectrum128
	org 	$6500-13		; Origin
tap_b:	db 	$22,"FILE  ",$22	;name		  	HEADER
	db 	"M"			;type		  	HEADER
	dw 	end-begin		;program length	  	HEADER
	dw 	begin			;load point		HEADER
	
;@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@

	org 	$6500

begin:	ld 	hl, l1			; Select line 1
	call 	PrintString		; Write line 1
	inc	hl			; Select line 2
	call 	PrintString		; Write line 2
	ld	e, 2			; Outter loop 2 times : 2 to 1
a1:	ld 	b, 8			; Inner loop 8 times  : 8 to 1
b1:	ld 	hl, l3
 	call 	PrintString		; Show String to screen
 	djnz 	b1			; inner loop - do 8 times.
 	ld 	hl, l2
	call 	PrintString		; Show String to screen
	dec	e			; outter loop ; do 2 times.
	jr	nz, a1
	ret 				; return to basic
	

PrintString:
	ld 	a,(hl)			; Print a zero-byte terminated string 
	and	a			; set flags if AND'd with itself, if A = 0
	ret 	z			; return if true
	rst 	8			; LYNX rom print char in Reg A.
	inc 	hl			; next char in message
	jr 	PrintString		; loop


l1:db $4,'        \O/',0
l2:db $d,'+--------+--------+',0
l3:db $d,'!        !        !',0


end

; TAPE FILE FOOTER for Lynx
;===========================

    LUA							;calc checksum
    local checksum
    checksum=0

    for i=sj.get_label("begin"),sj.get_label("end") do
    checksum=checksum+sj.get_byte( i )
    end
--	print("cs:",string.format("%08X",checksum))
	sj.insert_label("CSU", checksum%256)
    ENDLUA

checkd: db CSU,CSU ;checksum LSB two times		;rest tail
	dw begin					;execute point
	db begin/256					;high byte of execute point
tap_e:							;display /d,end-begin
	savebin "CHRISTMAS_PRESENT.TAP",tap_b,tap_e-tap_b

