precision highp float;

layout(location = 0) in vec3 a_Pos;
layout(location = 1) in vec3 a_Normal;
layout(location = 3) in vec2 a_TexCoord;

out vec3 v_ViewPos;
out vec3 v_Normal;
out vec2 v_TexCoord;

uniform mat4 u_Model;
uniform mat4 u_View;
uniform mat4 u_Projection;

void main() {
    vec4 view_pos = u_View * u_Model * vec4(a_Pos, 1.);
    v_ViewPos = view_pos.xyz / view_pos.w;
    v_Normal = a_Normal; // TODO rotate normal
    v_TexCoord = a_TexCoord;

    gl_Position = u_Projection * view_pos;
}
