function Manhattan(x1, y1, x2, y2) {
  let dx = abs(x2 - x1);
  let dy = abs(y2 - y1);
  return dx + dy;
}

function modManhattan(x1, y1, x2, y2) {
  let dx = abs(x2 - x1);
  let dy = abs(y2 - y1);
  return abs(dx - dy);
}

function Chebyshev(x1, y1, x2, y2) {
  let dx = abs(x2 - x1);
  let dy = abs(y2 - y1);
  return max(dx, dy);
}

function modChebyshev(x1, y1, x2, y2) {
  let dx = abs(x2 - x1);
  let dy = abs(y2 - y1);
  return min(dx, dy);
}

function decimal_to_radix(val, radix) {
  return val.toString(radix).toUpperCase();
}

class OBJ {
  constructor(i, j, x, y, scl) {
    this.i = i;
    this.j = j;
    this.x = x;
    this.y = y;
    this.scl = scl;
    this.ran = floor(random(16));
  }

  switcher(scene) {
    let fx;
    let fy;
    let cx;
    let cy;
    let wave;

    switch (scene) {
      case 0:
        fy = sin((t + 0.025 * this.i) * TWO_PI);
        cx = pg.width;
        cy = 0.5 * pg.height + map(fy, -1, 1, -0.25, 0.25, true) * max_distance;
        wave = Math.sign(
          cos(0.0045 * modChebyshev(cx, cy, 0, this.y) * TWO_PI)
        );
        break;

      case 1:
        fx = cos((t + 0.05 * this.i) * TWO_PI);
        fy = sin((t - 0.05 * this.j) * TWO_PI);
        cx = 0.5 * pg.width + map(fx, -1, 1, -0.5, 0.5, true) * max_distance;
        cy = 0.5 * pg.height + map(fy, -1, 1, -0.5, 0.5, true) * max_distance;
        wave = Math.sign(
          cos(
            (t -
              0.0025 * cx -
              0.0025 * cy +
              0.001 * Manhattan(pg.width / 2, pg.height / 2, this.y, cx + cy)) *
              TWO_PI
          )
        );
        break;

      case 2:
        fx = cos(
          (t +
            (3 * atan2(pg.width / 2 - this.x, pg.height / 2 - this.y)) /
              TWO_PI) *
            TWO_PI
        );
        fy = sin(
          (t + 0.005 * dist(pg.width / 2, pg.height / 2, this.x, this.y)) *
            TWO_PI
        );
        cx = 0.5 * pg.width + map(fx, -1, 1, -0.25, 0.25, true) * max_distance;
        cy = 0.5 * pg.height + map(fy, -1, 1, -0.25, 0.25, true) * max_distance;
        wave = Math.sign(
          cos(
            (0.25 -
              0.0025 * dist(pg.width / 2, pg.height / 2, cx + cy, cx - cy)) *
              TWO_PI
          )
        );
        break;

      case 3:
        fx = cos(
          (t -
            0.0025 * dist(pg.width / 2, pg.height / 2, this.x, this.y) +
            (2 * atan2(pg.width / 2 - this.x, pg.height / 2 - this.y)) /
              TWO_PI) *
            TWO_PI
        );
        fy = sin(
          (t -
            0.00025 * dist(pg.width / 2, pg.height / 2, this.x, this.y) -
            (2 * atan2(pg.width / 2 - this.x, pg.height / 2 - this.y)) /
              TWO_PI) *
            TWO_PI
        );
        cx = 0.5 * pg.width + map(fx, -1, 1, -0.25, 0.25, true) * max_distance;
        cy = 0.5 * pg.height + map(fy, -1, 1, -0.25, 0.25, true) * max_distance;
        wave = Math.sign(
          cos(0.005 * dist(pg.width / 2, pg.height / 2, cx, cy) * TWO_PI)
        );
        break;

      case 4:
        fx = cos(
          (t -
            0.0025 * Chebyshev(pg.width / 2, pg.height / 2, this.x, this.y)) *
            TWO_PI
        );
        fy = sin(
          (t -
            0.0025 *
              modManhattan(pg.width / 2, pg.height / 2, this.x, this.y)) *
            TWO_PI
        );
        cx = 0.5 * pg.width + map(fx, -1, 1, -0.25, 0.25, true) * max_distance;
        cy = 0.5 * pg.height + map(fy, -1, 1, -0.25, 0.25, true) * max_distance;
        wave = Math.sign(
          cos(
            (0.0 + 0.0025 * Chebyshev(pg.width / 2, pg.height / 2, cx, cy)) *
              TWO_PI
          )
        );
        break;


      case 5:
        fx = cos(
          (t + 0.001 * Manhattan(pg.width /2, pg.height/2, this.x, this.y)) *
            TWO_PI
        );
        fy = sin(
          (t -
            0.001 * modManhattan(pg.width / 2, pg.height/2, this.x, this.y)) *
            TWO_PI
        );
        cx = 0.5 * pg.width + map(fx, -1, 1, -0.5, 0.5, true) * max_distance;
        cy = 0.5 * pg.height + map(fy, -1, 1, -0.5, 0.5, true) * max_distance;
        wave = Math.sign(
          cos(
            (0.25 + 0.0075 * Manhattan(pg.width / 2, pg.height/2, cx, cy)) *
              TWO_PI
          )
        );
        break;

      case 6:
        fx = asin(
          cos(
            (t +
              0.001 * Chebyshev(pg.width / 2, pg.height / 2, this.x, this.y)) *
              TWO_PI
          )
        );
        fy = asin(
          sin(
            (t -
              0.001 *
                modChebyshev(pg.width / 2, pg.height / 2, this.x, this.y)) *
              TWO_PI
          )
        );
        cx =
          0.5 * pg.width +
          map(fx, -HALF_PI, HALF_PI, -0.5, 0.5, true) * max_distance;
        cy =
          0.5 * pg.height +
          map(fy, -HALF_PI, HALF_PI, -0.5, 0.5, true) * max_distance;
        wave = Math.sign(
          cos(
            (0.5 + 0.01 * Manhattan(0, pg.height, cx, cy)) *
              TWO_PI
          )
        );
        break;

      case 7:
        fx = asin(
          cos(
            (t -
              0.002 * Chebyshev(pg.width / 2, pg.height / 2, this.x, this.y)) *
              TWO_PI
          )
        );
        fy = asin(
          sin(
            (t -
              0.002 *
                modChebyshev(pg.width / 2, pg.height / 2, this.x, this.y)) *
              TWO_PI
          )
        );
        cx =
          0.5 * pg.width +
          map(fx, -HALF_PI, HALF_PI, -0.5, 0.5, true) * max_distance;
        cy =
          0.5 * pg.height +
          map(fy, -HALF_PI, HALF_PI, -0.5, 0.5, true) * max_distance;
        wave = Math.sign(
          cos(
            (0.25 + 0.01 * Chebyshev(pg.width / 2, pg.height / 2, cx, cy)) *
              TWO_PI
          )
        );
        break;

      case 8:
        cx = 0.5*pg.width + 0.2*max_distance*cos((t+0.0015*dist(0,1.75*pg.height,this.x,this.y))*TWO_PI) ;
     cy = 0.5*pg.height + 0.2*max_distance*sin((t+0.0015*modChebyshev(pg.width,1.75*pg.height,this.x,this.y))*TWO_PI) ;
     wave = Math.sign(cos((0.25+0.025*Chebyshev(pg.width/2,pg.height/2,cx,cy))*TWO_PI));
        break;

      case 9:
        fx = cos((t - 0.025 * this.i - 0.03 * this.j) * TWO_PI);
        fy = sin((t + 0.025 * this.i - 0.03 * this.j) * TWO_PI);
        cx = 0.5 * pg.width + map(fx, -1, 1, -0.25, 0.25, true) * max_distance;
        cy = 0.5 * pg.height + map(fy, -1, 1, -0.25, 0.25, true) * max_distance;
        wave = Math.sign(
          cos(
            (0.75 +
              0.005 *
                dist(pg.width / 2, pg.height / 2, cx - cy, cx % (cy + 1))) *
              TWO_PI
          )
        );
        break;

      case 10:
        cx =
          0.5 * pg.width +
          0.2 *
            max_distance *
            asin(
              cos(
                (t +
                  0.001 *
                    Chebyshev(
                      0.5 * pg.width,
                      0.4 * pg.height,
                      this.x,
                      this.y
                    )) *
                  TWO_PI
              )
            );
        cy =
          0.5 * pg.height +
          0.2 *
            max_distance *
            asin(
              sin(
                (t +
                  0.001 *
                    Chebyshev(
                      0.5 * pg.width,
                      0.6 * pg.height,
                      this.x,
                      this.y
                    )) *
                  TWO_PI
              )
            );
        wave = Math.sign(
          cos(
            (0 + 0.01 * Manhattan(pg.width / 2, pg.height / 2, cx, cy)) * TWO_PI
          )
        );
        break;


      case 11:
        fx = cos(
          (t -
            0.0015 * dist(pg.width / 2, pg.height / 2, this.x, this.y) -
            (3 * atan2(pg.width / 2 - this.x, pg.height / 2 - this.y)) /
              TWO_PI) *
            TWO_PI
        );
        fy = sin(
          (t -
            0.0015 * dist(pg.width / 2, pg.height / 2, this.x, this.y) +
            (3 * atan2(pg.width / 2 - this.x, pg.height / 2 - this.y)) /
              TWO_PI) *
            TWO_PI
        );
        cx = 0.5 * pg.width + map(fx, -1, 1, -0.25, 0.25, true) * max_distance;
        cy = 0.5 * pg.height + map(fy, -1, 1, -0.25, 0.25, true) * max_distance;
        wave = Math.sign(
          cos(
            (0.4 + 0.0075 * dist(pg.width / 2, pg.height / 2, cx, cy)) * TWO_PI
          )
        );
        break;

      case 12:
        fx = asin(
          cos(
            (t -
              0.0015 * dist(pg.width / 2, pg.height / 2, this.x, this.y) -
              (3 * atan2(pg.width / 2 - this.x, pg.height / 2 - this.y)) /
                TWO_PI) *
              TWO_PI
          )
        );
        fy = asin(
          sin(
            (t -
              0.0015 * dist(pg.width / 2, pg.height / 2, this.x, this.y) +
              (1 * atan2(pg.width / 2 - this.x, pg.height / 2 - this.y)) /
                TWO_PI) *
              TWO_PI
          )
        );
        cx =
          0.5 * pg.width +
          map(fx, -HALF_PI, HALF_PI, -0.25, 0.25, true) * max_distance;
        cy =
          0.5 * pg.height +
          map(fy, -HALF_PI, HALF_PI, -0.25, 0.25, true) * max_distance;
        wave = Math.sign(
          cos(
            (0.8 + 0.0075 * Manhattan(pg.width / 2, pg.height / 2, cx, cy)) *
              TWO_PI
          )
        );
        break;

      case 13:
        fx = asin(
          cos(
            (t -
              0.0006 * dist(pg.width / 2, pg.height / 2, this.x, this.y) +
              (3 * atan2(pg.width / 2 - this.x, pg.height / 2 - this.y)) /
                TWO_PI) *
              TWO_PI
          )
        );
        fy = asin(
          sin(
            (t +
              0.0006 * dist(pg.width / 2, pg.height / 2, this.x, this.y) +
              (3 * atan2(pg.width / 2 - this.x, pg.height / 2 - this.y)) /
                TWO_PI) *
              TWO_PI
          )
        );

        cx = 0.5 * pg.width + map(fx, -1, 1, -0.25, 0.25, true) * max_distance;
        cy = 0.5 * pg.height + map(fy, -1, 1, -0.25, 0.25, true) * max_distance;
        wave = Math.sign(
          cos(
            (0.4 + 0.0075 * Chebyshev(pg.width / 2, pg.height / 2, cx, cy)) *
              TWO_PI
          )
        );
        break;

      case 14:
        fx = asin(
          cos(
            0.001 *
              Manhattan(pg.width / 2, pg.height / 2, this.x, this.y) *
              TWO_PI
          )
        );
        fy = asin(
          sin(
            (t -
              0.001 * Chebyshev(pg.width / 2, pg.height / 2, this.x, this.y)) *
              TWO_PI
          )
        );
        cx =
          0.5 * pg.width +
          map(fx, -HALF_PI, HALF_PI, -0.25, 0.25, true) * max_distance;
        cy =
          0.5 * pg.height +
          map(fy, -HALF_PI, HALF_PI, -0.25, 0.25, true) * max_distance;
        wave = Math.sign(
          cos(
            (0.0 - 0.015 * Manhattan(pg.width / 2, pg.height / 2, cx, cy)) *
              TWO_PI
          )
        );
        break;

      case 15:
        fx = asin(
          cos(
            (t -
              0.001 * Manhattan(pg.width / 2, pg.height / 2, this.x, this.y)) *
              TWO_PI
          )
        );
        fy = asin(
          sin(
            (t -
              0.001 * Chebyshev(pg.width / 2, pg.height / 2, this.x, this.y)) *
              TWO_PI
          )
        );
        cx =
          0.5 * pg.width +
          map(fx, -HALF_PI, 1, -0.25, 0.25, true) * max_distance;
        cy =
          0.5 * pg.height +
          map(fy, -HALF_PI, 1, -0.25, 0.25, true) * max_distance;
        wave = Math.sign(
          cos(
            (0.75 - 0.015 * modManhattan(pg.width / 2, pg.height / 2, cx, cy)) *
              TWO_PI
          )
        );
        break;

      case 16:
        fx = asin(
          cos(
            (t -
              0.00125 *
                modChebyshev(pg.width / 2, pg.height / 2, this.x, this.y)) *
              TWO_PI
          )
        );
        fy = asin(
          sin(
            (t -
              0.00125 *
                Chebyshev(pg.width / 2, pg.height / 2, this.x, this.y)) *
              TWO_PI
          )
        );
        cx =
          0.5 * pg.width +
          map(fx, -HALF_PI, 1, -0.25, 0.25, true) * max_distance;
        cy =
          0.5 * pg.height +
          map(fy, -HALF_PI, 1, -0.25, 0.25, true) * max_distance;
        wave = Math.sign(
          cos(
            0.0175 * modManhattan(pg.width / 2, pg.height / 2, cx, cy) * TWO_PI
          )
        );
        break;

      case 17:
        fx = asin(cos((t - 0.025 * this.i + 0.025 * this.j) * TWO_PI));
        fy = asin(sin((t + 0.025 * this.i + 0.025 * this.j) * TWO_PI));

        cx =
          0.5 * pg.width +
          map(fx, -HALF_PI, 1, -0.25, 0.25, true) * max_distance;
        cy =
          0.5 * pg.height +
          map(fy, -HALF_PI, 1, -0.25, 0.25, true) * max_distance;

        wave = Math.sign(
          cos(
            (0.3 + 0.01 * modManhattan(pg.width / 2, pg.height / 2, cx, cy)) *
              TWO_PI
          )
        );
        break;


      case 18:
        fx = cos(
          (t - 0.0025 * dist(pg.width / 2, pg.height / 2, this.x, this.y)) *
            TWO_PI
        );
        fy = sin(
          (t +
            (4 * atan2(pg.width / 2 - this.x, pg.height / 2 - this.y)) /
              TWO_PI) *
            TWO_PI
        );

        cx = 0.5 * pg.width + map(fx, -1, 1, -0.25, 0.25, true) * max_distance;
        cy = 0.5 * pg.height + map(fy, -1, 1, -0.25, 0.25, true) * max_distance;
        wave = Math.sign(
          cos(
            (0.25 + 0.01 * Chebyshev(pg.width / 2, pg.height / 2, cx, cy)) *
              TWO_PI
          )
        );
        break;

      case 19:
        fx = cos(
          (t -
            0.00175 * Manhattan(pg.width / 2, pg.height / 2, this.x, this.y)) *
            TWO_PI
        );
        fy = sin(
          (0.0 -
            0.0025 *
              modChebyshev(pg.width / 2, pg.height / 2, this.x, this.y)) *
            TWO_PI
        );
        cx = 0.5 * pg.width + map(fx, -1, 1, -0.25, 0.25, true) * max_distance;
        cy = 0.5 * pg.height + map(fy, -1, 1, -0.25, 0.25, true) * max_distance;

        wave = Math.sign(
          cos(
            (0.75 - 0.01 * modChebyshev(pg.width / 2, pg.height / 2, cx, cy)) *
              TWO_PI
          )
        );
        break;

      case 20:
        fx = asin(
      cos(
        (t - 0.0025 * modChebyshev(0, pg.height, this.x, this.y)) * TWO_PI
      )
    );
        fy = asin(
      sin(
        (t - 0.0025 * Chebyshev(0 , 0.9*pg.height,this.x, this.y)) * TWO_PI
      )
    );
        cx =
          pg.width +
          map(fx, -HALF_PI, HALF_PI, -0.25, 0.25, true) * max_distance;
        cy =
          pg.height +
          map(fy, -HALF_PI, HALF_PI, -0.25, 0.25, true) * max_distance;
        wave = Math.sign(
          cos(
            (0.275 + 0.01 * modManhattan(pg.width / 2, pg.height / 2, cx, cy)) *
              TWO_PI
          )
        );
        break;

      case 21:
        fx = asin(
          cos(
            (t +
              0.001 * Manhattan(pg.width / 2, pg.height / 2, this.x, this.y)) *
              TWO_PI
          )
        );
        fy = asin(
          sin(
            (t +
              0.0015 * Chebyshev(pg.width / 2, pg.height / 2, this.x, this.y)) *
              TWO_PI
          )
        );
        cx =
          0.5 * pg.width +
          map(fx, -HALF_PI, HALF_PI, -0.25, 0.25, true) * max_distance;
        cy =
          0.5 * pg.height +
          map(fy, -HALF_PI, HALF_PI, -0.25, 0.25, true) * max_distance;
        wave = Math.sign(
          cos(
            (0.2 + 0.0125 * Chebyshev(pg.width / 2, pg.height / 2, cx, cy)) *
              TWO_PI
          )
        );
        break;

      case 22:
        fx = asin(
          cos(
            (t -
              0.002 *
                modManhattan(pg.width / 2, pg.height / 2, this.x, this.y)) *
              TWO_PI
          )
        );
        fy = asin(
          sin(
            (t -
              0.002 * Manhattan(pg.width / 2, pg.height / 2, this.x, this.y)) *
              TWO_PI
          )
        );
        cx = 0.5 * pg.width + map(fx, -1, 1, -0.25, 0.25, true) * max_distance;
        cy = 0.5 * pg.height + map(fy, -1, 1, -0.25, 0.25, true) * max_distance;
        wave = Math.sign(
          cos(
            (0.1 + 0.005 * modChebyshev(pg.width / 2, pg.height / 2, cx, cy)) *
              TWO_PI
          )
        );
        break;

      case 23:
        fx = cos(
          (t -
            0.002 * Chebyshev(pg.width / 2, pg.height / 2, this.x, this.y) -
            (4 * atan2(pg.width / 2 - this.x, pg.height / 2 - this.y)) /
              TWO_PI) *
            TWO_PI
        );
        fy = sin(
          (t -
            0.002 * Chebyshev(pg.width / 2, pg.height / 2, this.x, this.y) +
            (4 * atan2(pg.width / 2 - this.x, pg.height / 2 - this.y)) /
              TWO_PI) *
            TWO_PI
        );
        cx = 0.5 * pg.width + map(fx, -1, 1, -0.2, 0.2, true) * max_distance;
        cy = 0.5 * pg.height + map(fy, -1, 1, -0.2, 0.2, true) * max_distance;
        wave = Math.sign(
          cos(
            (0.8 + 0.0075 * Chebyshev(pg.width / 2, pg.height / 2, cx, cy)) *
              TWO_PI
          )
        );
        break;

      case 24:
        fx = asin(
          cos(
            (t -
              0.001 * Manhattan(pg.width / 2, pg.height / 2, this.x, this.y)) *
              TWO_PI
          )
        );
        fy = asin(
          sin(
            (t -
              0.001 * Chebyshev(pg.width / 2, pg.height / 2, this.x, this.y)) *
              TWO_PI
          )
        );
        cx =
          0.5 * pg.width +
          map(fx, -HALF_PI, HALF_PI, -0.25, 0.25, true) * max_distance;
        cy = 0.5 * pg.height + map(fy, -1, 1, -0.25, 0.25, true) * max_distance;
        wave = Math.sign(
          cos(
            (0.75 +
              0.015 *
                Chebyshev(pg.width / 2, pg.height / 2, this.y, cx % (cy + 1))) *
              TWO_PI
          )
        );
        break;

      case 25:
        fx = cos(
          (t -
            0.002 * Chebyshev(pg.width / 2, pg.height / 2, this.x, this.y) +
            (2 * atan2(pg.width / 2 - this.x, pg.height / 2 - this.y)) /
              TWO_PI) *
            TWO_PI
        );
        fy = sin(
          (t -
            0.002 * Chebyshev(pg.width / 2, pg.height / 2, this.x, this.y) -
            (2 * atan2(pg.width / 2 - this.x, pg.height / 2 - this.y)) /
              TWO_PI) *
            TWO_PI
        );
        cx = 0.5 * pg.width + map(fx, -1, 1, -0.5, 0.5, true) * max_distance;
        cy = 0.5 * pg.height + map(fy, -1, 1, -0.5, 0.5, true) * max_distance;
        wave = Math.sign(
          cos(
            (0.5 + 0.005 * dist(pg.width / 2, pg.height / 2, cx, cy)) * TWO_PI
          )
        );
        break;

        case 26:
        fx = cos(
          (t -
            0.001 * dist(pg.width / 2, pg.height / 2, this.x, this.y) +
            (4 * atan2(pg.width / 2 - this.x, pg.height / 2 - this.y)) /
              TWO_PI) *
            TWO_PI
        );
        fy = sin(
          (t - 0.0025 * dist(pg.width / 2, pg.height / 2, this.x, this.y)) *
            TWO_PI
        );
        cx = 0.5 * pg.width + map(fx, -1, 1, -0.5, 0.5, true) * max_distance;
        cy = 0.5 * pg.height + map(fy, -1, 1, -0.5, 0.5, true) * max_distance;
        wave = Math.sign(
          cos(
            (0.3 + 0.0025 * modManhattan(pg.width / 2, pg.height / 2, cx, cy)) *
              TWO_PI
          )
        );
        break;

      case 27:
        fx = cos(
          (t + atan2(pg.width / 2 - this.x, pg.height / 2 - this.y) / TWO_PI) *
            TWO_PI
        );
        fy = sin(
          (t +
            0.002 * dist(pg.width / 2, pg.height / 2, this.x, this.y) +
            atan2(pg.width / 2 - this.x, pg.height / 2 - this.y) / TWO_PI) *
            TWO_PI
        );
        cx = 0.5 * pg.width + map(fx, -1, 1, -0.5, 0.5, true) * max_distance;
        cy = 0.5 * pg.height + map(fy, -1, 1, -0.5, 0.5, true) * max_distance;
        wave = Math.sign(
          cos(
            (0.25 + 0.005 * dist(pg.width / 2, pg.height / 2, cx, cy)) * TWO_PI
          )
        );
        break;

      case 28:
        fx = cos((0.25 - 0.0275 * this.i) * TWO_PI);
        fy = sin((0.0 + 0.0275 * this.j) * TWO_PI);
        cx = 0.5 * pg.width + map(fx, -1, 1, -0.5, 0.5, true) * max_distance;
        cy = 0.5 * pg.height + map(fy, -1, 1, -0.5, 0.5, true) * max_distance;
        wave = Math.sign(
          cos(
            (t - (2 * atan2(pg.width / 2 - cx, pg.height / 2 - cy)) / TWO_PI) *
              TWO_PI
          )
        );
        break;

      case 29:
        fx = cos(
          (t -
            0.0025 * Manhattan(pg.width / 2, pg.height / 2, this.x, this.y)) *
            TWO_PI
        );
        fy = sin(
          (t -
            0.0025 *
              modManhattan(pg.width / 2, pg.height / 2, this.x, this.y)) *
            TWO_PI
        );
        cx = 0.5 * pg.width + map(fx, -1, 1, -0.5, 0.5, true) * max_distance;
        cy = 0.5 * pg.height + map(fy, -1, 1, -0.5, 0.5, true) * max_distance;
        wave = Math.sign(cos((0.25 - 0.0025 * cx + 0.0025 * cy) * TWO_PI));
        break;

      case 30:
        fx = acos(
          cos(
            (t -
              0.0025 * Manhattan(pg.width / 2, pg.height / 2, this.x, this.y)) *
              TWO_PI
          )
        );
        fy = acos(
          sin(
            (t -
              0.0025 *
                modManhattan(pg.width / 2, pg.height / 2, this.x, this.y)) *
              TWO_PI
          )
        );
        cx =
          0.5 * pg.width +
          map(fx, -HALF_PI, HALF_PI, -0.5, 0.5, true) * max_distance;
        cy =
          0.5 * pg.height +
          map(fy, -HALF_PI, HALF_PI, -0.5, 0.5, true) * max_distance;
        wave = Math.sign(cos((0.5 - 0.005 * cx + 0.005 * cy) * TWO_PI));
        break;
    }

    this.scl_ = map(wave, -1, 1, 0.1, 1, true) * scl;
    this.m = map(wave, -1, 1, -1.5, 1.5, true) * scl;
  }

  update() {
    if (random(1) > 0.8) {
      this.ran = floor(random(16));
    }

    this.convert = decimal_to_radix(this.ran, 16);

    this.switcher(scene);
  }

  show() {
    pg.push();
    pg.fill("#000000");
    pg.rect(this.x, this.y - this.m, this.scl_, this.scl_);
    pg.pop();

    pg.push();
    pg.fill("#EDEDED");

    if (this.m > 0) {
      pg.textFont("Orbitron");
      pg.textSize(0.9 * this.scl_);
      pg.textAlign(CENTER, CENTER);
      pg.text(this.convert, this.x, this.y - this.m);
    } else {
      pg.rect(this.x, this.y - this.m, this.scl_, this.scl_);
    }
    pg.pop();
  }
}

function mouseClicked() {
  scene = (scene + 1) % totalscene;
}