require("lualibs.common")
require("skilanderkit")


boardname = "menu.map"

local initpos
-- gets called when board is loaded. gets a table as parameter which describes player position
function init(newinitpos, hotload)
	initpos = table_shallow_copy(newinitpos)
	loadsong("music/kenneth.kdm")
	setmusic(true)
	setvolume(0, musicvol)
	lastpress = true

	--load_altpal(1, "greyscale.raw")
	load_altpal(1, "grayhack")
	
end


curtime = 0

menuselect = 1
lastpress = false

menu_levelselector =
{
	{ text="TUTORIAL", gotomode = 5 },
	{ text="SKI'ERS LANDING", gotomode = 1 },
	{ text="SANDSTROEMMING", gotomode = 4 },
	{ text="MRR SLOPE", gotomode = 3 },
	{ text="NAG SCREEN", gotomode = 8 },
	{ text="NOTHING! GO BACK", newmenu = "main" }
}

menu_volumecustomizer =
{
	{ text="SILENCE",    func = function () musicvol =  0 sfxvol =  0 end },
	{ text="ONLY SFX",   func = function () musicvol =  0 sfxvol = 64 end },
	{ text="FULL",       func = function () musicvol = 64 sfxvol = 64 end },
	{ text="BALANCED",   func = function () musicvol = 64 sfxvol = 32 end },
	{ text="NATURAL",    func = function () musicvol = 64 sfxvol = 36 end },
	{ text="ONLY MUSIC", func = function () musicvol = 64 sfxvol =  0 end },

	{ text="WHAT THE!!? GO BACK", newmenu = "customizer" }
}

menu_musictest =
{
	{ text="KENNETH",   func = function () loadsong("music/kenneth.kdm") 	setmusic(true) end },
	{ text="SKYUNION",  func = function () loadsong("music/skyunion.kdm")   setmusic(true) end },
	{ text="FULLPIPE",  func = function () loadsong("music/fullpipe.kdm")   setmusic(true) end },
	{ text="DOWNFALL",  func = function () loadsong("music/downfall.kdm")   setmusic(true) end },
	{ text="SKILANDER", func = function () loadsong("music/skilander.kdm")  setmusic(true) end },
	{ text="CHARTS",    func = function () loadsong("music/charts.kdm")     setmusic(true) end },
	{ text="ENOUGH FIILISTELIZING! GO BACK", newmenu = "customizer" }
}

menu_customizer =
{
	{ text="VOLUME CUSTOMIZATION", newmenu = "volumecustomizer" },
	{ text="MUSIC TEST", newmenu = "musictest" },
	{ text="GO BACK", newmenu = "main" }
}

menu_main = {
	{ text="START", newmenu = "levelselector" },
	{ text="ADMIRE", gotomode = 6 },
	{ text="CUSTOMIZE", newmenu = "customizer" },
	{ text="MEMBERSHIP", gotomode = 7 },
	{ text="WATCH AGAIN", gotomode = 2 },
	{ text="QUIT", gotomode = 99 }
}

menuassortment = {
	main = menu_main,
	levelselector = menu_levelselector,
	volumecustomizer = menu_volumecustomizer,
	customizer = menu_customizer,
	musictest = menu_musictest
}

curmenu = menuassortment["main"]

print(dump(menu_main))
print(dump(menu_levelselector))

function runmenu(entry)
	if ( entry.func ) then
		entry.func()
	elseif ( entry.newmenu ) then
		curmenu = menuassortment[ entry.newmenu ]
		menuselect = 1
	elseif ( entry.gotomode and not gotomode ) then 
		gotomode = entry.gotomode
		wsay("GLORIOUS", 2900, 0.3, 0.3)
	end
end

function frame()

	curtime = curtime + 1

	dither = (curtime & 1) * 0.5 + 0.25

	local mypos = table_shallow_copy(initpos)
	mypos.z = mypos.z + math.sin(curtime * 0.01) * 100.0
	mypos.ang = mypos.ang + math.sin(curtime * 0.0053) * 20.0 + dither


	drawrooms(mypos.x, mypos.y, mypos.z, mypos.ang, 50, mypos.sect)
	drawmasks()



	drawtimer("HIIHTOLIITTO PRESENTS AT REVISION 2024", 40,15, 0.2, 0.0)
	drawtimer("A INTERACTIVE VIDEO GAME BY HACKERS MEDIA INDUSTRIES", 40,20, 0.2, 0.0)

	-- logo
	rotatesprite(166, 156, 0.3, 0,   301,   31,0, 3,    0,0,1,1);
	rotatesprite(160, 150, 0.3, 0,   301,   0,0, 2,    0,0,1,1);

	--drawtimer("THE SKILANDER", 40,40, 1.0, 0.0)




	local menutop = 50

	rotatesprite(110, menutop+30, 0.6, 0,   19,   31,0, 3,    0,0,1,1);


	drawtext("SELECT:", 40, menutop    , 0.4, 0.0, 16.0, 0)

	for i,v in ipairs(curmenu) do
		local cc = 0
		if ( i == menuselect ) then cc = 1 end
		drawtext(v.text,   40, menutop+10+i*8, 0.4, 0.0, 16.0, cc)
	end

	if (getkeystatus(0xc8)) then
		if not lastpress then

			local menuselectold = menuselect
			menuselect = math.max(1, menuselect - 1)
			menuyv = -3
			if (menuselect == menuselectold) then
				wsay("DOWN.WAV", 7936, 0.2, 0.2)
			else
				wsay("UP.WAV", 7936, 0.2, 0.2)
			end
		end
		lastpress = true
	elseif (getkeystatus(0xd0)) then
		if not lastpress then
			--menuselect = (menuselect + 1 + 3) % 3
			local menuselectold = menuselect
			menuselect = math.min( #curmenu, menuselect + 1)
			menuyv = 3
			if (menuselect == menuselectold) then
				wsay("DOWN.WAV", 7936, 0.2, 0.2)
			else
				wsay("UP.WAV", 7936, 0.2, 0.2)
			end
		end
		lastpress = true
	elseif (getkeystatus(0x1c)) then
		if not lastpress then
			print("trying.. to.... "..menuselect)

			wsay("SELECT.WAV", 7936, 0.2, 0.2)

			--print(dump(curmenu[menuselect]))
			runmenu(curmenu[menuselect])
			menuyv = 2

			--if (menuselect == 0) then
			--	gotomode = 1
			--elseif (menuselect == 1) then
			--elseif (menuselect == 2) then
			--	quit()
			--end
		end
		lastpress = true
	elseif (getkeystatus(1)) then
		if not lastpress then
			--quit()
			runmenu(curmenu[#curmenu])
			wsay("SELECT.WAV", 6936, 0.2, 0.2)
		end
		lastpress = true
	else
		lastpress = false
	end


	menuyt = menutop + 10 + menuselect*8

	if (menuy == nil) then
		menuy = menuyt
		menuyv = 0
	else
		menuyv = menuyv + (menuyt - menuy) * 0.94
	end
	menuy = menuy + menuyv
	menuyv = menuyv * 0.35

	--drawtimer("!:",   25+math.sin(curtime*0.09)*3+dither, menuy, 0.4, 0.0)

	rotatesprite(25+math.sin(curtime*0.09)*3+dither, menuy, 0.3, 0,   23,   2,0, 2,    0,0,1,1);

	drawtimer("THANKS TO KEN SILVERMAN, JONOF AND PETRI H.", 10,190, 0.3, 0.0)

	--rotatesprite(160, 100, 0.7, 0,   47,   2,0, 2,    0,0,1,1);
	--rotatesprite(160, 100, 0.7, 0,   79,   2,0, 2,    0,0,1,1);
	--rotatesprite(160, 100, 0.7, 0,   85,   2,0, 2,    0,0,1,1);


end
 
