; The "better then nothing" Second Reality tunnel
; A 256-byte intro by Blacky/Exact
; Works on DosBox 0.74-3, and FreeDOS (when the offscreen buffer works)
; Compile with "nasm.exe tunnel.asm -fbin -o tunnel.com"

; It started out as a Second Reality tunnel effect (see https://www.youtube.com/watch?v=ybdkp3lIFIs) but then it became something quite different

; uncomment for a swirling effect (but then it's more than 256 bytes)
;%define swirl

%define second_buffer 09000h ; normally 0b000h, but that gives all white on my DOS laptop - 09000h works, but crashes afterwards

org 100h
	db 40h ; inc ax, but in this case it is the last byte of 2.0 float (00 00 00 40)
	mov al,13h
	int 10h
	
redraw:
	push cs
	pop ds

	mov ax, bp
	and ax, 01111100b ; with having some zeros at the end we can hold out the white background for more frames
	cmp al, 01111100b
	jne skip_randomize
	
	lea si, wiggle_x
	mov ax, bp
	and ax, 0110000000b
	shr ax, 6
	add si, ax
	
	xor ax, ax
	in al, 40h
	and al, 01111111b
	add al,10 ; to avoid occasional division by zero later, and looks better too
	
	mov word[si], ax
	mov al, 0x0f
	jmp white
skip_randomize:
	xor ax, ax
white:	
	push second_buffer
	pop es
	dec cx
	rep stosb

	cmp al, 0x0f
	je copy_screen

	;mov cx, word[levels]	; levels = ls
	mov cl, 128
level:
	push cx

	mov bx, sp ; steal cx from the stack and push it on FPU
	fild word[bx]
	
	lea bx, levels
	fidiv word[bx] ; l/ls

	mov si, 100
	
	clc
initWiggle:
	inc bx
	inc bx ; bx: levels -> wiggle_x -> ampl_x -> wiggle_y -> ampl_y

	fild word[bx]	; wx l/ls
	mov word[si], bp
	fild word[si]	; t wx l/ls
	fdivrp st1, st0	; t/wx l/ls
	fadd st0, st1	; t/wx+l/ls l/ls
	fcos 			; cos(t/wx+l/ls) l/ls
	inc bx
	inc bx
	fild word[bx]	; ampl_x cos(t/wx+l/ls) l/ls
	fmulp st1, st0  ; ampl_x*cos(t/wx+l/ls) l/ls
	fxch st0, st1	; l/ls ampl_x*cos(t/wx+l/ls) 
	cmc
	jc initWiggle

; code removed due to loop above, but FPU stack comments are still relevant
;	fild word[bx]	; wy l/ls ampl_x*cos(t/wx+l/ls)
;	mov word[i], bp
;	fild word[i]	; t wy l/ls ampl_x*cos(t/wx+l/ls)
;	fdivrp st1, st0	; t/wy l/ls ampl_x*cos(t/wx+l/ls)
;	fadd st0, st1	; t/wy+l/ls l/ls ampl_x*cos(t/wx+l/ls)
;	fcos 			; cos(t/wy+l/ls) l/ls ampl_x*cos(t/wx+l/ls)
;	fild word[ampl_y]	; ampl_y cos(t/wy+l/ls) l/ls ampl_x*cos(t/wx+l/ls) l/ls
;	fmulp st1, st0  ; ampl_y*cos(t/wy+l/ls) l/ls ampl_x*cos(t/wx+l/ls)
;	fxch st0, st1	; l/ls ampl_y*cos(t/wy+l/ls) ampl_x*cos(t/wx+l/ls) 

	mov cl, 32	; points in the circle = pc
	;mov cx, word[points_in_circle]

circle:
	mov word[si], cx
	
	fild word[si]	; i l/ls ampl_y*cos(t/wy+l/ls) ampl_x*cos(t/wx+l/ls)

	; add this for swirling effect (plus 14 bytes code)
%ifdef swirl
	fld dword[_0_2]
	pop bx
	push bx
	mov word[si], bx
	fild word[si]
	fmulp st1,st0
	faddp st1,st0
%endif

	fild word[points_in_circle]	; pc i l/ls ampl_y*cos(t/wy+l/ls) ampl_x*cos(t/wx+l/ls)
	fdivp st1, st0	; i/pc l/ls ampl_y*cos(t/wy+l/ls) ampl_x*cos(t/wx+l/ls)

	fldpi			; pi i/pc l/ls ampl_y*cos(t/wy+l/ls) ampl_x*cos(t/wx+l/ls)
	fld dword[100h - 3] ; 2 pi i/pc l/ls ampl_y*cos(t/wy+l/ls) ampl_x*cos(t/wx+l/ls)
	fmulp st1, st0	; 2*pi i/pc l/ls ampl_y*cos(t/wy+l/ls) ampl_x*cos(t/wx+l/ls)
	fmulp st1,st0	; 2*pi*i/pc l/ls ampl_y*cos(t/wy+l/ls) ampl_x*cos(t/wx+l/ls)

	fsincos			; sin(2*pi*i/pc) cos(2*pi*i/pc) l/ls ampl_y*cos(t/wy+l/ls) ampl_x*cos(t/wx+l/ls)
	fild word[circle_size]	; cs sin(2*pi*i/pc) cos(2*pi*i/pc) l/ls ampl_y*cos(t/wy+l/ls) ampl_x*cos(t/wx+l/ls)
	fmul st2, st0	; cs sin(2*pi*i/pc) cs*cos(2*pi*i/pc) l/ls ampl_y*cos(t/wy+l/ls) ampl_x*cos(t/wx+l/ls)
	fmulp st1, st0	; cs*sin(2*pi*i/pc) cs*cos(2*pi*i/pc) l/ls ampl_y*cos(t/wy+l/ls) ampl_x*cos(t/wx+l/ls)
	fdiv st0, st2	; cs*sin(2*pi*i/pc)/(level/128) cs*cos(2*pi*i/pc) l/ls ampl_y*cos(t/wy+l/ls) ampl_x*cos(t/wx+l/ls)
	fadd st0, st3	; cs*sin(2*pi*i/pc)/(level/128)+cs*cos(t/wy+l/ls) cs*cos(2*pi*i/pc) l/ls ampl_y*cos(t/wy+l/ls) ampl_x*cos(t/wx+l/ls)
	fistp word[si]	; cs*cos(2*pi*i/pc) l/ls ampl_y*cos(t/wy+l/ls) ampl_x*cos(t/wx+l/ls)
	mov ax, word[si]

	fdiv st0, st1 	; cs*cos(2*pi*i/pc)/(l/ls) l/ls ampl_y*cos(t/wy+l/ls) ampl_x*cos(t/wx+l/ls)
	fadd st0, st3   ; cs*cos(2*pi*i/pc)/(l/ls)+ampl_x*cos(t/wx+l/ls) l/ls ampl_y*cos(t/wy+l/ls) ampl_x*cos(t/wx+l/ls)
	fistp word[si]	; l/ls cs*cos(t/wy+l/ls) ampl_x*cos(t/wx+l/ls)

	add ax, si ; if this is kept, the buffer pointed by SI cannot be at a random address anymore
	js dont_draw 
	
	cmp ax, 200
	jge dont_draw
	
	mov dx, 320
	mul dx
	mov bx, word[si]
	add bx, 160
	js dont_draw

	cmp bx, 320
	jge dont_draw
	
	add ax, bx
	mov di, ax
	
	mov al, 0x10
	pop bx ; take the value of level (outer cx) from the stack and put it in bx
	push bx
	
	add bx, bp
	and bl, 0x1f
	clc
	rcr bl, 1
	jc dont_draw
	add ax, bx

	stosb
dont_draw:
	loop circle

	fninit ; empty FPU stack
	
	pop cx
	;loop level
	dec cx
	jnz level

copy_screen:
	push second_buffer
	pop ds
	push 0a000h
	pop es

retrace:
    mov dx, 03dah
wait_retrace:
    in al, dx
    test al, 8
    jz wait_retrace

	xor si, si	
	xor di, di
	dec cx 
	rep movsb

	inc bp ; time

	in al,0x60 ; check keyboard
	dec al	
	jnz redraw

	;mov ax, 3h
	;int 10h

	ret

; approximate values would be sufficient here
levels dw 128 ; ls
wiggle_x dw 30 ; wx
ampl_x dw 50
wiggle_y dw 45 ; wy
ampl_y dw 30
points_in_circle dw 32 ; pc
circle_size dw 30 ; cs

%ifdef swirl
_0_2 dd 0.1
%endif