;;
;; 3D Plasmosis
;;
;; play with 500_000 cycles in dosbox
;;

org     100h

  
  mov  al, 13h              ; set screen mode
  int  10h
  les  bp, [bx]             ; pointer to vga memory in ES and
  mov  ds, bp               ; other memory segment for generating world data in DS

paintStart:

    mov ch, 0x80   ; remove this for twice as fast progress

; Plasmosis
nextPixel:
    ; avg previous value and current 16bit-pixel
    add ax, [di]
    rcr ax, 1
    add ax, [di-256]
    rcr ax, 1
    dec ax
    mov [di], ax

    cmpsw           ; just increment di by 2

    loop nextPixel

    push ax   ; not saving ax produces artifacts in the 3d data

  ; 3D Projection
frameloop:
    mov ax,0xCCCD
    mul di			; dl = x , dh=y
    sub dx, 140 + 114 * 256  ; center on screen

    push cx
    mov cl, 16
  loopDepth:
    ; calc y * depth / 256 --> bh
    mov al, dh
    imul cl
    inc ah
    shl ax, 3
    mov ch, ah

    ; calc x * depth / 256 --> ch
    mov al, dl
    imul cl
    inc ah
    shl ax, 3
    mov bl, ah

    ; depth in bl
    mov bh, cl
    add bh, 17    ; moving forward with time
  timer:

    ; read texture
    shl bl, 1
    mov ax, [bx]
    xchg bl, ch
    xchg bl, bh
    shl bl, 1
  code1:  ; cmp ax, [bx] == 3B07  //  cmp [bx], ax == 3907
    cmp ax, [bx] ; plasma[depth][x] < plasma[y][depth]?
    jge paint
    inc cx
    cmp cl, 46  ; max depth reached?
    jb loopDepth
    dec cx

  paint:
    cmp cl, 16
    ja noToggle
    xor byte [cs:code1], 0x3B ^ 0x39
  noToggle:
    ; map depth to grayscale
    mov al, 95 - 12 - 4 ;+ 64
    sub al, cl
    shr al, 1

    ;checker board
    xor bh, ch
    shr bh, 4
    and bh, 1
    sub al, bh

  realPaint:
    stosb
    cmpsw     ; dithering
    pop cx

    loop frameloop

    hlt       ; stabilize framerate
    inc byte [cs:timer-1]

    pop ax

    jmp paintStart
