-- plasmaballs
-- jtruk
-- For CoLD SToRAGE gig
-- at Mountain Bytes 24

SC,T=1,0
FFT_SCALE=1
M=math
S,C,PI,ATAN=M.sin,M.cos,M.pi,M.atan2
MIN,MAX,TAU,RAND=M.min,M.max,PI*2,M.random
CAMX,CAMY,CAMZ=0,0,3
FFT=0
BGSHIFT=0

setRGB=nil

function getfft(v)
	return CLAMP(fft(v),0,.2)
end

function CLAMP(v,min,max)
	return MAX(MIN(v,max),min)
end

function randomiseTable(t)
	local newT={}
	repeat
		local iPos=RAND(1,#t)
  table.insert(newT,t[iPos])
		table.remove(t,iPos)
	until(#t==0)
	return newT
end

function makeRGBfn()
	t=randomiseTable({"a","a+1","a+2"})

	local r=RAND()<.5 and "r" or "255-r"
	local g=RAND()<.5 and "g" or "255-g"
	local b=RAND()<.5 and "b" or "255-b"
	fn="local a=16320+i*3"
	fn=fn.."poke("..t[1]..","..r..")"
	fn=fn.."poke("..t[2]..","..g..")"
	fn=fn.."poke("..t[3]..","..b..")"

	setRGB=load("i,r,g,b=...;" .. fn)
end

function switchRGBfn()
	makeRGBfn()
 vbank(1)
 for c=1,15 do
  local cm=c/15
	 local r=180*cm
	 local g=220*cm
	 local b=255
	 setRGB(c,r,g,b)
	end

	makeRGBfn()
end

switchRGBfn()

function SCN(y)
 vbank(0)
 for c=1,15 do
  local csh=c*.1
	 local r=100+S(csh+y*.03)*80
	 local g=0
	 local b=60+S(2+csh+y*.02+BGSHIFT*.1)*60
	 setRGB(c,r,g,b)
	end
end

function TIC()
 poke(0x3FFB,0)
	if T%200==0 then
		switchRGBfn()
	end

 CAMX=0
 CAMZ=40
	local r=T*.06

 circs={}
	local x=S(T*.032)*25
	local y=S(T*.022)*10
	local z=C(T*.052)*10-1
	addBall(x,y,z,r,0)
	addBall(-x,-y,-z,r,20)

	vbank(1)
 cls()
	drawAllCircs()
	
	vbank(0)
	drawBG()

	BGSHIFT=BGSHIFT+getfft(6)*FFT_SCALE

 print("jtruk",200,125,15)
 
	T=T+1
end

function addBall(xc,yc,zc,r,cSeed)
	local scale=1+(getfft(4)*FFT_SCALE*4)
	local cr=30*scale
	local dr0=scale
	local dr1=12*scale
	local cp={
		x=xc,y=yc,z=zc
	}

	-- ball
 for i=1,8 do
		local cp2={x=cp.x,y=cp.y,z=cp.z+.01*i}
		local cr2=cr-i*3
		local c=16-i/2-RAND(0,1)
		addOneCirc(cp2,cr2,CLAMP(c,1,15))
	end
		
	-- arms
	for iArm=0,9 do
		local seed=(20+(12.9+iArm)^5+cSeed^3)%9876
	 local a=S(seed+T*.005)*TAU
 	for iRing=0,1,.01 do
			if true then
	   a=a+S(seed*.01+iRing*4+T*.1)*.01*iRing
	   local d=dr0+(dr1-dr0)*iRing
				local p={
				 x=S(a)*d,
					y=C(a)*d,
					z=0
				}
				local rx=seed--T*.03
				local ry=seed*3--T*.02
				local rz=seed*5--T*.02
				p=rotX(p,rx)
				p=rotY(p,ry)
				p=rotZ(p,rz)
				p=add(p,xc,yc,zc)
				local sz=1+(.5+iRing)*2
    local fuzz=seed+T*.05-iRing
				if S(fuzz)>0 then
					c=8+C(fuzz)*7
					addOneCirc(p,sz,c)
				end
			end
		end
	end
end

function addOneCirc(p,sz,c)
--	p=rotZ(p,T*.01)
	p=proj(p)
 table.insert(circs,{
  p=p,sz=sz,c=c
 })
end

function drawAllCircs()
 table.sort(circs,function(a,b)
  return a.p.z>b.p.z
 end)

 for _,c in ipairs(circs) do
  drawOneCirc(c.p,c.sz,c.c)
 end
end

function drawOneCirc(p,sz,c)
	local sz=MIN(100,1/p.z*sz)
	circ(p.x,p.y,sz,c)
end

function proj(p)
 local zF=(CAMZ-p.z)*.1
 return {
  x=120+10*(CAMX-p.x)/zF,
  y=68+10*(CAMY-p.y)/zF,
  z=zF,
 }
end

function rotX(p,a)
 return {
  x=p.x,
  y=p.y*C(a)-p.z*S(a),
  z=p.y*S(a)+p.z*C(a),
 }
end

function rotY(p,a)
 return {
  x=p.x*C(a)-p.z*S(a),
  y=p.y,
  z=p.x*S(a)+p.z*C(a),
 }
end

function rotZ(p,a)
 return {
  x=p.x*C(a)-p.y*S(a),
  y=p.x*S(a)+p.y*C(a),
  z=p.z,
 }
end

function add(p,x,y,z)
 return {
  x=p.x+x,
  y=p.y+y,
  z=p.z+z,
 }
end

function drawBG()
	local p=0
 for y=0,135 do
	 for x=0,239 do
		 local dx,dy=120-x,68-y
		 local d=(dx^2+dy^2)^.5
			local a=(PI+ATAN(dy,dx))/TAU
   local c=8+S(d*.1-T*.05-BGSHIFT*3)*7
		 poke4(p,c)
			p=p+1
  end
 end
end
