;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; Busy soft ;;; Mixontil 512 ;;; 02.02.2024 ;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

sizexx	=	0x7E			;; Number of tiles in X
sizeyy	=	0x48			;; Number of tiles in Y

	USE32				;; Compiled in Flat assembler 1.71.39 
	ORG	0x400000

base	db	'MZbsPE',0,0		;; Signatures ( bs=busy soft:) ) 

;; COFF header ;;

	dw	0x014C			;; MZ+08 PE+04 Target Machine (Intel 386)
	dw	0			;; MZ+0A PE+06 NumberOfSections  

;;	dd	-1			;; MZ+0C PE+08 TimeDateStamp		UNUSED
;;	dd	-1			;; MZ+10 PE+0C PointerToSymbolTable	UNUSED
;;	dd	-1			;; MZ+14 PE+10 NumberOfSymbols		UNUSED

kus1:	mov	eax,[ebx+0x0C]		;; Goto PEB_LDR_DATA ; EBX = PEB
	mov	eax,[eax+0x0C]		;; InLoadOrderModuleList
	mov	eax,[eax]		;; forward to next LIST_ENTRY
	mov	eax,[eax]		;; forward to next LIST_ENTRY
	jmp	ret1

	dw	8			;; MZ+18 PE+14 SizeOfOptionalHeader
	dw	0x0002			;; MZ+1A PE+16 Characteristics (2=executable)

;; Optional header ;;

	dw	0x010B			;; MZ+1C PE+18 Magic (PE 32bit EXE) 

;;	db	-1			;; MZ+1E PE+1A MajorLinkerVersion	UNUSED
;;	db	-1			;; MZ+1F PE+1B MinorLinkerVersion	UNUSED
;;	dd	-1			;; MZ+20 PE+1C SizeOfCode		UNUSED
;;	dd	-1			;; MZ+24 PE+20 SizeOfInitData		UNUSED
;;	dd	-1			;; MZ+28 PE+24 SizeOfUninitData		UNUSED
;;	dd	start - base		;; MZ+2C PE+28 AddressOfEntryPoint
;;	dd	-1			;; MZ+30 PE+2C BaseOfCode		UNUSED
;;	dd	-1			;; MZ+34 PE+30 BaseOfData		UNUSED  

kus2:	mov	eax,[ebx + 0x20]	;; EBX = name pointers table offset
	add	eax,ebp			;; EBX = name pointers table address
	mov	esi,[eax + ecx*4]	;; ESI = name pointer offset
	add	esi,ebp			;; ESI = name pointer address
	mov	eax,[ebx + 0x24]	;; EAX = ordinals table RVA offset

	db	0x3D			;; 0x3D = cmp eax,dword = skip address of entry point
	dd	start - base		;; MZ+2C PE+28 AddressOfEntryPoint

	add	eax,ebp			;; EAX = ordinals table RVA address
	movzx	edx,word [eax + ecx*2]	;; EDX = function ordinal
	jmp	sem2

;; Windows specific fields ;;

	dd	base			;; MZ+38 PE+34 ImageBase
	dd	4			;; MZ+3C PE+38 SectionAlignment => PE at offset MZ+04
	dd	4			;; MZ+40 PE+3C FileAlignment

;;	dw	-1			;; MZ+44 PE+40 MajorOperatingSystemVersion	UNUSED
;;	dw	-1			;; MZ+46 PE+42 MinorOperatingSystemVersion	UNUSED
;;	dw	-1			;; MZ+48 PE+44 MajorImageVersion		UNUSED
;;	dw	-1			;; MZ+4A PE+46 MinorImageVersion		UNUSED

sem3:	add	eax,[ebx + 0x1C]	;; EAX = address table RVA offset
	mov	edx,[eax + edx*4]	;; EDX = address of function RVA address
	jmp	ret2

	dw	4			;; MZ+4C PE+48 MajorSubsystemVersion

;;	dw	-1			;; MZ+4E PE+4A MinorSubsystemVersion		UNUSED
;;	dd	-1			;; MZ+50 PE+4C Win32VersionValue		UNUSED
;;	dd	bend - base		;; MZ+54 PE+50 SizeOfImage

start:	mov	edi,libzac-libdif	;; Entry point
	jmp	kus1			;; jmp argument = Low byte of image size in memory

	dw	((bend-base) shr 8) + 1	;; Next 3 bytes of image size in memory
	db	0

	dd	0x40			;; MZ+58 PE+54 SizeOfHeaders
;;	dd	-1			;; MZ+5C PE+58 CheckSum		UNUSED

sem2:	mov	eax,ebp			;; EAX = MZ header
	jmp	sem3

	dw	2			;; MZ+60 PE+5C Subsystem (Win32 GUI)
	dw	0			;; MZ+62 PE+5E DllCharacteristics  
;;	dd	0x04FFFF		;; MZ+64 PE+60 SizeOfStackReserve
;;	dd	0x04FFFF		;; MZ+68 PE+64 SizeOfStackCommit
;;	dd	0x04FFFF		;; MZ+6C PE+68 SizeOfHeapReserve
;;	dd	0x04FFFF		;; MZ+70 PE+6C SizeOfHeapCommit
;;	dd	-1			;; MZ+74 PE+70 LoaderFlags (must be 0)	UNUSED

;; Part of graphic effect code ;;

kus8:	push	0x08			;; MZ+64
	  add	  al,0			;; MZ+66  Each add al,0 = 04 00 = high word of stack/heap size
	pop	ecx
inilop:	push	eax
	  add	  al,0
	loop	inilop
	  add	  al,0
	push	edx
	push	eax
	  add	  al,0
	push	ebx
	push	eax
	jmp	ret8

	dd	0 			;; MZ+78 PE+74 NumberOfRvaAndSizes

;; End of all needed headers and continue resolving imports ;;

ret1:	mov	eax,[eax+0x18]		;; EAX = Kernel32 base memory

dlloop:	mov	ebp,eax			;; EAX = MZ header
	add	eax,[ebp + 0x3C]	;; EAX = PE header
	mov	ebx,[eax + 0x78]	;; EBX = exports directory table offset
	add	ebx,ebp			;; EBX = exports directory table address
	xor	ecx,ecx			;; ECX = 0. index of evaluated export

scnam:	jmp	kus2

ret2:	add	edx,ebp			; EDX = address of function abs address

	xor	eax,eax			; Make hash from function name
mkhash:	lodsb
	imul	eax,0xCBB01
	add	al,al
	jnz	mkhash
	shr	eax,0x16
	mov	dword [imports+eax*4],edx

	inc	ecx			; ECX = index of next function
	cmp	ecx,[ebx + 0x18]
	jnz	scnam

	add	edi,libdif		;; Move to next library name

	db	0xB8			;; B8 = mov eax,dword
	dd	0x00000000		;; MZ+B0 = zero = needed for WinXP  

	push	edi
	call	dword [LoadLibraryA]

	test	eax,eax
	jnz	dlloop

;; End of resolving imports and let's go to simple graphic effect ;;

;;;;;;;;;;
;; Init ;;
;;;;;;;;;;

efect:	mov	edx,0x91000000
	mov	ebx,wclass
;;	xor	eax,eax			;; EAX = 0 already from previous loop
	jmp	kus8

ret8:	push	eax			;; Parameter for ShowCursor
	call	dword [ShowCursor]	;; Do not show mouse cursor
	call	dword [CreateWindowExA]	;; Create application window

	mov	[hwnd],eax
	push	eax
	call	dword [GetDC]
	mov	[hdc],eax

	mov	ecx,4*sizexx*sizeyy
init:	lea	eax,[8*eax+eax+103]	;; Random number generator
	mov	ebx,eax
	shr	eax,12
	xor	eax,ebx
	mov	[colcnt - 4 + 4*ecx],eax
	loop	init

;;;;;;;;;;;;;;;
;; Main loop ;;
;;;;;;;;;;;;;;;

delay:	push	0x10
	call	dword [Sleep]

;; Render animation

	mov	ebx,vars		;; EBX = pointer to array of multiplicators for RGB values
	lea	esi,[ebx+8]		;; ESI = pointer to pointer and timing of scenario
	mov	eax,[esi]		;; EAX = pointer to actual item in scenario
	add	byte [esi+4],2
	jnc	scedat			;; Scenario item is changed every 128 frame
	inc	eax
scesto:	mov	[esi],eax
scedat:	mov	dl,[eax+scenar]		;; Get item from scenario
	mov	al,dl
	test	al,al			;; Zero means end of scenario
	jz	scesto			;; and the scenario repeats

	push	8
	pop	ecx

dirlop:	mov	al,[ebx]		;; Update multiplicators due to scenario item
	shr	dl,1			;;  - Decrement by 4 if the proper bit is 0
	jc	dirinc			;;  - Increment by 4 if the proper bit is 1
dirdec:	sub	al,4			;; with limits 0 and 255 (do not overflow)
	jc	dirnxt
	jmp	dirset
dirinc:	add	al,4
	jc	dirnxt

dirset:	mov	[ebx],al		;; Store new value of multiplicator
dirnxt:	inc	ebx
	loop	dirlop

	mov	bl,cl

kresli:	mov	ecx,4*sizexx*sizeyy	;; Main render loop
	mov	edi,screen-1
	xor	ebp,ebp

maluj:	lea	esi,[colcnt - 4 + 4*ecx]

	lea	ebp,[8*ebp+ebp+101]	;; Random number generator
	mov	eax,ebp
	ror	eax,23
	xor	eax,ebp
	and	eax,0x7F
	add	al,0x55			;; AL = random number in range 0x55..0xD4

	add	eax,[esi]		;; Increment iterator by this random number
	mov	[esi],eax

	shl	ax,3			;; Create value for R,G,B
	sbb	al,al
	xor	al,ah			;; colX = value oscilates 0..255..0..255..0

	and	bl,0x07			;; It it is 4th value (not user for R,G,B)
	cmovz	edx,eax			;; store it into DL as "col4" for future use

	mul	byte [ebx]		;; Evaluating result R,G,B values for screen
	mov	dh,ah
	inc	ebx
	mov	al,dl
	mul	byte [ebx]
	add	ah,dh
	inc	ebx			;; Result value = colX * mul0 + col4 * mul1

	mov	[edi+ecx],ah		;; Store result value into screen
	loop	maluj

;; Display prepared screen

zobraz:	xor	eax,eax		;; It is possible to use ECX instead of EAX and save 2 bytes

	push    0xCC0020	;; rop
	push	eax		;; iUsage = 0
	push	bminfo		;; lpbmi
	push	screen		;; lpbits
	push	sizeyy		;; SrcHeight
	push	sizexx		;; SrcWidth
	push	eax		;; ySrc = 0
	push	eax		;; xSrc = 0

	push	eax		;; DestHeight
	push	eax		;; DestWidth
	push	eax		;; yDest = 0
	push	eax		;; xDest = 0

	push	esp
	push	[hwnd]
	call	dword [GetClientRect]

	push	[hdc]
	call	dword [StretchDIBits]

;; Test ESC key

	push	0x1B
	call	dword [GetAsyncKeyState]
	test	al,al
	jz	delay

	retn

;;;;;;;;;;;;;;;;;;;
;; Constant data ;;
;;;;;;;;;;;;;;;;;;;

wclass	db	'Edit',0

libzac:
gdi32	db	'Gdi32',0  
user32	db	'User32',0
libdif	=	user32-gdi32

	;;	BBGGRRxxb	;; Color scenario
	;;	|||||||||
scenar	db	01000000b	;; Pure blue
	db	00000100b	;; Pure red
	db	00010000b	;; Pure green
	db	00010100b	;; Red-green-yellow
	db	01000100b	;; Blue-red-magenta
	db	01010000b	;; Blue-green-cyan
	db	01010100b	;; All RGB colors
	db	10001000b	;; Pure magenta
	db	00101000b	;; Pure yellow
	db	10100000b	;; Pure cyan
	db	10101000b	;; Pure white
	db	10011000b	;; Magenta-green-white
	db	10100100b	;; Cyan-red-white
	db	01101000b	;; Yellow-blue-white
	db	01010100b	;; All RGB colors

;;  BITMAPINFO

bminfo	dd	0x28	;; biSize
	dd	sizexx	;; biWidth
	dd	-sizeyy	;; biHeight
	dw	1	;; biPlanes
	dw	0x20	;; biBitCount
	dd	?	;; biCompression
	dd	?	;; biSizeImage
	dd	?	;; biXPelsPerMeter
	dd	?	;; biYPelsPerMeter
	dd	?	;; biClrUsed
	dd	?	;; biClrImportant

;; The "dw 0x20" is last data in 512b EXE file.
;; In fact, high byte is zero so it is enough to 511 bytes EXE file :)
;; (I know, I can move bminfo upper by 1 byte but I like align 4 for structures like this)

;;;;;;;;;;;;;;;;;;;
;; Variable data ;;
;;;;;;;;;;;;;;;;;;;

hwnd	dd	?	;; Window handle
hdc	dd	?	;; Device context

	ALIGN	0x100

	db	0x400 + base - $ dup ?
imports	db	0x1000 dup ?
vars	db	0x100 dup ?

screen	dd	sizexx * sizeyy	    DUP ?	;; Result bitmap to show on screen
colcnt	dd	sizexx * sizeyy * 4 DUP ?	;; Iterators for colours (4x for each pixel)
	db	0x100 dup ?
bend:

	ORG	0		;; Variables in "vars"
muls	db	8 dup ?		;; Multiplicators for RGB values
kdesce	dd	?		;; Pointer to actual item in scenario
count	db	?		;; Timing of scenario

;; Imports

Sleep		=	imports + 0x920
GetDC		=	imports + 0x4FC
ShowCursor	=	imports + 0xF0C
LoadLibraryA	=	imports + 0xEB4
GetClientRect	=	imports + 0x368
StretchDIBits	=	imports + 0xAB0
CreateWindowExA	=	imports + 0x76C
GetAsyncKeyState =	imports + 0xF44

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
