; code to install a vsync interrupt hanlder to do Simple Colour Cycling 
; by P_Malin / Bitshifters

; to be compiled with BeebAsm

IRQ1V = &204

interruptAccumulatorStorage = &FC
systemVIAInterruptFlagVSync = 1 << 1
systemVIAInterruptFlagRegister = &FE4D

videoULAPaletteRegister   = &FE21

; Palette values for ULA
PAL_black	= (0 EOR 7)
PAL_blue	= (4 EOR 7)
PAL_red		= (1 EOR 7)
PAL_magenta = (5 EOR 7)
PAL_green	= (2 EOR 7)
PAL_cyan	= (6 EOR 7)
PAL_yellow	= (3 EOR 7)
PAL_white	= (7 EOR 7)


; declare some variables in zero page (zero page addressing is smaller number of bytes)
ORG &70
.col    skip 1
.old_irqv   skip 2

GUARD &9F



ORG &1C05 ; a reasonable place to compile assembly code to
;ORG 7173 ; Location of code in REM statement in owlet
;ORG &1905 ; Location of code in REM statement on BBC Micro

.start ; start of data to save in binary output

.main_start

.main ; entry point

    ; install interrupt handler
    SEI ; disable interrupts
    ; store address of old interrupt hander in old_irqv
    LDA IRQ1V:STA old_irqv
    LDA IRQ1V+1:STA old_irqv+1

    ; install our new interrupt handler
    LDA #LO(irq_handler):STA IRQ1V
    LDA #HI(irq_handler):STA IRQ1V+1
    CLI

.return
rts

; http://abug.org.uk/index.php/2020/08/20/bbc-micro-interrupts-part-1/

.irq_handler

    ; store state
    lda interruptAccumulatorStorage:pha
    txa:pha
    ;tya:pha ; we don't use Y

    lda systemVIAInterruptFlagRegister
    and #systemVIAInterruptFlagVSync
    beq return_to_os

    ; main interrupt code

    ; do the palette setting
    inc col ; basically our frame timer

.patch_address
    ldx #5 ; number of colours to set the palette for (this is overwritten by the basic code)
.pal_loop

    ; top nibble is the logical colour to mofify we want to modify the colour at slot (frame number + loop counter) AND 15. Frame number = col, loop counter is X
    txa
    clc    
    adc col
    and #15 ; colour values range from 0-15
    beq over ; dont set palette entry 0 as that is the background. (Zero flag will have been set by the AND above)

    asl a
    asl a
    asl a
    asl a
    ; bottom nibble is the physical colour to set
    ora colours,x
    sta videoULAPaletteRegister
.over    
    dex
    bpl pal_loop

    .return_to_os

    ; restore state
    \\pla:tay ; we don't use Y
    pla:tax
    pla:sta interruptAccumulatorStorage

    ; call the previously installed interrupt handler
    jmp (old_irqv)

.main_end

.data_start

.colours
    ; the sequence of colours to set
    EQUB    PAL_black, PAL_blue, PAL_cyan, PAL_white, PAL_yellow, PAL_red
.data_end

.end ; end of data to save in binary output


; save the code and data
SAVE "Main", start, end, main

; print out some stats

PRINT "------"
PRINT "Demo"
PRINT "------"
PRINT "CODE size =", ~main_end-main_start
PRINT "DATA size =",~data_end-data_start
PRINT "------"
PRINT "HIGH WATERMARK =", ~P%
PRINT "FREE =", ~start+_DEMO_SIZE-end
PRINT "------"