var Voronoi = function(){
    var size = TDEMO.MAIN.getRendererSize();
    PartBase.call(this,
        {camera : new THREE.OrthographicCamera( -size[0]/2, size[0]/2, size[1]/2, -size[1]/2, 0.1, 2000 )});
    this.camera.position.z = 1;

    this.rtt = new THREE.WebGLRenderTarget(size[0], size[1]);
    this.rtt.texture.format = THREE.RGBFormat;
    this.rtt.texture.minFilter = THREE.NearestFilter;
    this.rtt.texture.magFilter = THREE.NearestFilter;
    this.rtt.texture.generateMipmaps = false;
    this.rtt.stencilBuffer = false;

    this.uniforms = THREE.Voronoi.uniforms;
    this.uniforms.uResolution.value = size;
    
    var pg = new THREE.PlaneBufferGeometry(this.width, this.height);
    var pm = new THREE.ShaderMaterial({
        uniforms : this.uniforms,
        vertexShader : THREE.Voronoi.vertexShader,
        fragmentShader : THREE.Voronoi.fragmentShader
    })
    this.plane = new THREE.Mesh(pg, pm);
    this.scene.add(this.plane);

    //POSTPROCESSING
    this.setEdgeDetection();
    this.setBloom(0.8);
};

Voronoi.prototype = PartBase.prototype.inheritance();

Voronoi.prototype.animate = function(elapsedTime, delta){
    PartBase.prototype.animate.call(this, elapsedTime, delta, false);

    this.near = TDEMO.SYNC.getNear();
    this.far = TDEMO.SYNC.getFar();
    this.lens = TDEMO.SYNC.getLens();
    const camp = TDEMO.SYNC.getCameraPosition();
    const camr = TDEMO.SYNC.getCameraRotation();
    
    const pos = TDEMO.SYNC.getObjPosition();
    const rot = TDEMO.SYNC.getObjRotation();
    const hb = TDEMO.SYNC.getHeartBeat();
    const edges = TDEMO.SYNC.getEdges();
    this.edge.enabled = edges;

    this.uniforms.uTime.value = elapsedTime;
};