import app
import asyncio
import random
import math

from app_components import YesNoDialog, clear_background
from events.input import Buttons, BUTTON_TYPES

from tildagonos import tildagonos

from system.eventbus import eventbus
from system.patterndisplay.events import *


text = "Spider-infested greetings Field-FX and fellow Bytejammers!!!                        "


def hsv_to_rgb(h, s, v):
    if s == 0.0:
        return v, v, v
    i = int(h*6.0)
    f = (h*6.0) - i
    p = v*(1.0 - s)
    q = v*(1.0 - s*f)
    t = v*(1.0 - s*(1.0-f))
    i = i%6
    if i == 0:
        return v, t, p
    if i == 1:
        return q, v, p
    if i == 2:
        return p, v, t
    if i == 3:
        return p, q, v
    if i == 4:
        return t, p, v
    if i == 5:
        return v, p, q


BREAK1 = 4000
BREAK2 = 8000
BREAK3 = 35000
BREAK4 = 25000
class SnakeApp(app.App):
    def __init__(self):
        # Need to call to access overlays
        super().__init__()
        eventbus.emit(PatternDisable())
        self.t = 0
        self.offsets= False
        self._x = 0



    def _exit(self):
        self.minimise()


    def update(self, delta):
        self.t = self.t + delta
        t = self.t
        self._x = -100 * t/1000
        if t<BREAK1:
            for i in range(0,12):
                tildagonos.leds[i+1] = [int(x*255) for x in ((t/1000)%1, (t/5000)%1, (t/20000)%1)]
        elif t<BREAK2:
            for i in range(0,12):
                x=math.sin(2*math.pi/12*(4*i-t/(1000/12)))
                if x>0:
                    tildagonos.leds[i+1] = (int(x*255),0,0)
                else:
                    tildagonos.leds[i+1] = (0,0,0)
        elif t<BREAK3:
            for i in range(0,12):
                r,g,b = hsv_to_rgb((i/12.+self.t/1000)%1.0,1.0,0.8)
                g=g/2
                tildagonos.leds[i+1]=[int(x*255) for x in (r,g,b)]
        else:
            for i in range(0,12):
                tildagonos.leds[i+1] = (0,0,0)

    def draw(self, ctx):
        t=self.t
        if t>BREAK3:
            return
        clear_background(ctx)
        ctx.text_baseline = ctx.MIDDLE
        ctx.font_size = 80
        #ctx.font = ctx.get_font_name(5)

        if not self.offsets:
            self.offsets=[0]
            last=0
            for i in range(len(text)):
                x=last+ctx.text_width(text[i])+10
                self.offsets.append(x)
                last=x

        ctx.save()

        # draw score
        #ctx.font_size = 12
        #width = ctx.text_width("Score: {}".format(self.score))
        #ctx.rgb(1,0,0).move_to(0 - width/2,100).text("Score: {}".format(self.score))
        if t<BREAK1:
            ctx.rgb((t/1000)%1, (t/5000)%1, (t/20000)%1).rectangle(-160, -160, 320, 320).fill()
        elif t<BREAK2:
            ctx.rotate(2*math.pi*t/1000)
            ctx.translate(-80,-80)
            ctx.rgb(1,0,0).rectangle(0, 0, 160, 160).fill()
        elif t<BREAK3:
            ctx.rotate(2*math.pi*(t/5000)**1.5)
            #ctx.line_width = 30
            for i in range(-240,240,20):
                r,g,b=hsv_to_rgb((i/(480.)+0.3+self.t/4000)%1.0,0.8,0.8)
                ctx.rgb(r,g,b).rectangle(-240,i, 480,22).fill()


        # draw food
        #for x, y in self.food:
        #    ctx.rgb(0, 1, 0).rectangle(x*5, y*5, 5, 5).fill()

        # draw snake
        #for x, y in self.snake:
        #    ctx.rgb(0, 0, 1).rectangle(x*5, y*5, 5, 5).fill()

        ctx.restore()

        if t>BREAK4:
            ctx.save()
            ctx.rgb(0,0,0).arc(0, 0, 45, 0, 2 * math.pi, True).fill()
            ctx.rgb(0, 0, 0).begin_path()
            ctx.move_to(-90,0)
            ctx.line_to(-60, -60)
            ctx.line_to(0,0)
            ctx.line_to(60, -60)
            ctx.line_to(90, 0)
            ctx.stroke()
            ctx.restore()

            ctx.save()
            ctx.rotate(-0.4)

            ctx.rgb(0, 0, 0).begin_path()
            ctx.move_to(-90,0)
            ctx.line_to(-60, -60)
            ctx.line_to(0,0)
            ctx.line_to(60, -60)
            ctx.line_to(90, 0)
            ctx.stroke()
            ctx.restore()

            ctx.save()
            ctx.rotate(0.4)
            ctx.rgb(0, 0, 0).begin_path()
            ctx.move_to(-90,0)
            ctx.line_to(-60, -60)
            ctx.line_to(0,0)
            ctx.line_to(60, -60)
            ctx.line_to(90, 0)
            ctx.stroke()
            ctx.restore()

            ctx.save()
            ctx.rotate(0.6)
            ctx.rgb(0, 0, 0).begin_path()
            ctx.move_to(-90,0)
            ctx.line_to(-60, -60)
            ctx.line_to(0,0)
            ctx.line_to(60, -60)
            ctx.line_to(90, 0)
            ctx.stroke()
            ctx.restore()
            ctx.rgb(255,0,0).arc(20, -20, 5, 0, 2 * math.pi, True).fill()
            ctx.rgb(255,0,0).arc(-20, -20, 5, 0, 2 * math.pi, True).fill()

        for i in range(len(text)):
            x=self._x+self.offsets[i]
            if x>-160 and x<160:
                #ctx.rgb(self._x+30*i,self._x+30*i,self._x+30*i)
                ctx.font_size = 86
                ctx.move_to(x-3, 15*math.sin((x)/30)+20*math.cos((x)/22)-3)
                #ctx.save()
                ctx.rgb(0,0,0).text(text[i])
                ctx.font_size = 81
                ctx.move_to(x-1, 15*math.sin((x)/28)+20*math.cos((x)/22))
                #ctx.save()
                ctx.rgb(1,1,1).text(text[i])
                ##ctx.restore()

        #if self.dialog:
        #    self.dialog.draw(ctx)

__app_export__ = SnakeApp
