/*
 * Decompiled with CFR 0.152.
 */
package bk2010.util;

import bk2010.util.Log;
import bk2010.util.LogBuffer;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Locale;

public final class BootLog {
    private static boolean disabled = false;
    private static boolean writerDisabled = false;
    private static FileWriter fw;
    private static final LogBuffer history;
    private static Object updateLock;

    static {
        history = new LogBuffer();
        updateLock = new Object();
    }

    private BootLog() {
    }

    private static void display(String message) {
        history.append(message);
        Log.l(message);
    }

    private static FileWriter getWriter() {
        if (writerDisabled) {
            return null;
        }
        if (fw == null) {
            String fullName = "bk2010_boot.log";
            File lf = new File(fullName);
            try {
                fullName = lf.getCanonicalPath();
                fw = new FileWriter(fullName);
            }
            catch (IOException e) {
                BootLog.display("ERROR: Cannot create boot log file " + fullName);
                writerDisabled = true;
            }
        }
        return fw;
    }

    private static void closeLog() {
        FileWriter ffw = fw;
        fw = null;
        writerDisabled = true;
        if (ffw != null) {
            try {
                ffw.close();
            }
            catch (IOException e) {
                BootLog.display(String.format(Locale.ROOT, "ERROR: Exception while closing the log file (%s).", e.getMessage()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void append(String line) {
        if (disabled) {
            return;
        }
        Object object = updateLock;
        synchronized (object) {
            BootLog.display(line);
            FileWriter writer = BootLog.getWriter();
            if (writer != null) {
                try {
                    writer.write(line);
                    writer.write(10);
                    writer.flush();
                }
                catch (IOException e) {
                    BootLog.display("ERROR: Failed to write to the log file, closing it.");
                    BootLog.closeLog();
                }
            }
        }
    }

    public static void l(String line) {
        if (disabled) {
            return;
        }
        BootLog.append(line);
    }

    public static void l(String format, Object ... args) {
        if (disabled) {
            return;
        }
        BootLog.append(String.format(Locale.ROOT, format, args));
    }

    public static void stop() {
        disabled = true;
        BootLog.closeLog();
    }

    public static LogBuffer getHistory() {
        return history;
    }
}

