/*
 * Decompiled with CFR 0.152.
 */
package bk2010.preferences.types;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;

public class CommandAlias {
    public final String name;
    public final int minParams;
    public final int maxParams;
    String[] expanded;

    public CommandAlias(String name, int minParams, int maxParams, String[] expanded) {
        this.name = name;
        this.minParams = minParams;
        this.maxParams = maxParams;
        this.expanded = expanded;
    }

    public boolean fits(String[] args, int position) {
        if (args == null || position < 0 || position >= args.length - this.minParams) {
            return false;
        }
        if (!args[position].equalsIgnoreCase(this.name)) {
            return false;
        }
        if (this.maxParams == 0) {
            return true;
        }
        int i = 0;
        while (i < this.minParams) {
            int ppos = i + position + 1;
            if (args[ppos].charAt(0) == '-') {
                return false;
            }
            ++i;
        }
        return true;
    }

    public int expand(String[] args, int position, List<String> target) {
        if (args == null || position < 0 || position >= args.length - this.minParams) {
            return 0;
        }
        if (!args[position].equalsIgnoreCase(this.name)) {
            return 0;
        }
        String[] stringArray = this.expanded;
        int n = this.expanded.length;
        int n2 = 0;
        while (n2 < n) {
            String str = stringArray[n2];
            target.add(str);
            ++n2;
        }
        if (this.maxParams == 0) {
            return 1;
        }
        int argc = 1;
        while (argc <= this.maxParams) {
            int ppos = position + argc;
            if (ppos >= args.length || args[ppos].charAt(0) == '-') {
                return argc;
            }
            target.add(args[ppos]);
            ++argc;
        }
        return argc;
    }

    static void testExpand(CommandAlias alias, String[] test) {
        LinkedList<String> target = new LinkedList<String>();
        System.out.printf("\nTesting string %s\n", Arrays.deepToString(test));
        int i = 0;
        while (i < test.length) {
            if (!alias.fits(test, i)) {
                target.add(test[i]);
            } else {
                System.out.printf("Fits at position %d\n", i);
                i += alias.expand(test, i, target) - 1;
            }
            ++i;
        }
        System.out.printf("Result: %s\n", target.toString());
    }

    public static void main(String[] args) {
        String[] exp = new String[]{"-expanded", "P", "Q"};
        String[] nmtest = new String[]{"a", "b", "c"};
        String[] exptest = new String[]{"a", "-test", "c"};
        String[] mintest = new String[]{"a", "-test"};
        String[] maxtest = new String[]{"a", "-test", "c", "d", "e", "f"};
        String[] dbltest = new String[]{"a", "-test", "c", "-test", "d", "e", "f"};
        CommandAlias alias = new CommandAlias("-test", 1, 2, exp);
        CommandAlias.testExpand(alias, nmtest);
        CommandAlias.testExpand(alias, exptest);
        CommandAlias.testExpand(alias, mintest);
        CommandAlias.testExpand(alias, maxtest);
        CommandAlias.testExpand(alias, dbltest);
    }
}

