/*
 * Decompiled with CFR 0.152.
 */
package bk2010.io;

import bk2010.io.JoyFunction;
import java.awt.event.KeyEvent;
import java.util.HashMap;

public final class JoystickMapper {
    private static final int JK_A = 10;
    private static final int JK_B1 = 11;
    private static final int JK_B2 = 12;
    private static final int JK_C = 13;
    private static final int JK_D = 14;
    private static final int JK_COUNT = 15;
    private boolean[] keysDown = new boolean[15];
    private boolean[] altKeysDown = new boolean[JoyFunction.values().length];
    private boolean altKeysEnabled;
    private HashMap<Integer, JoyFunction> altKeyMap = new HashMap(15);

    public boolean translateKey(KeyEvent evt, boolean isDown) {
        if (evt.getKeyLocation() != 4) {
            if (!this.altKeysEnabled) {
                return false;
            }
            int code = evt.getKeyCode();
            JoyFunction func = this.altKeyMap.get(code);
            if (func == null) {
                return false;
            }
            this.altKeysDown[func.ordinal()] = isDown;
            return true;
        }
        int code = evt.getKeyCode();
        switch (code) {
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: {
                this.keysDown[code - 96] = isDown;
                break;
            }
            case 108: 
            case 110: 
            case 127: {
                this.keysDown[10] = isDown;
                break;
            }
            case 107: 
            case 521: {
                this.keysDown[12] = isDown;
                break;
            }
            case 10: {
                this.keysDown[11] = isDown;
                break;
            }
            case 111: {
                this.keysDown[13] = isDown;
                break;
            }
            case 106: {
                this.keysDown[14] = isDown;
                break;
            }
        }
        return true;
    }

    public int getJoystickState() {
        int state = 0;
        if (this.keysDown[7] || this.keysDown[8] || this.keysDown[9]) {
            state |= 1;
        }
        if (this.keysDown[1] || this.keysDown[2] || this.keysDown[3] || this.keysDown[5]) {
            state |= 4;
        }
        if (this.keysDown[1] || this.keysDown[4] || this.keysDown[7]) {
            state |= 8;
        }
        if (this.keysDown[3] || this.keysDown[6] || this.keysDown[9]) {
            state |= 2;
        }
        if (this.keysDown[0] || this.keysDown[10]) {
            state |= 0x20;
        }
        if (this.keysDown[11] || this.keysDown[12]) {
            state |= 0x40;
        }
        if (this.keysDown[13]) {
            state |= 0x80;
        }
        if (this.keysDown[14]) {
            state |= 0x10;
        }
        int i = 0;
        while (i < this.altKeysDown.length) {
            boolean b = this.altKeysDown[i];
            if (b) {
                state |= JoyFunction.values()[i].bitMask;
            }
            ++i;
        }
        return state;
    }

    public boolean enableAltKeys(boolean enable) {
        boolean oldEnable = this.altKeysEnabled;
        this.altKeysEnabled = enable;
        return oldEnable;
    }

    public void setAltKey(int scanCode, JoyFunction function) {
        Integer sc = scanCode;
        this.altKeyMap.put(sc, function);
    }
}

