/*
 * Decompiled with CFR 0.152.
 */
package bk2010.hardware.bus.registers;

import bk2010.HeartbeatListener;
import bk2010.hardware.TimeSource;
import bk2010.hardware.bus.QBusReadDTO;
import bk2010.hardware.bus.QBusSimpleSlave;

public final class CPUTimer
extends QBusSimpleSlave
implements HeartbeatListener {
    private static final int TMR_STOP = 1;
    private static final int TMR_WRAPAROUND = 2;
    private static final int TMR_EXPIRECHECK = 4;
    private static final int TMR_SINGLEPASS = 8;
    private static final int TMR_RUN = 16;
    private static final int TMR_DIV16 = 32;
    private static final int TMR_DIV4 = 64;
    private static final int TMR_EXPIRED = 128;
    private short start = (short)4608;
    private short count = (short)-1;
    private short config = (short)-256;
    private long cycles = 0L;
    private long divisor = 128L;
    private TimeSource timeSource;

    @Override
    public int getBaseAddress() {
        return 65478;
    }

    @Override
    public int getNumWords() {
        return 3;
    }

    @Override
    public boolean gotInterrupt() {
        return false;
    }

    @Override
    public byte interruptVector() {
        return 0;
    }

    @Override
    public int peekWord(int addr) {
        switch (addr) {
            case 65478: {
                return this.start & 0xFFFF;
            }
            case 65480: {
                return this.count & 0xFFFF;
            }
            case 65482: {
                return this.config & 0xFFFF;
            }
        }
        return -1;
    }

    @Override
    public boolean readWord(int addr, QBusReadDTO result, boolean opcode) {
        this.updateTimer();
        int read = this.peekWord(addr);
        if (read >= 0) {
            result.value = (short)read;
            return true;
        }
        return false;
    }

    @Override
    public boolean writeByteAsWord(int addr, short data) {
        return this.writeWord(addr, data);
    }

    @Override
    public boolean writeWord(int addr, short data) {
        this.updateTimer();
        switch (addr) {
            case 65478: {
                this.start = data;
                return true;
            }
            case 65480: {
                return true;
            }
            case 65482: {
                this.setConfig(data);
                return true;
            }
        }
        return false;
    }

    @Override
    public void reset() {
        this.start = (short)4608;
        this.count = (short)-1;
        this.config = (short)-256;
    }

    private void setConfig(short data) {
        int tmp = 128;
        if ((data & 0x40) != 0) {
            tmp *= 4;
        }
        if ((data & 0x20) != 0) {
            tmp *= 16;
        }
        this.divisor = tmp;
        this.count = this.start;
        this.config = (short)(data | 0xFF00);
    }

    private void updateTimer() {
        long now = this.timeSource.getCycles();
        if (now - this.cycles < this.divisor) {
            return;
        }
        long ticks = (now - this.cycles) / this.divisor;
        this.cycles += ticks * this.divisor;
        if ((this.config & 1) != 0) {
            this.count = this.start;
            return;
        }
        if ((this.config & 0x10) == 0) {
            return;
        }
        if (ticks < 1L) {
            return;
        }
        int tmp = this.count & 0xFFFF;
        if ((tmp = (int)((long)tmp - ticks)) > 0) {
            this.count = (short)tmp;
            return;
        }
        if ((this.config & 4) != 0) {
            this.config = (short)(this.config | 0x80);
        }
        if ((this.config & 2) == 0) {
            if ((this.config & 8) != 0) {
                this.config = (short)(this.config & 0xFFFFFFEF);
                this.count = this.start;
                return;
            }
            if (tmp < 1 && this.start != 0) {
                while (tmp < 1) {
                    tmp += this.start & 0xFFFF;
                }
            }
        }
        this.count = (short)tmp;
    }

    public void setTimeSource(TimeSource source) {
        this.timeSource = source;
    }

    @Override
    public void invoke() {
        this.updateTimer();
    }
}

