#ifndef MATERIAL_H
#define MATERIAL_H

#include "cgltf.h"
#include "gl.h"

typedef struct {
    size_t base_color_texture;
    size_t metallic_roughness_texture;
    size_t normal_texture;
    size_t occlusion_texture;
    size_t emissive_texture;
    GLfloat base_color_factor[4];
    GLfloat metallic_factor;
    GLfloat roughness_factor;
    GLfloat emissive_factor[3];
    GLint double_sided;
    GLint unlit;
} material_t;

void material_log(cgltf_material *material, cgltf_data *data);
void material_default(material_t *material_out);
void material_init(material_t *material_out, cgltf_material *material,
                   cgltf_data *data);

#endif
