#ifndef BLOOM_H
#define BLOOM_H

#include "config.h"
#include "fbo.h"
#include "pass.h"
#include "shader.h"

#define BLOOM_FBS 2

typedef struct {
    GLuint textures[BLOOM_FBS];
    fbo_t *fbs[BLOOM_FBS * BLOOM_LEVELS];
    program_t pre_program;
    program_t blur_x_programs[BLOOM_LEVELS];
    program_t blur_y_programs[BLOOM_LEVELS];
} bloom_t;

bloom_t *bloom_init(pass_renderer_t *pass_renderer, GLsizei width,
                    GLsizei height);

void bloom_deinit(bloom_t *bloom);

void bloom_render(bloom_t *bloom, pass_render_parameters_t *parameters);

GLuint bloom_get_texture(bloom_t *bloom);

#endif
