precision highp float;

#define PI 3.14159265

out vec4 FragColor;

in vec2 FragCoord;

uniform float u_RocketRow;
uniform vec2 u_Resolution;

uniform sampler2D u_FeedbackSampler;

vec2 tunnelcoords() {
    float aspect = u_Resolution.x / u_Resolution.y;
    vec2 uv = FragCoord * vec2(aspect, 1.);
    uv = vec2(atan(uv.x, uv.y), 1. / length(uv));
    uv.y += u_RocketRow * PI * (1. / 64.);
    uv = vec2(sin((uv.y * 16.)), sin((uv.x * 16.) - u_RocketRow * 0.04 * PI * 2.));
    return uv;
}

vec2 simplecoords() {
    return FragCoord + vec2(sin(FragCoord.y * 20. + u_RocketRow) * 0.3 + sin(u_RocketRow * PI * (1. / 16.)) * 2., sin(FragCoord.y) + cos(u_RocketRow * PI * (1. / 64.)) * 2.);
}

void main() {
    vec2 uv = mix(tunnelcoords(), simplecoords(), sin(u_RocketRow * (1. / 33.)) * 0.5 + 0.5);
    //uv = tunnelcoords();
    float f = sin(uv.x) * 0.7 + sin(uv.y) * 0.7 + 0.6;
    FragColor = vec4(clamp(vec3(f * 5.) + min(FragCoord.y * 10., 0.), 0., 10.), 1.);
}
