	; diamonds.asm
	; Created by dOc.K on 31.12.23.

	ORG	2A13H		; start address

	; Initial register state
	;
	; A  = 0CH	cassette control bits
	; HL = 2A13H	start address (H = star ascii code, L = width and heigth)
	; BC = 0000H	left zero from ldir
	; DE = 2A2DH	end address

	LD	B,L		; initialize B with start row
	LD	A,18-3		; initialize C with start column

LOOP:	LD	C,A
	LD	(0B7A0H),BC	; set cursor position
	LD	A,H		; store '*' in A (parameter value for system routine call that follows)
	CALL	0E329H		; call system routine "CRT"

	LD	A,18		; mirror horizontal
	SUB	C

	DEC	D
	JR	NZ,LOOP

	SUB	6		; next horizontal step
	JR	NC,LOOP

	ADD	L		; wrap horizontal

	DJNZ	LOOP		; next row

	RET
