;###############################################################################
;
; Yellow-Snow
; An Entry for the Vintage Computing Christmas Challenge 2023
; for the Amstrad CPC by Dave Moore
;
; Example compilation with rasm under Linux:
;
; ../rasm/rasm_linux64 -eo ./main-rasm.asm
;
;###############################################################################

; Info
PRINT
PRINT "Y E L L O W S N O W"
PRINT "(c) Dave Moore 2023"
PRINT

; Choose output type (Binary File/Disk Image/Tape Image)
DESTINATION = 2

; Set destination (code is completely relocatable)
BASE_LOAD_ADDRESS = #8000
PRINT "Base Load Address is", {hex}BASE_LOAD_ADDRESS

;###############################################################################
;
; Beginning of ASM
;
;###############################################################################


ORG     #8000
BEGIN_CODE

begin:
        ld      ix, location
        ld      b, 9
start:
        ld      h, (ix + 1)
        ld      l, (ix + 0)
        call    TXT_SET_CURSOR
        call    draw
        inc     ix
        inc     ix
        djnz    start
    
finish:
        ret

draw:	
        push    bc
        ld      b, data_end - data_begin
        ld      de, data_begin
loop:	ld      a, (de)
        call    TXT_OUTPUT
        inc     de
        djnz    loop
        pop     bc
        ret

.locate
        call    TXT_SET_CURSOR
        ret

data_begin:
        DEFB    #2a
        DEFB    #0b, #2a, #0b, #2a, #0b, #2a
        DEFB    #0a, #2a, #0a, #2a, #0a, #2a
        DEFB    #0a, #08, #08, #2a, #0a, #08, #08, #2a, #0a, #08, #08, #2a
        DEFB    #0b, #08, #08, #2a, #0b, #08, #08, #2a, #0b, #08, #08, #2a
data_end:
location:
        DEFB    #04, #01, #04, #07, #04, #0d
        DEFB    #0a, #01, #0a, #07, #0a, #0d
        DEFB    #10, #01, #10, #07, #10, #0d

TXT_OUTPUT      equ     #bb5a           ; Print a Character (PRINT)
TXT_SET_CURSOR  equ     #bb75           ; Set the Cursor Position (LOCATE)

;###############################################################################
;
; End of ASM
;
;###############################################################################

END_CODE

; Output to Binary File, Disk Image, or Tape Image
IF DESTINATION == 1
        PRINT "Saving to Binary File"
        SAVE 'yellsnow.bin', BEGIN_CODE, END_CODE - BEGIN_CODE
        PRINT
ELSEIF DESTINATION == 2
        PRINT "Saving to Disk Image"
        SAVE 'yellsnow.bin', BEGIN_CODE, END_CODE - BEGIN_CODE, DSK, 'yellsnow.dsk'
        PRINT
ELSEIF DESTINATION == 3
        PRINT "Saving to Tape Image"
        SAVE 'yellsnow.bin', BEGIN_CODE, END_CODE - BEGIN_CODE, TAPE, 'yellsnow.cdt'
        PRINT
ENDIF
