    
    device zxspectrum48
    ; This will tell us how big the code is
    output star-four.code
    org $ff00

AT = 0x16
ROM_CLS = 0x0DAF
STARFIELD_SIZE_PLUS_ONE = 20
STARFIELD_SIZE = 19
STARFIELD_OFF_START = 16

START:
    ; Without this print at doesn't quite work.
    ; call ROM_CLS
    ; Border
    ; ld a, 1
    ; call 8859 

    ; Draw
    ld l, STARFIELD_SIZE
    ld h, STARFIELD_OFF_START

MORE_LINES:
    ; Call the draw lines function
    ; three times, at points 19,16 19,10 and 19,4
    ; Uses all registers
    ld b, h
    ld c, l
    call DRAW_MRRORED_LINE
    ld a, h
    sub 6
    ld h, a
    jr nc, MORE_LINES
    ret

DRAW_MRRORED_LINE:
    ; Draw four lines
    ; Register b is Y-coord
    ; Register c is X-coord
    ; Registers d, e are used as counters
    ;
    ; Draw up and left from the input co-ordinates.
    ; However we use a four way mirror to draw three more.
    ld d, 2
    ld e, d

DRAW_MRRORED_LINE_INNER:
    ld a, AT
    rst $10
    ; Y
    ld a, b
    rst $10
    ; X
    ld a, c
    rst $10
    ; *
    ld a, "*"
    rst $10
    
    ; Reflect the Y co-ordinate
    ld a, STARFIELD_SIZE_PLUS_ONE
    sub b
    ld b, a
    dec d
    jr nz, DRAW_MRRORED_LINE_INNER
    ; Reset d to two. It does work without this, but it won't like you.
    ld d, e
    ; Reflect the X co-ordinate
    ld a, STARFIELD_SIZE_PLUS_ONE
    sub c
    ld c, a
    dec e
    jr nz, DRAW_MRRORED_LINE_INNER

    dec c
    ; dec b and continue if not zero
    djnz DRAW_MRRORED_LINE

EXIT_DRAW_MRRORED_LINE:
    ret
    
    savesna "star-four.sna", START