    
    device zxspectrum48
    output star-four.code
    org $ff00

AT = 0x16
ROM_CLS = 0x0DAF
STARFIELD_SIZE_PLUS_ONE = 20
STARFIELD_SIZE = 19
STARFIELD_OFF_START = 16

START:
    ld l, STARFIELD_SIZE
    ld h, STARFIELD_OFF_START

MORE_LINES:
    ld b, h
    ld c, l
    call DRAW_MRRORED_LINE
    ld a, h
    sub 6
    ld h, a
    jr nc, MORE_LINES
    ret

DRAW_MRRORED_LINE:
    ld d, 2
    ld e, d

DRAW_MRRORED_LINE_INNER:
    ld a, AT
    rst $10
    ld a, b
    rst $10
    ld a, c
    rst $10
    ld a, "*"
    rst $10
    ld a, STARFIELD_SIZE_PLUS_ONE
    sub b
    ld b, a
    dec d
    jr nz, DRAW_MRRORED_LINE_INNER
    ld d, e
    ld a, STARFIELD_SIZE_PLUS_ONE
    sub c
    ld c, a
    dec e
    jr nz, DRAW_MRRORED_LINE_INNER

    dec c
    djnz DRAW_MRRORED_LINE

EXIT_DRAW_MRRORED_LINE:
    ret
    
    savesna "star-four.sna", START