; DIAMONDS.ASM - PRINT DIAMONDS ON THE CONSOLE
; VINTAGE COMPUTING CHRISTMAS CHALLENGE 2023 (VC3 2023)
; WRITTEN BY SERGEY KISELEV <SKISELEV@GMAIL.COM>
;
; RUNS ON CP/M SYSTEMS WITH INTEL 8080, ZILOG Z80
;   AND COMPATIBLE PROCESSORS
;
; BUILDING AND RUNNIG STEPS:
; A>ASM DIAMONDS
; A>LOAD DIAMONDS
; A>DIAMONDS

BDOS	EQU	5
WCHAR	EQU	2
SIZE	EQU	19

	ORG	0100H
	MVI	H,SIZE		; ROW COUNTER
	LXI	B,0406H		; B - POSITION OF THE FIRST STAR IN A ROW
				; C - DELTA FOR THE SECOND STAR IN A ROW

LOOPY:
	MVI	L,SIZE		; COLUMN COUNTER

LOOPX:
; PRINT STAR IF ONE OF THE CONDITIONS BELOW IS TRUE
	MVI	E,'*'
	DCR	B		; DECREMENT B
	JNZ	CHECKC		; B == 0?
	MVI	B,6
	JMP	PRINT
CHECKC:
	MOV	A,B
	CMP	C		; B == C?
	JZ	PRINT
; OTHERWISE PRINT SPACE
	MVI	E,' '
PRINT:
	CALL	PUTC		; OUTPUT TO THE CONSOLE
DECCOL:
	DCR	L		; DECREMENT THE COLUMN COUNTER
	JNZ	LOOPX		; JUMP IF NOT AT THE LAST COLUMN
	MVI	E,0DH		; CARRIAGE RETURN
	CALL	PUTC		; OUTPUT TO THE CONSOLE
	MVI	E,0AH		; LINE FEED
	CALL	PUTC		; OUTPUT TO THE CONSOLE
	DCR	C		; C = C - 2; NOTE: C IS EVEN, CAN'T BE 0 HERE
	DCR	C		; C ONLY CAN BE 0 HERE
	JNZ	DECROW		; C == 0?
	MVI	C,6		; C = 6
DECROW:
	DCR	H		; DECREMENT THE ROW COUNTER
	JNZ	LOOPY		; JUMP IF NOT AT THE LAST ROW
	RET			; RETURN TO CP/M

; PUTC - PRINT THE CHARACTER FROM REGISTER E TO THE CONSOLE
PUTC:
	PUSH	B		; CP/M TRASHES REGISTERS, SAVE THEM
	PUSH	H
	MVI	C,WCHAR
	CALL	BDOS		; OUTPUT TO THE CONSOLE
	POP	H
	POP	B
	RET

	END
