        output "VCCC2023.COM"

        org     0x00f0
        db      00,05
        dw      codeEnd - 0x0100
        db      00,00,00,00,00,00,00,00,00,00,00,00

; ======================================================================

        di
        ld   sp, 0x0100

        ; init video screen
        ld   ix,(0xbff4)        ; EXOS LPT address
        ld   hl, 0x0c000        ; activate 40*19 screen
        ld   b, 19              ; 19 lines
scron:  ld   (ix+0x12), 0x0b
        ld   (ix+0x13), 0x73
        ld   (ix+0x14), l
        ld   (ix+0x15), h
        ld   de,0010h
        add  ix,de
        inc  h
        djnz scron

        ; clear screen
        res  6, h           ; HL = 0x9300
clrscr: ld   (hl), " "
        dec  hl
        bit  7, h
        jr   nz, clrscr

; ======================================================================

        ld   hl, data
        call six_lines          ; draws 6 diagonal lines (top left to bottom right)
        ld   a, 0x25            ; DEC H opcode
        ld   (draw_diag.l2), a  ; switch direction of drawing routine
        ld   l, low data2
        call six_lines          ; draws 6 diagonal lines (bottom left to top right)
vege:   jr   vege

; ======================================================================

six_lines:

        ld   b, 6
.l1:    ld   e, (hl)
        inc  hl
        ld   d, (hl)
        inc  hl
        ex   de, hl
        call draw_diag
        ex   de, hl
        djnz .l1
        ret

        ; start screen address of lines
data:   dw   0x8003, 0x8009, 0x800f
data2:  dw   0x8300, 0x8900, 0x8f00
        dw   0x9203, 0x9209, 0x920f

; ======================================================================

draw_diag:
;input: H = X, L = Y

.l1:    ld   (hl), "*"      ; print "*"
.l2:    inc  h              ; Y = Y + 1 (will be overrided with dec hl -> Y = Y - 1)
        inc  l              ; X = X + 1
        ld   a, h
        or   a
        ret  p
        cp   0x80 + 19
        ret  z
        ld   a, l
        cp   19
        ret  z
        jr   .l1

; ======================================================================

codeEnd: equ    $

        end
