; assembler:
; 64tass.exe --version
; 64tass Turbo Assembler Macro V1.58.2974
;
; compile:
; 64tass.exe --m6502 xmas.asm -o xmas.prg

    *=$0801
    .byte $0b,$08,$e8,$03,$9e,$32,$30,$36,$31,0,0,0 ; 1000 SYS2061

; the picture has 32 pixel border on the left, and 35 pixel border at the top
ytop = $33-30-1 ; we go only 30 pixels as 35 does not look good in the emulator
; and we also start from -24 instead of -32 so there is a visible white border around

    sei

    ldx #$00
-
    lda #$00
    sta $3f00,x
    lda #$ff
    sta $3e00,x
    inx
    bne -

    ldx #6
-   ldy spinit-1,x
    lda #%01100110
    sta $3f00,y
    sta $3f0c,y
    lda #%00111100
    sta $3f03,y
    sta $3f09,y
    lda #%11111111
    sta $3f06,y
    dex
    bne -

    lda #$fd
    sta $07f8
    sta $07fa
    sta $07fc
    lda #$fc
    sta $07f9
    sta $07fb
    sta $07fd
    lda #$ff
    sta $03f8
    sta $03fa
    sta $03fc
    sta $03f9
    sta $03fb
    sta $03fd
    lda #$fb
    sta $03fe
    sta $07fe
    sta $03ff
    sta $07ff

;    lda #$cc
;    sta $3fff

loop:
    lda #$f2
-   cmp $d012
    bne -


    ldx #$2e
-   lda d000_init,x
    sta $d000,x
    dex
    bpl -

    lda #$09
-   cmp $d012 ; finishes at VC == 0..6
    bne -     ; 1..7
    bit $d011 ; 3
    bmi -     ; 8

    ldy #7    ; 10
-   dey       ; 12
    bne -     ; 14

    ldx #10      ; should start at 63-6-2=55
raster_fix:
    lda $d012    ; 0 (64/63)
    cmp $d012    ; 4
    beq +        ; 8
+
    cmp ($00,x)  ; 11/10
    cmp ($00,x)
    cmp ($00,x)
    cmp ($00,x)
    cmp ($00,x)
    cmp ($00,x)
    cmp ($00,x)
    cmp ($00,x)
    dex          ; 59/58
    bne raster_fix ; 61/60


    lda #$08
    sta $d011
    lda #$ff
    sta $d015

    cmp ($00,x)
    cmp ($00,x)
    nop
    nop
    ldx #$08
    lda #$01

    jsr delayedsax16
    sax $d021

    cmp ($00,x)
    nop
    nop

    jsr wait16
    jsr wait19lines

    ldy #ytop+1+24*1
    jsr set_sprite_y
    sax $d021

    ldy #ytop+0+42*1
    jsr row_1

    ldy #ytop+1+24*2
    jsr set_sprite_y
    sax $d021

    ldy #ytop+0+42*1
    jsr row_2

    ldy #ytop+1+24*3
    jsr set_sprite_y
    sax $d021

    ldy #ytop+0+42*2
    jsr row_1

    ldy #ytop+1+24*4
    jsr set_sprite_y
    sax $d021

    ldy #ytop+0+42*2
    jsr row_2

    ldy #ytop+1+24*5
    jsr set_sprite_y
    sax $d021

    ldy #ytop+0+42*3
    jsr row_1

    ldy #ytop+1+24*6
    jsr set_sprite_y
    sax $d021

    ldy #ytop+0+42*4
    sty $d00d
    sty $d00f
    cmp ($00,x)
    jsr set_sprite_x_2

    jsr wait16
    jsr wait16
    jsr wait16
    jsr wait16
    jsr wait16

    ldy #$00
    sty $d018
    jsr wait10

    jsr wait16
    jsr wait16
    jsr wait16
    jsr wait16
    jsr wait16
    jsr wait16
    jsr wait16
    jsr wait16
    jsr wait16
    jsr wait16
    jsr wait16
    jsr wait16
    jsr wait16
    jsr wait16

    jsr delayedsax16
    sax $d021

    cmp ($00,x)
    cmp ($00,x)
    cmp ($00,x)
    cmp ($00,x)
    cmp ($00,x)

    ldy #33
-   sta $d021
    dec $d016
    stx $d016
    cmp ($00,x)
    sax $d021
    cmp ($00,x)
    cmp ($00,x)
    cmp ($00,x)
    cmp ($00,x)
    bit $00
    dey
    bne -

    sta $d02d
    sta $d021
    sta $d02e

nop
    jmp loop

delayedsax16:
    cmp ($00,x)
delayedsax10:
    nop
delayedsax8:
    nop
    nop
delayedsax4:
    nop
    nop

delayedsax0:
    sta $d021

    dec $d016
    stx $d016

    rts

wait16:
    nop
    nop
    nop
wait10:
    nop
wait8:
    nop
    nop
wait4:
    nop
    nop
wait0:
    sta $d021

    dec $d016
    stx $d016
    sax $d021

    rts

wait19lines:
    jsr wait10
    jsr wait16
    jsr wait16
    jsr wait16
    jsr wait16
    jsr wait16
    jsr wait16
    jsr wait16
    jsr wait16
    jsr wait16
    jsr wait16
    jsr wait16
    jsr wait16
    jsr wait16
    jsr wait16
    jsr wait16
    jsr wait16
    jsr wait16
    bit $00
    jmp wait16

set_sprite_y:
    sty $d001
    sty $d003
    jsr wait0

    sty $d005
    sty $d007
    sty $d009
    sty $d00b
    bit $00
    jmp delayedsax0

set_sprite_x_1:
    jsr delayedsax4
    sax $d021

    ldy #$20
    sty $d000
    ldy #$00
    sty $d002
    ldy #$50
    sty $d004
    jsr delayedsax8
    sax $d021

    ldy #$30
    sty $d006
    ldy #$80
    sty $d008
    ldy #$60
    sty $d00a
    bit $00
    jmp wait8

set_sprite_x_2:
    jsr delayedsax4
    sax $d021

    ldy #$08
    sty $d000
    ldy #$18
    sty $d002
    ldy #$38
    sty $d004
    jsr delayedsax8
    sax $d021

    ldy #$48
    sty $d006
    ldy #$68
    sty $d008
    ldy #$78
    sty $d00a
    bit $00
    jmp wait8


row_1:
    sty $d00d
    sty $d00f
    jsr set_sprite_x_1

    bit $00
    jmp wait19lines

row_2:
    sty $d00d
    sty $d00f
    jsr set_sprite_x_2

    bit $00
    jmp wait19lines



d000_init:
.byte $08,ytop+1,$18,ytop+1,$38,ytop+1,$48,ytop+1     ; d000
.byte $68,ytop+1,$78,ytop+1,$00,ytop+0,$10,ytop+0     ; d008
.byte $80,$00,$00,$00,$00,$00,$08,$c0                 ; d010
.byte $10,$00,$00,$00,$00,$c0,$00,$00                 ; d018
.byte $01,$01,$00,$00,$00,$00,$00,$01                 ; d020
.byte $01,$01,$01,$01,$01,$00,$00                     ; d028

spinit:
.byte 0*24+0,1*24+1,2*24+2
.byte 64+0*24+2,64+1*24+1,64+2*24+0
